package org.wildfly.swarm.bootstrap.modules;

import org.jboss.modules.Environment;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParserBridge;
import org.jboss.modules.ResourceLoader;
import org.wildfly.swarm.bootstrap.util.Layout;

import java.io.IOException;
import java.io.InputStream;

/** Used only for loading dependencies of org.wildfly.bootstrap:main from its own jar.
 *
 * @author Bob McWhirter
 */
public class BootstrapClasspathModuleFinder implements ModuleFinder {

    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        final String path = "modules/" + identifier.getName().replace('.', '/') + "/" + identifier.getSlot() + "/module.xml";

        ClassLoader cl = BootstrapClasspathModuleFinder.class.getClassLoader();
        InputStream in = cl.getResourceAsStream(path);

        if (in == null) {
            return null;
        }

        ModuleSpec moduleSpec = null;
        try {
            moduleSpec = ModuleXmlParserBridge.parseModuleXml(new ModuleXmlParserBridge.ResourceRootFactoryBridge() {
                @Override
                public ResourceLoader createResourceLoader(final String rootPath, final String loaderPath, final String loaderName) throws IOException {
                    return Environment.getModuleResourceLoader(rootPath, loaderPath, loaderName);
                }
            }, "/", in, path.toString(), delegateLoader, identifier);

        } catch (IOException e) {
            e.printStackTrace();
            throw new ModuleLoadException(e);
        } catch (Throwable t) {
            t.printStackTrace();
            throw t;
        } finally {
            try {
                in.close();
            } catch (IOException e) {
                throw new ModuleLoadException(e);
            }
        }
        return moduleSpec;

    }
}
