/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.m2;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wildfly.swarm.bootstrap.m2.RepositoryResolver;

public class LocalRepositoryResolver
extends RepositoryResolver {
    @Override
    public File resolve(String gav) throws IOException {
        Path m2repo = this.findM2Repo();
        Path artifactPath = m2repo.resolve(this.gavToPath(gav));
        if (Files.notExists(artifactPath, new LinkOption[0])) {
            return null;
        }
        return artifactPath.toFile();
    }

    private Path findM2Repo() {
        String mavenHome;
        Path m2repo = Paths.get(System.getProperty("user.home"), ".m2", "repository");
        if (Files.notExists(m2repo, new LinkOption[0]) && (mavenHome = System.getenv("MAVEN_HOME")) != null && Files.notExists(m2repo = Paths.get(mavenHome, "repository"), new LinkOption[0])) {
            return null;
        }
        return m2repo;
    }
}

