/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.container.runtime;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployer;
import org.wildfly.swarm.container.runtime.ServerConfiguration;
import org.wildfly.swarm.container.runtime.SimpleContentProvider;

public class RuntimeDeployer
implements Deployer {
    private final ModelControllerClient client;
    private final SimpleContentProvider contentProvider;
    private final List<ServerConfiguration> configurations;
    private final TempFileProvider tempFileProvider;
    private final List<Closeable> mountPoints = new ArrayList<Closeable>();

    public RuntimeDeployer(List<ServerConfiguration> configurations, ModelControllerClient client, SimpleContentProvider contentProvider, TempFileProvider tempFileProvider) throws IOException {
        this.configurations = configurations;
        this.client = client;
        this.contentProvider = contentProvider;
        this.tempFileProvider = tempFileProvider;
    }

    public void deploy(Archive deployment) throws IOException {
        for (ServerConfiguration each : this.configurations) {
            each.prepareArchive(deployment);
        }
        VirtualFile mountPoint = VFS.getRootVirtualFile().getChild(deployment.getName());
        try (InputStream in = ((ZipExporter)deployment.as(ZipExporter.class)).exportAsInputStream();){
            Closeable closeable = VFS.mountZipExpanded((InputStream)in, (String)deployment.getName(), (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
            this.mountPoints.add(closeable);
        }
        byte[] hash = this.contentProvider.addContent(mountPoint);
        ModelNode deploymentAdd = new ModelNode();
        deploymentAdd.get("operation").set("add");
        deploymentAdd.get("address").set("deployment", deployment.getName());
        deploymentAdd.get("runtime-name").set(deployment.getName());
        deploymentAdd.get("enabled").set(true);
        ModelNode content = deploymentAdd.get("content").add();
        content.get("hash").set(hash);
        System.setProperty("wildfly.swarm.current.deployment", deployment.getName());
        ModelNode result = this.client.execute(deploymentAdd);
    }

    void stop() {
        for (Closeable each : this.mountPoints) {
            try {
                each.close();
            }
            catch (IOException iOException) {}
        }
    }
}

