/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.impl.ArtifactResolver;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    private String projectBuildDir;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String projectOutputDir;
    @Parameter(alias="modules")
    private String[] modules;
    @Parameter(alias="exports")
    private String[] exports;
    @Parameter(alias="feature-pack")
    private String featurePack;
    @Parameter(alias="module-name", defaultValue="${fraction-module}")
    private String fractionModuleName;
    @Inject
    private ArtifactResolver resolver;
    private File fractionDir;
    private String className;
    private String packageNameWithTrailingDot;
    private static final String PREFIX = "wildfly-swarm-";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.modules == null || this.modules.length == 0) {
            throw new MojoFailureException("At least 1 module needs to be configured");
        }
        this.determineClassName();
        if (this.fractionModuleName == null || this.fractionModuleName.length() == 0) {
            throw new MojoFailureException("This plugin requires the 'fraction-module' property to be set.");
        }
        this.generateServiceLoaderDescriptor();
        this.generateFeaturePack();
        this.generateFractionReferenceForJar();
        this.generateFeaturePackReferenceForJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFractionReferenceForJar() throws MojoFailureException {
        File reference = new File(this.projectOutputDir, "wildfly-swarm-fraction.gav");
        try (FileWriter out = new FileWriter(reference);){
            out.write(this.project.getGroupId() + ":" + this.project.getArtifactId() + ":zip:fraction:" + this.project.getVersion() + "\n");
        }
        catch (IOException e) {
            throw new MojoFailureException("unable to create fraction reference for jar", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFeaturePackReferenceForJar() throws MojoFailureException {
        if (this.featurePack == null) {
            return;
        }
        String[] parts = this.featurePack.split(":");
        List deps = this.project.getDependencyManagement().getDependencies();
        Dependency featurePackDep = null;
        for (Dependency each : deps) {
            if (!each.getGroupId().equals(parts[0]) || !each.getArtifactId().equals(parts[1]) || !each.getType().equals("zip")) continue;
            this.getLog().info((CharSequence)("Using feature-pack: " + each));
            featurePackDep = each;
            break;
        }
        if (featurePackDep == null) {
            throw new MojoFailureException("Unable to determine feature-pack: " + this.featurePack);
        }
        File reference = new File(this.projectOutputDir, "wildfly-swarm-feature-pack.gav");
        try (FileWriter out = new FileWriter(reference);){
            out.write(featurePackDep.getGroupId() + ":" + featurePackDep.getArtifactId() + ":zip:" + featurePackDep.getVersion() + "\n");
        }
        catch (IOException e) {
            throw new MojoFailureException("unable to create feature-pack reference for jar", (Throwable)e);
        }
    }

    private void generateFeaturePack() throws MojoFailureException {
        this.generateModule();
        this.createZip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZip() throws MojoFailureException {
        File zipFile = new File(this.projectBuildDir, this.project.getArtifactId() + "-" + this.project.getVersion() + "-fraction.zip");
        zipFile.getParentFile().mkdirs();
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));){
            this.walkZip(out, new File(this.projectBuildDir, "fraction"));
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create fraction.zip file", (Throwable)e);
        }
        DefaultArtifact zipArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "provided", "zip", "fraction", (ArtifactHandler)new DefaultArtifactHandler("zip"));
        zipArtifact.setFile(zipFile);
        this.project.addAttachedArtifact((Artifact)zipArtifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void walkZip(ZipOutputStream out, File file) throws IOException {
        if (!file.equals(this.fractionDir)) {
            String zipPath = file.getAbsolutePath().substring(this.fractionDir.getAbsolutePath().length() + 1);
            if (file.isDirectory()) {
                zipPath = zipPath + "/";
            }
            out.putNextEntry(new ZipEntry(zipPath));
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                this.walkZip(out, children[i]);
            }
        } else {
            try (FileInputStream in = new FileInputStream(file);){
                byte[] buf = new byte[1024];
                int len = -1;
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModule() throws MojoFailureException {
        this.fractionDir = new File(this.projectBuildDir, "fraction");
        File dir = new File(this.fractionDir, "modules/system/layers/base/" + this.project.getGroupId().replaceAll("\\.", "/") + "/" + this.fractionModuleName + "/main");
        dir.mkdirs();
        File moduleXml = new File(dir, "module.xml");
        try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(moduleXml));){
            int i;
            out.write("<module xmlns=\"urn:jboss:module:1.3\" name=\"" + this.project.getGroupId() + "." + this.fractionModuleName + "\">\n");
            out.write("  <resources>\n");
            out.write("    <artifact name=\"${" + this.project.getGroupId() + ":" + this.project.getArtifactId() + "}\"/>\n");
            out.write("  </resources>\n");
            out.write("  <dependencies>\n");
            out.write("    <module name=\"org.wildfly.swarm.container\"/>\n");
            for (i = 0; i < this.modules.length; ++i) {
                out.write("    <module name=\"" + this.modules[i].trim() + "\"/>\n");
            }
            if (this.exports != null) {
                for (i = 0; i < this.exports.length; ++i) {
                    out.write("    <module name=\"" + this.exports[i].trim() + "\" export=\"true\"/>\n");
                }
            }
            out.write("  </dependencies>\n");
            out.write("</module>\n");
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create module.xml", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateServiceLoaderDescriptor() throws MojoFailureException {
        if (this.className == null) {
            return;
        }
        File dir = new File(this.projectBuildDir, "classes/META-INF/services");
        dir.mkdirs();
        File services = new File(dir, "org.wildfly.swarm.container.FractionDefaulter");
        try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(services));){
            out.write(this.packageNameWithTrailingDot + this.className + "\n");
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to create services file: " + services, (Throwable)e);
        }
    }

    private void determineClassName() throws MojoFailureException {
        try {
            Files.walkFileTree(new File(this.projectOutputDir).toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.getFileName().toString().equals("META-INF")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.getFileName().toString().endsWith("FractionDefaulter.class")) {
                        String name = file.getFileName().toString();
                        GenerateMojo.this.setClassName(name.substring(0, name.length() - 6));
                        String packageName = "";
                        Path current = file.getParent();
                        while (true) {
                            if (current.getFileName().toString().equals("classes")) break;
                            packageName = current.getFileName().toString() + "." + packageName;
                            current = current.getParent();
                        }
                        GenerateMojo.this.setPackage(packageName);
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to determine FractionDefaulter class", (Throwable)e);
        }
    }

    private void setClassName(String className) {
        this.className = className;
        String artifactId = this.project.getArtifactId();
        if (this.fractionModuleName == null && artifactId.startsWith(PREFIX)) {
            this.fractionModuleName = artifactId.substring(PREFIX.length());
        }
    }

    private void setPackage(String name) {
        this.packageNameWithTrailingDot = name;
    }
}

