/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.logging.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.logging.LoggingFraction;
import org.wildfly.swarm.logging.RootLogger;
import org.wildfly.swarm.logging.format.CustomFormatter;
import org.wildfly.swarm.logging.format.Formatter;
import org.wildfly.swarm.logging.format.PatternFormatter;
import org.wildfly.swarm.logging.handlers.ConsoleHandler;
import org.wildfly.swarm.logging.handlers.CustomHandler;
import org.wildfly.swarm.logging.handlers.FileHandler;
import org.wildfly.swarm.logging.handlers.Handler;

public class LoggingConfiguration
extends AbstractServerConfiguration<LoggingFraction> {
    private static final String DEFAULT_LEVEL = "INFO";
    private final PathAddress loggingAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"logging")});

    public LoggingConfiguration() {
        super(LoggingFraction.class);
    }

    public LoggingFraction defaultFraction() {
        String prop = System.getProperty("swarm.logging");
        if (prop != null) {
            if ((prop = prop.trim().toLowerCase()).equals("debug")) {
                return LoggingFraction.createDebugLoggingFraction();
            }
            if (prop.equals("trace")) {
                return LoggingFraction.createTraceLoggingFraction();
            }
        }
        return LoggingFraction.createDefaultLoggingFraction();
    }

    public List<ModelNode> getList(LoggingFraction fraction) {
        if (fraction == null) {
            fraction = this.defaultFraction();
        }
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", "org.jboss.as.logging");
        add.get("operation").set("add");
        list.add(add);
        ModelNode subsys = new ModelNode();
        subsys.get("address").set(this.loggingAddress.toModelNode());
        subsys.get("operation").set("add");
        list.add(subsys);
        this.addFormatters(fraction, list);
        this.addConsoleHandler(fraction, list);
        this.addHandlers(fraction, list);
        this.addRootLogger(fraction, list);
        return list;
    }

    private void addFormatters(LoggingFraction fraction, List<ModelNode> list) {
        for (Formatter each : fraction.formatters()) {
            if (each.isPattern()) {
                this.addPatternFormatter((PatternFormatter)each, list);
                continue;
            }
            if (!each.isCustom()) continue;
            this.addCustomFormatter((CustomFormatter)each, list);
        }
    }

    private void addPatternFormatter(PatternFormatter formatter, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("pattern-formatter", formatter.getName()).toModelNode());
        node.get("operation").set("add");
        node.get("pattern").set(formatter.getPattern());
        list.add(node);
    }

    private void addCustomFormatter(CustomFormatter formatter, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("custom-formatter", formatter.getName()).toModelNode());
        node.get("operation").set("add");
        node.get("module").set(formatter.getModule());
        node.get("class").set(formatter.getClassName());
        if (formatter.properties().size() > 0) {
            ModelNode properties = new ModelNode();
            StringBuffer buff = new StringBuffer();
            boolean first = true;
            for (Map.Entry<Object, Object> entry : formatter.properties().entrySet()) {
                if (!first) {
                    buff.append(",");
                }
                buff.append(entry.getKey());
                buff.append("=");
                buff.append(entry.getValue());
                first = false;
            }
            properties.get("metaData").set(new ValueExpression(buff.toString()));
            node.get("properties").set(properties);
        }
        list.add(node);
    }

    private void addConsoleHandler(LoggingFraction fraction, List<ModelNode> list) {
        ConsoleHandler handler = fraction.consoleHandler();
        if (handler == null) {
            return;
        }
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("console-handler", "CONSOLE").toModelNode());
        node.get("operation").set("add");
        node.get("level").set(handler.getLevel());
        node.get("named-formatter").set(handler.getFormatter());
        list.add(node);
    }

    private void addHandlers(LoggingFraction fraction, List<ModelNode> list) {
        for (Handler each : fraction.handlers()) {
            if (each.isFile()) {
                this.addFileHandler((FileHandler)each, list);
                continue;
            }
            if (!each.isCustom()) continue;
            this.addCustomHandler((CustomHandler)each, list);
        }
    }

    private void addFileHandler(FileHandler handler, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("file-handler", handler.name()).toModelNode());
        node.get("operation").set("add");
        node.get("level").set(handler.level());
        node.get("named-formatter").set(handler.formatter());
        ModelNode file = new ModelNode();
        file.get("path").set(handler.path());
        file.get("relative-to").set("jboss.server.log.dir");
        node.get("file").set(file);
        node.get("append").set(true);
        list.add(node);
    }

    private void addCustomHandler(CustomHandler handler, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("custom-handler", handler.name()).toModelNode());
        node.get("operation").set("add");
        node.get("class").set(handler.className());
        node.get("module").set(handler.module());
        node.get("named-formatter").set(handler.formatter());
        if (handler.properties().size() > 0) {
            ModelNode properties = new ModelNode();
            handler.properties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.get((String)key).set(new ValueExpression((String)value))));
            node.get("properties").set(properties);
        }
        list.add(node);
    }

    private void addRootLogger(LoggingFraction fraction, List<ModelNode> list) {
        RootLogger logger = fraction.rootLogger();
        if (logger == null) {
            return;
        }
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("root-logger", "ROOT").toModelNode());
        node.get("operation").set("add");
        for (String handler : logger.getHandlers()) {
            node.get("handlers").add(handler);
        }
        node.get("level").set(logger.getLevel());
        list.add(node);
    }
}

