/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.msc;

import java.io.IOException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.vfs.VirtualFile;
import org.wildfly.swarm.container.Deployment;
import org.wildfly.swarm.msc.ServiceDeploymentRegistry;
import org.wildfly.swarm.msc.ServiceInstanceActivator;
import org.wildfly.swarm.shrinkwrap.ShrinkWrapDeployment;

public class ServiceDeployment
implements Deployment {
    private static int COUNTER = 0;
    private final ShrinkWrapDeployment<JavaArchive> delegate = new ShrinkWrapDeployment(ServiceDeployment.archiveName(), JavaArchive.class);
    private boolean instanceServiceProviderAdded = false;

    public String getName() {
        return this.delegate.getName();
    }

    public ServiceDeployment addService(Service service) {
        ServiceDeploymentRegistry registry = ServiceDeploymentRegistry.get(this.getName());
        registry.addService(service);
        if (!this.instanceServiceProviderAdded) {
            ((JavaArchive)this.delegate.getArchive()).addAsServiceProvider(ServiceActivator.class, new Class[]{ServiceInstanceActivator.class});
            this.instanceServiceProviderAdded = true;
        }
        return this;
    }

    public VirtualFile getContent() throws IOException {
        this.addJBossDeploymentStructure();
        return this.delegate.getContent();
    }

    private void addJBossDeploymentStructure() {
        StringAsset structureXml = new StringAsset("<?xml version=\"1.0\" encoding=\"UTF-8\"?>  \n<jboss-deployment-structure>  \n    <deployment>  \n         <dependencies>  \n              <module name=\"APP\" slot=\"dependencies\"/>  \n              <module name=\"org.wildfly.swarm.msc\"/>  \n        </dependencies>  \n    </deployment>  \n</jboss-deployment-structure>\n");
        ((JavaArchive)this.delegate.getArchive()).addAsManifestResource((Asset)structureXml, "jboss-deployment-structure.xml");
    }

    private static String archiveName() {
        return System.getProperty("wildfly.swarm.app.name").replace(".jar", "-service-") + ++COUNTER + ".jar";
    }
}

