/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.runtime.logging;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.wildfly.swarm.logging.ConsoleHandler;
import org.wildfly.swarm.logging.Formatter;
import org.wildfly.swarm.logging.LoggingFraction;
import org.wildfly.swarm.logging.RootLogger;
import org.wildfly.swarm.runtime.container.AbstractServerConfiguration;

public class LoggingConfiguration
extends AbstractServerConfiguration<LoggingFraction> {
    private static final String DEFAULT_LEVEL = "INFO";
    private final PathAddress loggingAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"logging")});

    public LoggingConfiguration() {
        super(LoggingFraction.class);
    }

    public LoggingFraction defaultFraction() {
        return new LoggingFraction().formatter("PATTERN", "%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n").consoleHandler(DEFAULT_LEVEL, "PATTERN").rootLogger("CONSOLE", DEFAULT_LEVEL);
    }

    public List<ModelNode> getList(LoggingFraction fraction) {
        if (fraction == null) {
            fraction = this.defaultFraction();
        }
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        ModelNode address = new ModelNode();
        address.setEmptyList();
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", "org.jboss.as.logging");
        add.get("operation").set("add");
        list.add(add);
        ModelNode subsys = new ModelNode();
        subsys.get("address").set(this.loggingAddress.toModelNode());
        subsys.get("operation").set("add");
        list.add(subsys);
        this.addFormatters(fraction, list);
        this.addConsoleHandler(fraction, list);
        this.addRootLogger(fraction, list);
        return list;
    }

    private void addFormatters(LoggingFraction fraction, List<ModelNode> list) {
        for (Formatter each : fraction.formatters()) {
            this.addFormatter(each, list);
        }
    }

    private void addFormatter(Formatter formatter, List<ModelNode> list) {
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("pattern-formatter", formatter.getName()).toModelNode());
        node.get("operation").set("add");
        node.get("pattern").set(formatter.getPattern());
        list.add(node);
    }

    private void addConsoleHandler(LoggingFraction fraction, List<ModelNode> list) {
        ConsoleHandler handler = fraction.consoleHandler();
        if (handler == null) {
            return;
        }
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("console-handler", "CONSOLE").toModelNode());
        node.get("operation").set("add");
        node.get("level").set(handler.getLevel());
        node.get("named-formatter").set(handler.getFormatter());
        list.add(node);
    }

    private void addRootLogger(LoggingFraction fraction, List<ModelNode> list) {
        RootLogger logger = fraction.rootLogger();
        if (logger == null) {
            return;
        }
        ModelNode node = new ModelNode();
        node.get("address").set(this.loggingAddress.append("root-logger", "ROOT").toModelNode());
        node.get("operation").set("add");
        node.get("handlers").add(logger.getHandler());
        node.get("level").set(logger.getLevel());
        list.add(node);
    }
}

