/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.util.BlockingInvocation;
import org.jboss.remoting3.util.Invocation;
import org.jboss.remoting3.util.InvocationTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.Assert;
import org.wildfly.common.rpc.RemoteExceptionCause;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.SimpleIdResolver;
import org.wildfly.transaction.client.provider.remoting.TransactionClientChannel;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;

class RemotingRemoteTransactionHandle
implements SimpleTransactionControl {
    private final TransactionClientChannel channel;
    private final AtomicInteger statusRef = new AtomicInteger(0);
    private final int id;
    private final SimpleIdResolver resolver = connection -> {
        Assert.checkNotNullParam((String)"connection", (Object)connection);
        if (this.getConnection() != connection) {
            throw Log.log.invalidTransactionConnection();
        }
        return this.getId();
    };

    RemotingRemoteTransactionHandle(int id, TransactionClientChannel channel) {
        this.id = id;
        this.channel = channel;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        AtomicInteger statusRef;
        AtomicInteger atomicInteger = statusRef = this.statusRef;
        synchronized (atomicInteger) {
            int oldVal = statusRef.get();
            if (oldVal == 0 || oldVal == 1) {
                statusRef.set(4);
                this.channel.notifyTransactionEnd(this.id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            block44: {
                oldVal = statusRef.get();
                if (oldVal == 1) {
                    this.rollback();
                    throw Log.log.rollbackOnlyRollback();
                }
                if (oldVal != 0) {
                    throw Log.log.invalidTxnState();
                }
                statusRef.set(8);
                try {
                    InvocationTracker invocationTracker = this.channel.getInvocationTracker();
                    BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
                    try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                        os.writeShort(invocation.getIndex());
                        os.writeByte(10);
                        Protocol.writeParam(241, (OutputStream)os, this.id, false);
                        int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                        if (peerIdentityId != 0) {
                            Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                        }
                    }
                    catch (IOException e) {
                        statusRef.set(5);
                        throw Log.log.failedToSend(e);
                    }
                    try (BlockingInvocation.Response response = invocation.getResponse();){
                        try (MessageInputStream is = response.getInputStream();){
                            if (is.readUnsignedByte() != 26) {
                                throw Log.log.unknownResponse();
                            }
                            int messageId = is.read();
                            if (messageId == -1) {
                                statusRef.set(3);
                                this.channel.notifyTransactionEnd(this.id);
                                break block44;
                            }
                            int len = StreamUtils.readPackedUnsignedInt32((InputStream)is);
                            if (messageId == 17) {
                                statusRef.set(5);
                                HeuristicMixedException e = Log.log.peerHeuristicMixedException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 18) {
                                statusRef.set(5);
                                HeuristicRollbackException e = Log.log.peerHeuristicRollbackException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 20) {
                                statusRef.set(5);
                                IllegalStateException e = Log.log.peerIllegalStateException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 16) {
                                statusRef.set(4);
                                RollbackException e = Log.log.transactionRolledBackByPeer();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 19) {
                                statusRef.set(5);
                                SystemException e = Log.log.peerSystemException();
                                e.errorCode = is.readInt();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 32) {
                                statusRef.set(oldVal);
                                SecurityException e = Log.log.peerSecurityException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            statusRef.set(5);
                            throw Log.log.unknownResponse();
                        }
                        catch (IOException e) {
                            statusRef.set(5);
                            throw Log.log.responseFailed(e);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        statusRef.set(5);
                        throw Log.log.operationInterrupted();
                    }
                    catch (IOException e) {
                        Log.log.inboundException(e);
                    }
                }
                finally {
                    statusRef.compareAndSet(8, 5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SecurityException, SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal != 0 && oldVal != 1) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            block40: {
                oldVal = statusRef.get();
                if (oldVal != 0 && oldVal != 1) {
                    throw Log.log.invalidTxnState();
                }
                statusRef.set(9);
                try {
                    InvocationTracker invocationTracker = this.channel.getInvocationTracker();
                    BlockingInvocation invocation = (BlockingInvocation)invocationTracker.addInvocation(BlockingInvocation::new);
                    try (MessageOutputStream os = invocationTracker.allocateMessage((Invocation)invocation);){
                        os.writeShort(invocation.getIndex());
                        os.writeByte(11);
                        Protocol.writeParam(241, (OutputStream)os, this.id, false);
                        int peerIdentityId = this.channel.getConnection().getPeerIdentityId();
                        if (peerIdentityId != 0) {
                            Protocol.writeParam(240, (OutputStream)os, peerIdentityId, false);
                        }
                    }
                    catch (IOException e) {
                        statusRef.set(5);
                        throw Log.log.failedToSend(e);
                    }
                    try (BlockingInvocation.Response response = invocation.getResponse();){
                        try (MessageInputStream is = response.getInputStream();){
                            if (is.readUnsignedByte() != 27) {
                                throw Log.log.unknownResponse();
                            }
                            int messageId = is.read();
                            if (messageId == -1) {
                                statusRef.set(4);
                                this.channel.notifyTransactionEnd(this.id);
                                break block40;
                            }
                            int len = StreamUtils.readPackedUnsignedInt32((InputStream)is);
                            if (messageId == 20) {
                                statusRef.set(5);
                                IllegalStateException e = Log.log.peerIllegalStateException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 19) {
                                statusRef.set(5);
                                SystemException e = Log.log.peerSystemException();
                                e.errorCode = is.readInt();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            if (messageId == 32) {
                                statusRef.set(oldVal);
                                SecurityException e = Log.log.peerSecurityException();
                                e.initCause((Throwable)RemoteExceptionCause.readFromStream((DataInput)is));
                                throw e;
                            }
                            statusRef.set(5);
                            throw Log.log.unknownResponse();
                        }
                        catch (IOException e) {
                            statusRef.set(5);
                            throw Log.log.responseFailed(e);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        statusRef.set(5);
                        throw Log.log.operationInterrupted();
                    }
                    catch (IOException e) {
                        Log.log.inboundException(e);
                    }
                }
                finally {
                    statusRef.compareAndSet(9, 5);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRollbackOnly() throws SystemException {
        AtomicInteger statusRef = this.statusRef;
        int oldVal = statusRef.get();
        if (oldVal == 1) {
            return;
        }
        if (oldVal != 0) {
            throw Log.log.invalidTxnState();
        }
        AtomicInteger atomicInteger = statusRef;
        synchronized (atomicInteger) {
            oldVal = statusRef.get();
            if (oldVal == 1) {
                return;
            }
            if (oldVal != 0) {
                throw Log.log.invalidTxnState();
            }
            statusRef.set(1);
        }
    }

    @Override
    public <T> T getProviderInterface(Class<T> type) {
        return type.isAssignableFrom(SimpleIdResolver.class) ? (T)type.cast(this.resolver) : null;
    }

    Connection getConnection() {
        return this.channel.getConnection();
    }
}

