package org.wildfly.transaction.client._private;

import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.util.ServiceConfigurationError;
import javax.transaction.InvalidTransactionException;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.transaction.RollbackException;
import java.net.URI;
import org.wildfly.transaction.client.DelayedEnlistmentException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import org.jboss.remoting3.Endpoint;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.Generated;
import javax.transaction.xa.XAException;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.Exception;
import javax.transaction.xa.Xid;
import javax.transaction.xa.XAResource;
import javax.transaction.Transaction;
import javax.transaction.HeuristicMixedException;
import java.lang.Throwable;
import java.lang.Class;
import java.util.Arrays;
import javax.transaction.NotSupportedException;
import javax.transaction.HeuristicCommitException;
import org.wildfly.transaction.client.SynchronizationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2017-02-07T19:00:41-0600")
public class Log_$logger extends DelegatingBasicLogger implements Log,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final String subordinateXaResource = "Subordinate XAResource at %s";
    protected String subordinateXaResource$str() {
        return subordinateXaResource;
    }
    @Override
    public final String subordinateXaResource(final URI location) {
        return String.format(subordinateXaResource$str(), location);
    }
    @Override
    public final void serviceConfigurationFailed(final ServiceConfigurationError e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, e, serviceConfigurationFailed$str());
    }
    private static final String serviceConfigurationFailed = "Failed to configure a remote transaction service provider";
    protected String serviceConfigurationFailed$str() {
        return serviceConfigurationFailed;
    }
    @Override
    public final void recoverySuppressedException(final XAException e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, e, recoverySuppressedException$str());
    }
    private static final String recoverySuppressedException = "Closing the recovery stream after recovery failed threw an exception";
    protected String recoverySuppressedException$str() {
        return recoverySuppressedException;
    }
    @Override
    public final void inboundException(final Throwable e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, e, inboundException$str());
    }
    private static final String inboundException = "Got exception on inbound message";
    protected String inboundException$str() {
        return inboundException;
    }
    @Override
    public final void outboundException(final Throwable e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.TRACE, e, outboundException$str());
    }
    private static final String outboundException = "Got exception on outbound message";
    protected String outboundException$str() {
        return outboundException;
    }
    private static final String noTransaction = "No transaction associated with the current thread";
    protected String noTransaction$str() {
        return noTransaction;
    }
    @Override
    public final IllegalStateException noTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(noTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nestedNotSupported = "WFTXN0001: A transaction is already in progress";
    protected String nestedNotSupported$str() {
        return nestedNotSupported;
    }
    @Override
    public final NotSupportedException nestedNotSupported() {
        final NotSupportedException result = new NotSupportedException(String.format(nestedNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notSupportedTransaction = "WFTXN0002: Transaction is not a supported instance: %s";
    protected String notSupportedTransaction$str() {
        return notSupportedTransaction;
    }
    @Override
    public final InvalidTransactionException notSupportedTransaction(final Transaction transaction) {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(notSupportedTransaction$str(), transaction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionLocationUri = "WFTXN0003: Invalid transaction location URI (must be absolute): %s";
    protected String invalidTransactionLocationUri$str() {
        return invalidTransactionLocationUri;
    }
    @Override
    public final IllegalArgumentException invalidTransactionLocationUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidTransactionLocationUri$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProviderForUri = "WFTXN0004: No transaction provider installed for URI: %s";
    protected String noProviderForUri$str() {
        return noProviderForUri;
    }
    @Override
    public final IllegalArgumentException noProviderForUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(noProviderForUri$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionNotAssociatedWithThisProvider = "WFTXN0005: Transaction not associated with this provider";
    protected String transactionNotAssociatedWithThisProvider$str() {
        return transactionNotAssociatedWithThisProvider;
    }
    @Override
    public final InvalidTransactionException transactionNotAssociatedWithThisProvider() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(transactionNotAssociatedWithThisProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String negativeTxnTimeout = "WFTXN0006: Negative transaction timeout provided";
    protected String negativeTxnTimeout$str() {
        return negativeTxnTimeout;
    }
    @Override
    public final SystemException negativeTxnTimeout() {
        final SystemException result = new SystemException(String.format(negativeTxnTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyAssociated = "WFTXN0007: A transaction is already associated with the current thread";
    protected String alreadyAssociated$str() {
        return alreadyAssociated;
    }
    @Override
    public final IllegalStateException alreadyAssociated() {
        final IllegalStateException result = new IllegalStateException(String.format(alreadyAssociated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String registerSynchRemoteTransaction = "WFTXN0008: Cannot register a synchronization on a remote transaction";
    protected String registerSynchRemoteTransaction$str() {
        return registerSynchRemoteTransaction;
    }
    @Override
    public final UnsupportedOperationException registerSynchRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(registerSynchRemoteTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String enlistDelistRemoteTransaction = "WFTXN0009: Cannot enlist or delist resources on a remote transaction";
    protected String enlistDelistRemoteTransaction$str() {
        return enlistDelistRemoteTransaction;
    }
    @Override
    public final UnsupportedOperationException enlistDelistRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(enlistDelistRemoteTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReceive = "WFTXN0010: Failed to receive protocol message from remote peer";
    protected String failedToReceive$str() {
        return failedToReceive;
    }
    @Override
    public final SystemException failedToReceive(final IOException e) {
        final SystemException result = new SystemException(String.format(failedToReceive$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToSend = "WFTXN0011: Failed to send protocol message to remote peer";
    protected String failedToSend$str() {
        return failedToSend;
    }
    @Override
    public final SystemException failedToSend(final Exception e) {
        final SystemException result = new SystemException(String.format(failedToSend$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerSystemException = "WFTXN0012: The peer threw a SystemException; see peer logs for more information";
    protected String peerSystemException$str() {
        return peerSystemException;
    }
    @Override
    public final SystemException peerSystemException() {
        final SystemException result = new SystemException(String.format(peerSystemException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerSecurityException = "WFTXN0013: The peer threw a SecurityException; see peer logs for more information";
    protected String peerSecurityException$str() {
        return peerSecurityException;
    }
    @Override
    public final SecurityException peerSecurityException() {
        final SecurityException result = new SecurityException(String.format(peerSecurityException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolError = "WFTXN0014: An unexpected protocol error occurred";
    protected String protocolError$str() {
        return protocolError;
    }
    @Override
    public final SystemException protocolError() {
        final SystemException result = new SystemException(String.format(protocolError$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationInterrupted = "WFTXN0015: The protocol operation was interrupted locally";
    protected String operationInterrupted$str() {
        return operationInterrupted;
    }
    @Override
    public final SystemException operationInterrupted() {
        final SystemException result = new SystemException(String.format(operationInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionRolledBackByPeer = "WFTXN0016: The remote peer rolled back the transaction";
    protected String transactionRolledBackByPeer$str() {
        return transactionRolledBackByPeer;
    }
    @Override
    public final RollbackException transactionRolledBackByPeer() {
        final RollbackException result = new RollbackException(String.format(transactionRolledBackByPeer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnlyRollback = "WFTXN0017: Rollback-only transaction rolled back";
    protected String rollbackOnlyRollback$str() {
        return rollbackOnlyRollback;
    }
    @Override
    public final RollbackException rollbackOnlyRollback() {
        final RollbackException result = new RollbackException(String.format(rollbackOnlyRollback$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTxnState = "WFTXN0018: Invalid transaction state";
    protected String invalidTxnState$str() {
        return invalidTxnState;
    }
    @Override
    public final IllegalStateException invalidTxnState() {
        final IllegalStateException result = new IllegalStateException(String.format(invalidTxnState$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerHeuristicMixedException = "WFTXN0019: The peer threw a HeuristicMixedException; see peer logs for more information";
    protected String peerHeuristicMixedException$str() {
        return peerHeuristicMixedException;
    }
    @Override
    public final HeuristicMixedException peerHeuristicMixedException() {
        final HeuristicMixedException result = new HeuristicMixedException(String.format(peerHeuristicMixedException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerHeuristicRollbackException = "WFTXN0020: The peer threw a HeuristicRollbackException; see peer logs for more information";
    protected String peerHeuristicRollbackException$str() {
        return peerHeuristicRollbackException;
    }
    @Override
    public final HeuristicRollbackException peerHeuristicRollbackException() {
        final HeuristicRollbackException result = new HeuristicRollbackException(String.format(peerHeuristicRollbackException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAcquireConnection = "WFTXN0021: Failed to acquire a connection for this operation";
    protected String failedToAcquireConnection$str() {
        return failedToAcquireConnection;
    }
    @Override
    public final SystemException failedToAcquireConnection(final IOException reason) {
        final SystemException result = new SystemException(String.format(failedToAcquireConnection$str()));
        result.initCause(reason);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateEnlistment = "WFTXN0022: The resource manager for remote connection to %s was already enlisted in a transaction";
    protected String duplicateEnlistment$str() {
        return duplicateEnlistment;
    }
    @Override
    public final XAException duplicateEnlistment(final int errorCode, final URI uri) {
        final XAException result = new XAException(String.format(duplicateEnlistment$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidFlags = "WFTXN0023: Invalid flag value";
    protected String invalidFlags$str() {
        return invalidFlags;
    }
    @Override
    public final IllegalArgumentException invalidFlags() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidFlags$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateTransaction = "WFTXN0024: Duplicate transaction encountered for destination %s, transaction ID %s";
    protected String duplicateTransaction$str() {
        return duplicateTransaction;
    }
    @Override
    public final XAException duplicateTransaction(final int errorCode, final URI uri, final Xid xid) {
        final XAException result = new XAException(String.format(duplicateTransaction$str(), uri, xid));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String failedToReceiveXA = "WFTXN0025: Failed to receive protocol message from remote peer";
    protected String failedToReceiveXA$str() {
        return failedToReceiveXA;
    }
    @Override
    public final XAException failedToReceiveXA(final IOException e, final int errorCode) {
        final XAException result = new XAException(String.format(failedToReceiveXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String failedToSendXA = "WFTXN0026: Failed to send protocol message to remote peer";
    protected String failedToSendXA$str() {
        return failedToSendXA;
    }
    @Override
    public final XAException failedToSendXA(final Exception e, final int errorCode) {
        final XAException result = new XAException(String.format(failedToSendXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String operationInterruptedXA = "WFTXN0027: The protocol operation was interrupted locally";
    protected String operationInterruptedXA$str() {
        return operationInterruptedXA;
    }
    @Override
    public final XAException operationInterruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(operationInterruptedXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String protocolErrorXA = "WFTXN0028: An unexpected protocol error occurred";
    protected String protocolErrorXA$str() {
        return protocolErrorXA;
    }
    @Override
    public final XAException protocolErrorXA(final int errorCode) {
        final XAException result = new XAException(String.format(protocolErrorXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String peerXaException = "WFTXN0029: The peer threw an XA exception";
    protected String peerXaException$str() {
        return peerXaException;
    }
    @Override
    public final XAException peerXaException(final int errorCode) {
        final XAException result = new XAException(String.format(peerXaException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidHandleType = "WFTXN0030: Invalid handle type; expected %s, actually received %s";
    protected String invalidHandleType$str() {
        return invalidHandleType;
    }
    @Override
    public final IllegalArgumentException invalidHandleType(final Class<? extends Object> expected, final Class<? extends Object> actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidHandleType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String commitOnImported = "WFTXN0031: Commit not allowed on imported transaction";
    protected String commitOnImported$str() {
        return commitOnImported;
    }
    @Override
    public final SystemException commitOnImported() {
        final SystemException result = new SystemException(String.format(commitOnImported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnImported = "WFTXN0032: Rollback not allowed on imported transaction";
    protected String rollbackOnImported$str() {
        return rollbackOnImported;
    }
    @Override
    public final SystemException rollbackOnImported() {
        final SystemException result = new SystemException(String.format(rollbackOnImported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleProvidersRegistered = "WFTXN0033: Multiple remote transaction providers registered on endpoint: %s";
    protected String multipleProvidersRegistered$str() {
        return multipleProvidersRegistered;
    }
    @Override
    public final IllegalStateException multipleProvidersRegistered(final Endpoint e) {
        final IllegalStateException result = new IllegalStateException(String.format(multipleProvidersRegistered$str(), e));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAcquireConnectionXA = "WFTXN0034: Failed to acquire a connection for this operation";
    protected String failedToAcquireConnectionXA$str() {
        return failedToAcquireConnectionXA;
    }
    @Override
    public final XAException failedToAcquireConnectionXA(final IOException e, final int errorCode) {
        final XAException result = new XAException(String.format(failedToAcquireConnectionXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidHandleTypeRequested = "WFTXN0035: Invalid handle type requested; expected a subtype of Transaction (non-inclusive), got %s";
    protected String invalidHandleTypeRequested$str() {
        return invalidHandleTypeRequested;
    }
    @Override
    public final IllegalArgumentException invalidHandleTypeRequested(final Class<? extends Object> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidHandleTypeRequested$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedXA = "WFTXN0036: Transaction operation failed due to thread interruption";
    protected String interruptedXA$str() {
        return interruptedXA;
    }
    @Override
    public final XAException interruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(interruptedXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String noTransactionProvider = "WFTXN0037: No transaction provider associated with the current thread";
    protected String noTransactionProvider$str() {
        return noTransactionProvider;
    }
    @Override
    public final IllegalStateException noTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(noTransactionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noLocalTransactionProvider = "WFTXN0038: No local transaction provider associated with the current thread";
    protected String noLocalTransactionProvider$str() {
        return noLocalTransactionProvider;
    }
    @Override
    public final IllegalStateException noLocalTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(noLocalTransactionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullTransaction = "WFTXN0039: Invalid null transaction";
    protected String nullTransaction$str() {
        return nullTransaction;
    }
    @Override
    public final NullPointerException nullTransaction() {
        final NullPointerException result = new NullPointerException(String.format(nullTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rollbackFailed(final Throwable e) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, e, rollbackFailed$str());
    }
    private static final String rollbackFailed = "WFTXN0040: Rollback failed unexpectedly";
    protected String rollbackFailed$str() {
        return rollbackFailed;
    }
    private static final String noProviderInterface = "WFTXN0041: No provider interface matching %s is available from the transaction provider";
    protected String noProviderInterface$str() {
        return noProviderInterface;
    }
    @Override
    public final IllegalStateException noProviderInterface(final Class<? extends Object> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(noProviderInterface$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionFailed = "WFTXN0042: Connection to remote transaction service failed";
    protected String connectionFailed$str() {
        return connectionFailed;
    }
    @Override
    public final SystemException connectionFailed(final Throwable cause) {
        final SystemException result = new SystemException(String.format(connectionFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionInterrupted = "WFTXN0043: Connection to remote transaction service interrupted";
    protected String connectionInterrupted$str() {
        return connectionInterrupted;
    }
    @Override
    public final SystemException connectionInterrupted() {
        final SystemException result = new SystemException(String.format(connectionInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownResponse = "WFTXN0044: Unknown response received from peer";
    protected String unknownResponse$str() {
        return unknownResponse;
    }
    @Override
    public final SystemException unknownResponse() {
        final SystemException result = new SystemException(String.format(unknownResponse$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String responseFailed = "WFTXN0045: Failed to receive a response from peer";
    protected String responseFailed$str() {
        return responseFailed;
    }
    @Override
    public final SystemException responseFailed(final IOException cause) {
        final SystemException result = new SystemException(String.format(responseFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerIllegalStateException = "WFTXN0046: The peer threw an IllegalStateException; see peer logs for more information";
    protected String peerIllegalStateException$str() {
        return peerIllegalStateException;
    }
    @Override
    public final IllegalStateException peerIllegalStateException() {
        final IllegalStateException result = new IllegalStateException(String.format(peerIllegalStateException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownResponseXa = "WFTXN0047: Unknown XA response received from peer";
    protected String unknownResponseXa$str() {
        return unknownResponseXa;
    }
    @Override
    public final XAException unknownResponseXa(final int errorCode) {
        final XAException result = new XAException(String.format(unknownResponseXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String responseFailedXa = "WFTXN0048: Failed to receive an XA response from peer";
    protected String responseFailedXa$str() {
        return responseFailedXa;
    }
    @Override
    public final XAException responseFailedXa(final IOException cause, final int errorCode) {
        final XAException result = new XAException(String.format(responseFailedXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String negativeTxnTimeoutXa = "WFTXN0049: Negative transaction timeout provided";
    protected String negativeTxnTimeoutXa$str() {
        return negativeTxnTimeoutXa;
    }
    @Override
    public final XAException negativeTxnTimeoutXa(final int errorCode) {
        final XAException result = new XAException(String.format(negativeTxnTimeoutXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unrecognizedParameter = "WFTXN0050: Unrecognized parameter with ID 0x%02x received";
    protected String unrecognizedParameter$str() {
        return unrecognizedParameter;
    }
    @Override
    public final XAException unrecognizedParameter(final int errorCode, final int id) {
        final XAException result = new XAException(String.format(unrecognizedParameter$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String expectedParameter = "WFTXN0051: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    protected String expectedParameter$str() {
        return expectedParameter;
    }
    @Override
    public final SystemException expectedParameter(final int expected, final int actual) {
        final SystemException result = new SystemException(String.format(expectedParameter$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedParameterXa = "WFTXN0052: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    protected String expectedParameterXa$str() {
        return expectedParameterXa;
    }
    @Override
    public final XAException expectedParameterXa(final int errorCode, final int expected, final int actual) {
        final XAException result = new XAException(String.format(expectedParameterXa$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String delayedEnlistmentFailed = "WFTXN0053: Delayed enlistment has failed";
    protected String delayedEnlistmentFailed$str() {
        return delayedEnlistmentFailed;
    }
    @Override
    public final DelayedEnlistmentException delayedEnlistmentFailed(final Throwable cause) {
        final DelayedEnlistmentException result = new DelayedEnlistmentException(String.format(delayedEnlistmentFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beforeCompletionFailed = "WFTXN0054: Before-completion failed for resource %s";
    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }
    @Override
    public final SynchronizationException beforeCompletionFailed(final Throwable cause, final XAResource resource) {
        final SynchronizationException result = new SynchronizationException(String.format(beforeCompletionFailed$str(), resource), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onePhaseUserTransaction = "WFTXN0055: Two-phase operation on single-phase transaction";
    protected String onePhaseUserTransaction$str() {
        return onePhaseUserTransaction;
    }
    @Override
    public final XAException onePhaseUserTransaction(final int errorCode) {
        final XAException result = new XAException(String.format(onePhaseUserTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unknownProvider = "WFTXN0056: Unknown provider for remote transactions with URI scheme \"%s\"";
    protected String unknownProvider$str() {
        return unknownProvider;
    }
    @Override
    public final IllegalArgumentException unknownProvider(final String scheme) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unknownProvider$str(), scheme));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String outflowAcrossTransactionManagers = "WFTXN0057: Attempted to outflow the same transaction from two different transaction managers";
    protected String outflowAcrossTransactionManagers$str() {
        return outflowAcrossTransactionManagers;
    }
    @Override
    public final SystemException outflowAcrossTransactionManagers() {
        final SystemException result = new SystemException(String.format(outflowAcrossTransactionManagers$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyEnlisted = "WFTXN0058: This delayed enlistment handle was already enlisted";
    protected String alreadyEnlisted$str() {
        return alreadyEnlisted;
    }
    @Override
    public final IllegalStateException alreadyEnlisted() {
        final IllegalStateException result = new IllegalStateException(String.format(alreadyEnlisted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyForgotten = "WFTXN0059: This delayed enlistment handle was already forgotten";
    protected String alreadyForgotten$str() {
        return alreadyForgotten;
    }
    @Override
    public final IllegalStateException alreadyForgotten() {
        final IllegalStateException result = new IllegalStateException(String.format(alreadyForgotten$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionTimedOut = "WFTXN0060: Transaction timed out";
    protected String transactionTimedOut$str() {
        return transactionTimedOut;
    }
    @Override
    public final XAException transactionTimedOut(final int errorCode) {
        final XAException result = new XAException(String.format(transactionTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String markedRollbackOnly = "WFTXN0061: Transaction is marked rollback-only";
    protected String markedRollbackOnly$str() {
        return markedRollbackOnly;
    }
    @Override
    public final RollbackException markedRollbackOnly() {
        final RollbackException result = new RollbackException(String.format(markedRollbackOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notActive = "WFTXN0062: Transaction is not active";
    protected String notActive$str() {
        return notActive;
    }
    @Override
    public final IllegalStateException notActive() {
        final IllegalStateException result = new IllegalStateException(String.format(notActive$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerCreatedNullTransaction = "WFTXN0063: Provider created a null transaction";
    protected String providerCreatedNullTransaction$str() {
        return providerCreatedNullTransaction;
    }
    @Override
    public final IllegalStateException providerCreatedNullTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(providerCreatedNullTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnectionEndpoint = "WFTXN0064: Invalid connection endpoint provided";
    protected String invalidConnectionEndpoint$str() {
        return invalidConnectionEndpoint;
    }
    @Override
    public final IllegalArgumentException invalidConnectionEndpoint() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(invalidConnectionEndpoint$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransactionForId = "WFTXN0065: No transaction for ID %d";
    protected String noTransactionForId$str() {
        return noTransactionForId;
    }
    @Override
    public final SystemException noTransactionForId(final int id) {
        final SystemException result = new SystemException(String.format(noTransactionForId$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnlyFailed = "WFTXN0066: Failed to set transaction as rollback-only";
    protected String rollbackOnlyFailed$str() {
        return rollbackOnlyFailed;
    }
    @Override
    public final XAException rollbackOnlyFailed(final int errorCode, final SystemException e) {
        final XAException result = new XAException(String.format(rollbackOnlyFailed$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String notActiveXA = "WFTXN0067: Transaction is not active";
    protected String notActiveXA$str() {
        return notActiveXA;
    }
    @Override
    public final XAException notActiveXA(final int errorCode) {
        final XAException result = new XAException(String.format(notActiveXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String couldNotEnlist = "WFTXN0068: Subordinate enlistment failed for unknown reason";
    protected String couldNotEnlist$str() {
        return couldNotEnlist;
    }
    @Override
    public final SystemException couldNotEnlist() {
        final SystemException result = new SystemException(String.format(couldNotEnlist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionConnection = "WFTXN0069: Connection does not match the transaction; the connection may have closed";
    protected String invalidTransactionConnection$str() {
        return invalidTransactionConnection;
    }
    @Override
    public final InvalidTransactionException invalidTransactionConnection() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(invalidTransactionConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransactionXa = "WFTXN0070: No such transaction";
    protected String noTransactionXa$str() {
        return noTransactionXa;
    }
    @Override
    public final XAException noTransactionXa(final int errorCode) {
        final XAException result = new XAException(String.format(noTransactionXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unexpectedFailure = "WFTXN0071: An unexpected failure condition occurred";
    protected String unexpectedFailure$str() {
        return unexpectedFailure;
    }
    @Override
    public final IllegalStateException unexpectedFailure(final Throwable e) {
        final IllegalStateException result = new IllegalStateException(String.format(unexpectedFailure$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noLocalTransactionProviderNodeName = "WFTXN0072: No local transaction provider node name specified in the transaction manager environment";
    protected String noLocalTransactionProviderNodeName$str() {
        return noLocalTransactionProviderNodeName;
    }
    @Override
    public final IllegalStateException noLocalTransactionProviderNodeName() {
        final IllegalStateException result = new IllegalStateException(String.format(noLocalTransactionProviderNodeName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedProviderTransactionMismatch = "WFTXN0073: Unexpected provider transaction mismatch; expected %s, got %s";
    protected String unexpectedProviderTransactionMismatch$str() {
        return unexpectedProviderTransactionMismatch;
    }
    @Override
    public final IllegalStateException unexpectedProviderTransactionMismatch(final Transaction expected, final Transaction actual) {
        final IllegalStateException result = new IllegalStateException(String.format(unexpectedProviderTransactionMismatch$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String heuristicMixedXa = "WFTXN0074: Heuristic-mixed outcome";
    protected String heuristicMixedXa$str() {
        return heuristicMixedXa;
    }
    @Override
    public final XAException heuristicMixedXa(final int errorCode, final HeuristicMixedException cause) {
        final XAException result = new XAException(String.format(heuristicMixedXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String heuristicCommitXa = "WFTXN0075: Heuristic-commit outcome";
    protected String heuristicCommitXa$str() {
        return heuristicCommitXa;
    }
    @Override
    public final XAException heuristicCommitXa(final int errorCode, final HeuristicCommitException cause) {
        final XAException result = new XAException(String.format(heuristicCommitXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String rollbackXa = "WFTXN0076: Transaction rolled back";
    protected String rollbackXa$str() {
        return rollbackXa;
    }
    @Override
    public final XAException rollbackXa(final int errorCode, final RollbackException cause) {
        final XAException result = new XAException(String.format(rollbackXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String heuristicRollbackXa = "WFTXN0077: Heuristic-rollback outcome";
    protected String heuristicRollbackXa$str() {
        return heuristicRollbackXa;
    }
    @Override
    public final XAException heuristicRollbackXa(final int errorCode, final HeuristicRollbackException cause) {
        final XAException result = new XAException(String.format(heuristicRollbackXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String illegalStateXa = "WFTXN0078: Invalid transaction state";
    protected String illegalStateXa$str() {
        return illegalStateXa;
    }
    @Override
    public final XAException illegalStateXa(final int errorCode, final IllegalStateException cause) {
        final XAException result = new XAException(String.format(illegalStateXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String resourceManagerErrorXa = "WFTXN0079: An unexpected resource manager error occurred";
    protected String resourceManagerErrorXa$str() {
        return resourceManagerErrorXa;
    }
    @Override
    public final XAException resourceManagerErrorXa(final int errorCode, final Throwable cause) {
        final XAException result = new XAException(String.format(resourceManagerErrorXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String notImportedXa = "WFTXN0080: Operation not allowed on non-imported transaction";
    protected String notImportedXa$str() {
        return notImportedXa;
    }
    @Override
    public final XAException notImportedXa(final int errorCode) {
        final XAException result = new XAException(String.format(notImportedXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidTxStateXa = "WFTXN0081: Invalid transaction state for operation";
    protected String invalidTxStateXa$str() {
        return invalidTxStateXa;
    }
    @Override
    public final XAException invalidTxStateXa(final int errorCode) {
        final XAException result = new XAException(String.format(invalidTxStateXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
}
