/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.ServiceNotFoundException;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.RemotingFallbackPeerProvider;
import org.wildfly.transaction.client.provider.remoting.RemotingOperations;
import org.wildfly.transaction.client.provider.remoting.TransactionClientChannel;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

class RemotingRemoteTransactionPeer
implements RemoteTransactionPeer {
    private static final Attachments.Key<RemotingOperations> key = new Attachments.Key(RemotingOperations.class);
    private final URI location;
    private final Endpoint endpoint;
    private final RemotingFallbackPeerProvider fallbackProvider;
    private final Set<Xid> rollbackOnlyXids = new ConcurrentHashMap().keySet(Boolean.TRUE);

    RemotingRemoteTransactionPeer(URI location, Endpoint endpoint, RemotingFallbackPeerProvider fallbackProvider) {
        this.location = location;
        this.endpoint = endpoint;
        this.fallbackProvider = fallbackProvider;
    }

    @NotNull
    RemotingOperations getOperations() throws IOException {
        RemotingOperations operations;
        block8: {
            Connection connection = (Connection)AccessController.doPrivileged(() -> this.endpoint.getConnection(this.location, "jta", "jboss")).get();
            Attachments attachments = connection.getAttachments();
            operations = (RemotingOperations)attachments.getAttachment(key);
            if (operations != null) {
                return operations;
            }
            try {
                operations = TransactionClientChannel.forConnection(connection);
                RemotingOperations appearing = (RemotingOperations)attachments.attachIfAbsent(key, (Object)operations);
                if (appearing != null) {
                    return appearing;
                }
            }
            catch (ServiceNotFoundException e) {
                RemotingFallbackPeerProvider fallbackProvider = this.fallbackProvider;
                if (fallbackProvider == null) {
                    throw e;
                }
                try {
                    operations = fallbackProvider.getOperations(connection);
                }
                catch (ServiceNotFoundException e1) {
                    e1.addSuppressed((Throwable)e);
                    throw e1;
                }
                if (operations == null) {
                    throw e;
                }
                RemotingOperations appearing = (RemotingOperations)attachments.attachIfAbsent(key, (Object)operations);
                if (appearing == null) break block8;
                return appearing;
            }
        }
        return operations;
    }

    RemotingOperations getOperationsXA() throws XAException {
        try {
            return this.getOperations();
        }
        catch (IOException e) {
            throw Log.log.failedToAcquireConnectionXA(e, -3);
        }
    }

    @Override
    @NotNull
    public SubordinateTransactionControl lookupXid(final Xid xid, int remainingTimeout) throws XAException {
        return new SubordinateTransactionControl(){

            @Override
            public void rollback() throws XAException {
                try {
                    RemotingRemoteTransactionPeer.this.getOperationsXA().rollback(xid);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void end(int flags) throws XAException {
                if (flags == 0x20000000 && RemotingRemoteTransactionPeer.this.rollbackOnlyXids.add(xid)) {
                    try {
                        RemotingRemoteTransactionPeer.this.getOperationsXA().setRollbackOnly(xid);
                    }
                    catch (Throwable t) {
                        RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                        throw t;
                    }
                }
            }

            @Override
            public void beforeCompletion() throws XAException {
                RemotingRemoteTransactionPeer.this.getOperationsXA().beforeCompletion(xid);
            }

            @Override
            public int prepare() throws XAException {
                try {
                    int n = RemotingRemoteTransactionPeer.this.getOperationsXA().prepare(xid);
                    return n;
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void forget() throws XAException {
                try {
                    RemotingRemoteTransactionPeer.this.getOperationsXA().forget(xid);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }

            @Override
            public void commit(boolean onePhase) throws XAException {
                try {
                    RemotingRemoteTransactionPeer.this.getOperationsXA().commit(xid, onePhase);
                }
                finally {
                    RemotingRemoteTransactionPeer.this.rollbackOnlyXids.remove(xid);
                }
            }
        };
    }

    @Override
    @NotNull
    public Xid[] recover(int flag, String parentName) throws XAException {
        return this.getOperationsXA().recover(flag, parentName);
    }

    @Override
    @NotNull
    public SimpleTransactionControl begin(int timeout) throws SystemException {
        try {
            return this.getOperations().begin(timeout);
        }
        catch (IOException e) {
            throw Log.log.failedToAcquireConnection(e);
        }
    }
}

