/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.remoting;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.util.MessageTracker;
import org.jboss.remoting3.util.StreamUtils;
import org.wildfly.common.rpc.RemoteExceptionCause;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.LocalTransactionContext;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.remoting.Protocol;
import org.wildfly.transaction.client.provider.remoting.RemotingTransactionServer;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

final class TransactionServerChannel {
    private final RemotingTransactionServer server;
    private final MessageTracker messageTracker;
    private final Channel channel;
    private final Channel.Receiver receiver = new ReceiverImpl();
    private final LocalTransactionContext localTransactionContext;
    private static final Attachments.Key<TransactionServerChannel> KEY = new Attachments.Key(TransactionServerChannel.class);

    TransactionServerChannel(RemotingTransactionServer server, Channel channel, LocalTransactionContext localTransactionContext) {
        this.server = server;
        this.channel = channel;
        this.localTransactionContext = localTransactionContext;
        this.messageTracker = new MessageTracker(channel, ((Integer)channel.getOption(RemotingOptions.MAX_OUTBOUND_MESSAGES)).intValue());
        channel.getConnection().getAttachments().attach(KEY, (Object)this);
    }

    void start() {
        this.channel.receiveMessage(this.receiver);
    }

    void handleCapabilityMessage(MessageInputStream message, int invId) throws IOException {
        while (message.read() != -1) {
            Protocol.readIntParam((InputStream)message, StreamUtils.readPackedUnsignedInt32((InputStream)message));
        }
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(0);
        }
    }

    void handleUserTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 241: {
                    context = Protocol.readIntParam((InputStream)message, len);
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.LocalTxn txn = (RemotingTransactionServer.LocalTxn)this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeSimpleResponse(27, invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.performAction(transaction::rollback);
                    this.writeSimpleResponse(27, invId);
                    return;
                }
                catch (SystemException e) {
                    this.writeExceptionResponse(27, invId, e);
                    return;
                }
                catch (Exception e) {
                    this.writeExceptionResponse(27, invId, Log.log.unexpectedException(e));
                    return;
                }
            }
            this.writeParamError(invId);
        });
    }

    void handleUserTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        int context = 0;
        int secContext = 0;
        boolean hasContext = false;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 241: {
                    context = Protocol.readIntParam((InputStream)message, len);
                    hasContext = true;
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (!hasContext) {
            this.writeParamError(invId);
            return;
        }
        RemotingTransactionServer.LocalTxn txn = (RemotingTransactionServer.LocalTxn)this.server.getTxnMap().removeKey(context);
        if (txn == null) {
            this.writeSimpleResponse(26, invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAs(() -> {
            LocalTransaction transaction = txn.getTransaction();
            if (transaction != null) {
                try {
                    transaction.performAction(transaction::commit);
                    this.writeSimpleResponse(26, invId);
                    return;
                }
                catch (HeuristicRollbackException e) {
                    this.writeExceptionResponse(26, invId, 18, (Exception)((Object)e));
                    return;
                }
                catch (RollbackException e) {
                    this.writeExceptionResponse(26, invId, 16, (Exception)((Object)e));
                    return;
                }
                catch (HeuristicMixedException e) {
                    this.writeExceptionResponse(26, invId, 17, (Exception)((Object)e));
                    return;
                }
                catch (SystemException e) {
                    this.writeExceptionResponse(26, invId, e);
                    return;
                }
                catch (Exception e) {
                    this.writeExceptionResponse(26, invId, Log.log.unexpectedException(e));
                    return;
                }
            }
            this.writeParamError(invId);
        });
    }

    void handleXaTxnRollback(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::rollback, importResult.getControl());
                this.writeSimpleResponse(18, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnRollbackOnly(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::end, importResult.getControl(), 0x20000000);
                this.writeSimpleResponse(24, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnBefore(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::beforeCompletion, importResult.getControl());
                this.writeSimpleResponse(22, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnPrepare(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                int result = importResult.getTransaction().performToIntFunction(SubordinateTransactionControl::prepare, importResult.getControl());
                if (result == 3) {
                    this.writeSimpleResponse(19, i, 7);
                } else {
                    this.writeSimpleResponse(19, i);
                }
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
        }, (Object)xid.withoutBranch(), invId);
    }

    void handleXaTxnForget(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block4;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsObjIntConsumer((x, i) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                importResult.getTransaction().performConsumer(SubordinateTransactionControl::forget, importResult.getControl());
                this.writeSimpleResponse(21, i);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, i, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, i, xae);
                return;
            }
        }, (Object)xid, invId);
    }

    void handleXaTxnCommit(MessageInputStream message, int invId) throws IOException {
        int param;
        SimpleXid xid = null;
        int secContext = 0;
        boolean hasSecContext = false;
        boolean onePhase = false;
        block5: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 1: {
                    xid = Protocol.readXid((InputStream)message, len);
                    continue block5;
                }
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block5;
                }
                case 2: {
                    onePhase = true;
                    Protocol.readIntParam((InputStream)message, len);
                    continue block5;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        if (xid == null) {
            this.writeParamError(invId);
            return;
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        securityIdentity.runAsConsumer((o, x) -> {
            try {
                ImportResult<LocalTransaction> importResult = this.localTransactionContext.findOrImportTransaction((Xid)x, 0);
                importResult.getTransaction().performConsumer((c, flag) -> c.commit((boolean)flag), importResult.getControl(), o);
                this.writeSimpleResponse(20, invId);
            }
            catch (SystemException e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, invId, xae);
                return;
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, invId, e);
                return;
            }
            catch (Exception e) {
                XAException xae = new XAException(-3);
                xae.initCause(e);
                this.writeExceptionResponse(18, invId, xae);
                return;
            }
        }, (Object)onePhase, (Object)xid.withoutBranch());
    }

    void handleXaTxnRecover(MessageInputStream message, int invId) throws IOException {
        int param;
        int secContext = 0;
        String parentName = null;
        boolean hasSecContext = false;
        block4: while ((param = message.read()) != -1) {
            int len = StreamUtils.readPackedUnsignedInt32((InputStream)message);
            switch (param) {
                case 240: {
                    secContext = Protocol.readIntParam((InputStream)message, len);
                    hasSecContext = true;
                    continue block4;
                }
                case 3: {
                    parentName = Protocol.readStringParam((InputStream)message, len);
                    continue block4;
                }
            }
            Protocol.readIntParam((InputStream)message, len);
        }
        SecurityIdentity securityIdentity = hasSecContext ? this.channel.getConnection().getLocalIdentity(secContext) : this.channel.getConnection().getLocalIdentity();
        String finalParentName = parentName;
        securityIdentity.runAs(() -> {
            Xid[] xids;
            XARecoverable recoverable = this.localTransactionContext.getRecoveryInterface();
            try {
                xids = recoverable.recover(0x1000000, finalParentName);
            }
            catch (XAException e) {
                this.writeExceptionResponse(18, invId, e);
                return;
            }
            try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
                SimpleXid simpleXid;
                boolean added;
                outputStream.writeShort(invId);
                outputStream.writeByte(23);
                HashSet<SimpleXid> seen = new HashSet<SimpleXid>();
                do {
                    added = false;
                    for (Xid xid : xids) {
                        simpleXid = SimpleXid.of(xid).withoutBranch();
                        if (!seen.add(simpleXid)) continue;
                        added = true;
                        Protocol.writeParam(1, (OutputStream)outputStream, simpleXid);
                    }
                    if (!added) continue;
                    try {
                        xids = recoverable.recover(0, finalParentName);
                    }
                    catch (XAException e) {
                        try {
                            recoverable.recover(0x800000, finalParentName);
                            this.writeExceptionResponse(18, invId, e);
                        }
                        catch (XAException e1) {
                            e1.addSuppressed(e);
                            this.writeExceptionResponse(18, invId, e1);
                        }
                        if (outputStream != null) {
                            if (var6_8 != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable e1) {
                                    var6_8.addSuppressed(e1);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        return;
                    }
                } while (xids.length > 0 && added);
                try {
                    xids = recoverable.recover(0x800000, finalParentName);
                }
                catch (XAException e) {
                    try {
                        recoverable.recover(0x800000, finalParentName);
                        this.writeExceptionResponse(18, invId, e);
                    }
                    catch (XAException e1) {
                        e1.addSuppressed(e);
                        this.writeExceptionResponse(18, invId, e1);
                    }
                    if (outputStream != null) {
                        if (var6_8 != null) {
                            try {
                                outputStream.close();
                            }
                            catch (Throwable throwable) {
                                var6_8.addSuppressed(throwable);
                            }
                        } else {
                            outputStream.close();
                        }
                    }
                    return;
                }
                for (Xid xid : xids) {
                    simpleXid = SimpleXid.of(xid).withoutBranch();
                    if (!seen.add(simpleXid)) continue;
                    Protocol.writeParam(1, (OutputStream)outputStream, xid);
                }
            }
            catch (IOException e) {
                Log.log.outboundException(e);
                try {
                    recoverable.recover(0x800000);
                }
                catch (XAException e1) {
                    Log.log.recoverySuppressedException(e1);
                }
            }
        });
    }

    void writeSimpleResponse(int msgId, int invId, int param1) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            Protocol.writeParam(param1, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, int exceptionKind, Exception e) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            StreamUtils.writeInt8((OutputStream)outputStream, (int)exceptionKind);
            RemoteExceptionCause remoteExceptionCause = RemoteExceptionCause.of((Throwable)e);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            remoteExceptionCause.writeToStream((DataOutput)dos);
            dos.flush();
            StreamUtils.writePackedUnsignedInt31((OutputStream)outputStream, (int)os.size());
            os.writeTo((OutputStream)outputStream);
        }
        catch (IOException ioe) {
            Log.log.outboundException(ioe);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, int exceptionKind, Exception e, int errorCode) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
            StreamUtils.writeInt8((OutputStream)outputStream, (int)exceptionKind);
            RemoteExceptionCause remoteExceptionCause = RemoteExceptionCause.of((Throwable)e);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(errorCode);
            remoteExceptionCause.writeToStream((DataOutput)dos);
            dos.flush();
            StreamUtils.writePackedUnsignedInt31((OutputStream)outputStream, (int)os.size());
            os.writeTo((OutputStream)outputStream);
        }
        catch (IOException ioe) {
            Log.log.outboundException(ioe);
        }
    }

    private void writeExceptionResponse(int msgId, int invId, SystemException e) {
        this.writeExceptionResponse(msgId, invId, 19, (Exception)((Object)e), e.errorCode);
    }

    private void writeExceptionResponse(int msgId, int invId, XAException e) {
        this.writeExceptionResponse(msgId, invId, 48, e, e.errorCode);
    }

    void writeSimpleResponse(int msgId, int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(msgId);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    void writeParamError(int invId) {
        try (MessageOutputStream outputStream = this.messageTracker.openMessageUninterruptibly();){
            outputStream.writeShort(invId);
            outputStream.writeByte(254);
        }
        catch (IOException e) {
            Log.log.outboundException(e);
        }
    }

    class ReceiverImpl
    implements Channel.Receiver {
        ReceiverImpl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Channel channel, MessageInputStream messageOriginal) {
            channel.receiveMessage((Channel.Receiver)this);
            try (MessageInputStream message = messageOriginal;){
                int invId = message.readUnsignedShort();
                try {
                    int id = message.readUnsignedByte();
                    switch (id) {
                        case 0: {
                            TransactionServerChannel.this.handleCapabilityMessage(message, invId);
                            return;
                        }
                        case 11: {
                            TransactionServerChannel.this.handleUserTxnRollback(message, invId);
                            return;
                        }
                        case 10: {
                            TransactionServerChannel.this.handleUserTxnCommit(message, invId);
                            return;
                        }
                        case 2: {
                            TransactionServerChannel.this.handleXaTxnRollback(message, invId);
                            return;
                        }
                        case 6: {
                            TransactionServerChannel.this.handleXaTxnBefore(message, invId);
                            return;
                        }
                        case 3: {
                            TransactionServerChannel.this.handleXaTxnPrepare(message, invId);
                            return;
                        }
                        case 5: {
                            TransactionServerChannel.this.handleXaTxnForget(message, invId);
                            return;
                        }
                        case 4: {
                            TransactionServerChannel.this.handleXaTxnCommit(message, invId);
                            return;
                        }
                        case 7: {
                            TransactionServerChannel.this.handleXaTxnRecover(message, invId);
                            return;
                        }
                        case 8: {
                            TransactionServerChannel.this.handleXaTxnRollbackOnly(message, invId);
                            return;
                        }
                    }
                    try {
                        MessageOutputStream outputStream;
                        block53: {
                            outputStream = TransactionServerChannel.this.messageTracker.openMessageUninterruptibly();
                            Throwable throwable = null;
                            try {
                                outputStream.writeShort(invId);
                                outputStream.writeByte(255);
                                if (outputStream == null) return;
                                if (throwable == null) break block53;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (outputStream == null) throw throwable3;
                                    if (throwable == null) {
                                        outputStream.close();
                                        throw throwable3;
                                    }
                                    try {
                                        outputStream.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                            }
                            try {
                                outputStream.close();
                                return;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                return;
                            }
                        }
                        outputStream.close();
                        return;
                    }
                    catch (IOException e) {
                        Log.log.outboundException(e);
                        return;
                    }
                }
                catch (Throwable t) {
                    try (MessageOutputStream outputStream = TransactionServerChannel.this.messageTracker.openMessageUninterruptibly();){
                        outputStream.writeShort(invId);
                        outputStream.writeByte(255);
                        throw t;
                    }
                    catch (IOException e) {
                        Log.log.outboundException(e);
                    }
                    throw t;
                }
            }
            catch (IOException e) {
                Log.log.inboundException(e);
            }
        }

        public void handleError(Channel channel, IOException error) {
        }

        public void handleEnd(Channel channel) {
        }
    }
}

