/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.OutflowHandleManager;
import org.wildfly.transaction.client.RemoteTransactionContext;
import org.wildfly.transaction.client.SerializedXAResource;
import org.wildfly.transaction.client.XAOutflowHandle;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.RemoteTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

final class SubordinateXAResource
implements XAResource,
XARecoverable,
Serializable {
    private static final long serialVersionUID = 444691792601946632L;
    private static final int DEFAULT_TIMEOUT = 43200;
    private final URI location;
    private final String parentName;
    private volatile int timeout = 43200;
    private long startTime = 0L;
    private volatile Xid xid;
    private int capturedTimeout;
    private final AtomicInteger stateRef = new AtomicInteger(0);

    SubordinateXAResource(URI location, String parentName) {
        this.location = location;
        this.parentName = parentName;
    }

    SubordinateXAResource(URI location, int flags, String parentName) {
        this.location = location;
        this.parentName = parentName;
        this.stateRef.set(flags);
    }

    Xid getXid() {
        return this.xid;
    }

    XAOutflowHandle addHandle(final Xid xid) {
        if (!OutflowHandleManager.open(this.stateRef)) {
            throw Log.log.invalidTxnState();
        }
        return new XAOutflowHandle(){
            private final AtomicBoolean done = new AtomicBoolean();

            @Override
            @NotNull
            public Xid getXid() {
                return xid;
            }

            @Override
            public int getRemainingTime() {
                return SubordinateXAResource.this.getRemainingTime();
            }

            @Override
            public void forgetEnlistment() {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyForgotten();
                }
                OutflowHandleManager.forgetOne(SubordinateXAResource.this.stateRef);
            }

            @Override
            public void nonMasterEnlistment() {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyForgotten();
                }
                OutflowHandleManager.nonMasterOne(SubordinateXAResource.this.stateRef);
            }

            @Override
            public void verifyEnlistment() throws RollbackException, SystemException {
                if (!this.done.compareAndSet(false, true)) {
                    throw Log.log.alreadyEnlisted();
                }
                OutflowHandleManager.verifyOne(SubordinateXAResource.this.stateRef);
            }
        };
    }

    boolean commitToEnlistment() {
        return OutflowHandleManager.commit(this.stateRef);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0x200000) {
            throw Assert.unreachableCode();
        }
        this.startTime = System.nanoTime();
        this.capturedTimeout = this.timeout;
        this.lookup(xid);
        this.xid = xid;
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (flags == 0x4000000 || flags == 0x20000000) {
            this.lookup(xid).end(flags);
        }
    }

    public void beforeCompletion(Xid xid) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).beforeCompletion();
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return this.commitToEnlistment() ? this.lookup(xid).prepare() : 3;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).commit(onePhase);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).rollback();
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (this.commitToEnlistment()) {
            this.lookup(xid).forget();
        }
    }

    private SubordinateTransactionControl lookup(Xid xid) throws XAException {
        return this.getProvider().getPeerHandleForXa(this.location).lookupXid(xid);
    }

    private RemoteTransactionProvider getProvider() {
        return RemoteTransactionContext.getInstancePrivate().getProvider(this.location);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.recover(flag, this.parentName);
    }

    @Override
    public Xid[] recover(int flag, String parentName) throws XAException {
        return this.getProvider().getPeerHandleForXa(this.location).recover(flag, parentName);
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        return xaRes instanceof SubordinateXAResource && this.location.equals(((SubordinateXAResource)xaRes).location);
    }

    @Override
    public int getTransactionTimeout() {
        return this.timeout;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw Log.log.negativeTxnTimeoutXa(-5);
        }
        this.timeout = seconds == 0 ? 43200 : seconds;
        return true;
    }

    Object writeReplace() {
        return new SerializedXAResource(this.location, this.parentName);
    }

    public String toString() {
        return Log.log.subordinateXaResource(this.location);
    }

    int getRemainingTime() {
        long elapsed = Math.max(0L, System.nanoTime() - this.startTime);
        int capturedTimeout = this.capturedTimeout;
        return capturedTimeout - (int)Math.min((long)capturedTimeout, elapsed / 1000000L);
    }
}

