/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client._private;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.ServiceConfigurationError;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Endpoint;
import org.wildfly.transaction.client.DelayedEnlistmentException;
import org.wildfly.transaction.client.SynchronizationException;
import org.wildfly.transaction.client._private.Log;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final String subordinateXaResource = "Subordinate XAResource at %s";
    private static final String serviceConfigurationFailed = "Failed to configure a remote transaction service provider";
    private static final String recoverySuppressedException = "Closing the recovery stream after recovery failed threw an exception";
    private static final String inboundException = "Got exception on inbound message";
    private static final String outboundException = "Got exception on outbound message";
    private static final String noTransaction = "No transaction associated with the current thread";
    private static final String nestedNotSupported = "WFTXN0001: A transaction is already in progress";
    private static final String notSupportedTransaction = "WFTXN0002: Transaction is not a supported instance: %s";
    private static final String invalidTransactionLocationUri = "WFTXN0003: Invalid transaction location URI (must be absolute): %s";
    private static final String noProviderForUri = "WFTXN0004: No transaction provider installed for URI: %s";
    private static final String transactionNotAssociatedWithThisProvider = "WFTXN0005: Transaction not associated with this provider";
    private static final String negativeTxnTimeout = "WFTXN0006: Negative transaction timeout provided";
    private static final String alreadyAssociated = "WFTXN0007: A transaction is already associated with the current thread";
    private static final String registerSynchRemoteTransaction = "WFTXN0008: Cannot register a synchronization on a remote transaction";
    private static final String enlistDelistRemoteTransaction = "WFTXN0009: Cannot enlist or delist resources on a remote transaction";
    private static final String failedToReceive = "WFTXN0010: Failed to receive protocol message from remote peer";
    private static final String failedToSend = "WFTXN0011: Failed to send protocol message to remote peer";
    private static final String peerSystemException = "WFTXN0012: The peer threw a SystemException; see peer logs for more information";
    private static final String peerSecurityException = "WFTXN0013: The peer threw a SecurityException; see peer logs for more information";
    private static final String protocolError = "WFTXN0014: An unexpected protocol error occurred";
    private static final String operationInterrupted = "WFTXN0015: The protocol operation was interrupted locally";
    private static final String transactionRolledBackByPeer = "WFTXN0016: The remote peer rolled back the transaction";
    private static final String rollbackOnlyRollback = "WFTXN0017: Rollback-only transaction rolled back";
    private static final String invalidTxnState = "WFTXN0018: Invalid transaction state";
    private static final String peerHeuristicMixedException = "WFTXN0019: The peer threw a HeuristicMixedException; see peer logs for more information";
    private static final String peerHeuristicRollbackException = "WFTXN0020: The peer threw a HeuristicRollbackException; see peer logs for more information";
    private static final String failedToAcquireConnection = "WFTXN0021: Failed to acquire a connection for this operation";
    private static final String duplicateEnlistment = "WFTXN0022: The resource manager for remote connection to %s was already enlisted in a transaction";
    private static final String invalidFlags = "WFTXN0023: Invalid flag value";
    private static final String duplicateTransaction = "WFTXN0024: Duplicate transaction encountered for destination %s, transaction ID %s";
    private static final String failedToReceiveXA = "WFTXN0025: Failed to receive protocol message from remote peer";
    private static final String failedToSendXA = "WFTXN0026: Failed to send protocol message to remote peer";
    private static final String operationInterruptedXA = "WFTXN0027: The protocol operation was interrupted locally";
    private static final String protocolErrorXA = "WFTXN0028: An unexpected protocol error occurred";
    private static final String peerXaException = "WFTXN0029: The peer threw an XA exception";
    private static final String invalidHandleType = "WFTXN0030: Invalid handle type; expected %s, actually received %s";
    private static final String commitOnImported = "WFTXN0031: Commit not allowed on imported transaction";
    private static final String rollbackOnImported = "WFTXN0032: Rollback not allowed on imported transaction";
    private static final String multipleProvidersRegistered = "WFTXN0033: Multiple remote transaction providers registered on endpoint: %s";
    private static final String failedToAcquireConnectionXA = "WFTXN0034: Failed to acquire a connection for this operation";
    private static final String invalidHandleTypeRequested = "WFTXN0035: Invalid handle type requested; expected a subtype of Transaction (non-inclusive), got %s";
    private static final String interruptedXA = "WFTXN0036: Transaction operation failed due to thread interruption";
    private static final String noTransactionProvider = "WFTXN0037: No transaction provider associated with the current thread";
    private static final String noLocalTransactionProvider = "WFTXN0038: No local transaction provider associated with the current thread";
    private static final String nullTransaction = "WFTXN0039: Invalid null transaction";
    private static final String rollbackFailed = "WFTXN0040: Rollback failed unexpectedly";
    private static final String noProviderInterface = "WFTXN0041: No provider interface matching %s is available from the transaction provider";
    private static final String connectionFailed = "WFTXN0042: Connection to remote transaction service failed";
    private static final String connectionInterrupted = "WFTXN0043: Connection to remote transaction service interrupted";
    private static final String unknownResponse = "WFTXN0044: Unknown response received from peer";
    private static final String responseFailed = "WFTXN0045: Failed to receive a response from peer";
    private static final String peerIllegalStateException = "WFTXN0046: The peer threw an IllegalStateException; see peer logs for more information";
    private static final String unknownResponseXa = "WFTXN0047: Unknown XA response received from peer";
    private static final String responseFailedXa = "WFTXN0048: Failed to receive an XA response from peer";
    private static final String negativeTxnTimeoutXa = "WFTXN0049: Negative transaction timeout provided";
    private static final String unrecognizedParameter = "WFTXN0050: Unrecognized parameter with ID 0x%02x received";
    private static final String expectedParameter = "WFTXN0051: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    private static final String expectedParameterXa = "WFTXN0052: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    private static final String delayedEnlistmentFailed = "WFTXN0053: Delayed enlistment has failed";
    private static final String beforeCompletionFailed = "WFTXN0054: Before-completion failed for resource %s";
    private static final String onePhaseUserTransaction = "WFTXN0055: Two-phase operation on single-phase transaction";
    private static final String unknownProvider = "WFTXN0056: Unknown provider for remote transactions with URI scheme \"%s\"";
    private static final String outflowAcrossTransactionManagers = "WFTXN0057: Attempted to outflow the same transaction from two different transaction managers";
    private static final String alreadyEnlisted = "WFTXN0058: This delayed enlistment handle was already enlisted";
    private static final String alreadyForgotten = "WFTXN0059: This delayed enlistment handle was already forgotten";
    private static final String transactionTimedOut = "WFTXN0060: Transaction timed out";
    private static final String markedRollbackOnly = "WFTXN0061: Transaction is marked rollback-only";
    private static final String notActive = "WFTXN0062: Transaction is not active";
    private static final String providerCreatedNullTransaction = "WFTXN0063: Provider created a null transaction";
    private static final String invalidConnectionEndpoint = "WFTXN0064: Invalid connection endpoint provided";
    private static final String noTransactionForId = "WFTXN0065: No transaction for ID %d";
    private static final String rollbackOnlyFailed = "WFTXN0066: Failed to set transaction as rollback-only";
    private static final String notActiveXA = "WFTXN0067: Transaction is not active";
    private static final String couldNotEnlist = "WFTXN0068: Subordinate enlistment failed for unknown reason";
    private static final String invalidTransactionConnection = "WFTXN0069: Connection does not match the transaction; the connection may have closed";
    private static final String noTransactionXa = "WFTXN0070: No such transaction";
    private static final String unexpectedFailure = "WFTXN0071: An unexpected failure condition occurred";
    private static final String noLocalTransactionProviderNodeName = "WFTXN0072: No local transaction provider node name specified in the transaction manager environment";
    private static final String unexpectedProviderTransactionMismatch = "WFTXN0073: Unexpected provider transaction mismatch; expected %s, got %s";
    private static final String heuristicMixedXa = "WFTXN0074: Heuristic-mixed outcome";
    private static final String heuristicCommitXa = "WFTXN0075: Heuristic-commit outcome";
    private static final String rollbackXa = "WFTXN0076: Transaction rolled back";
    private static final String heuristicRollbackXa = "WFTXN0077: Heuristic-rollback outcome";
    private static final String illegalStateXa = "WFTXN0078: Invalid transaction state";
    private static final String resourceManagerErrorXa = "WFTXN0079: An unexpected resource manager error occurred";
    private static final String notImportedXa = "WFTXN0080: Operation not allowed on non-imported transaction";
    private static final String invalidTxStateXa = "WFTXN0081: Invalid transaction state for operation";
    private static final String suspendedCannotCreateNew = "WFTXN0082: Cannot import a new transaction on a suspended server";
    private static final String suspendedCannotImportXa = "WFTXN0083: Cannot import a new transaction on a suspended server";
    private static final String forbiddenContextForUserTransaction = "WFTXN0084: UserTransaction access is forbidden in the current context";
    private static final String unexpectedException = "WFTXN0085: Operation failed with an unexpected exception type";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected String subordinateXaResource$str() {
        return subordinateXaResource;
    }

    @Override
    public final String subordinateXaResource(URI location) {
        return String.format(this.subordinateXaResource$str(), location);
    }

    @Override
    public final void serviceConfigurationFailed(ServiceConfigurationError e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.serviceConfigurationFailed$str(), new Object[0]);
    }

    protected String serviceConfigurationFailed$str() {
        return serviceConfigurationFailed;
    }

    @Override
    public final void recoverySuppressedException(XAException e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)e, this.recoverySuppressedException$str(), new Object[0]);
    }

    protected String recoverySuppressedException$str() {
        return recoverySuppressedException;
    }

    @Override
    public final void inboundException(Throwable e) {
        this.log.logf(FQCN, Logger.Level.TRACE, e, this.inboundException$str(), new Object[0]);
    }

    protected String inboundException$str() {
        return inboundException;
    }

    @Override
    public final void outboundException(Throwable e) {
        this.log.logf(FQCN, Logger.Level.TRACE, e, this.outboundException$str(), new Object[0]);
    }

    protected String outboundException$str() {
        return outboundException;
    }

    protected String noTransaction$str() {
        return noTransaction;
    }

    @Override
    public final IllegalStateException noTransaction() {
        IllegalStateException result = new IllegalStateException(String.format(this.noTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nestedNotSupported$str() {
        return nestedNotSupported;
    }

    @Override
    public final NotSupportedException nestedNotSupported() {
        NotSupportedException result = new NotSupportedException(String.format(this.nestedNotSupported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notSupportedTransaction$str() {
        return notSupportedTransaction;
    }

    @Override
    public final InvalidTransactionException notSupportedTransaction(Transaction transaction) {
        InvalidTransactionException result = new InvalidTransactionException(String.format(this.notSupportedTransaction$str(), transaction));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTransactionLocationUri$str() {
        return invalidTransactionLocationUri;
    }

    @Override
    public final IllegalArgumentException invalidTransactionLocationUri(URI uri) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidTransactionLocationUri$str(), uri));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noProviderForUri$str() {
        return noProviderForUri;
    }

    @Override
    public final IllegalArgumentException noProviderForUri(URI uri) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.noProviderForUri$str(), uri));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionNotAssociatedWithThisProvider$str() {
        return transactionNotAssociatedWithThisProvider;
    }

    @Override
    public final InvalidTransactionException transactionNotAssociatedWithThisProvider() {
        InvalidTransactionException result = new InvalidTransactionException(String.format(this.transactionNotAssociatedWithThisProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String negativeTxnTimeout$str() {
        return negativeTxnTimeout;
    }

    @Override
    public final SystemException negativeTxnTimeout() {
        SystemException result = new SystemException(String.format(this.negativeTxnTimeout$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyAssociated$str() {
        return alreadyAssociated;
    }

    @Override
    public final IllegalStateException alreadyAssociated() {
        IllegalStateException result = new IllegalStateException(String.format(this.alreadyAssociated$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String registerSynchRemoteTransaction$str() {
        return registerSynchRemoteTransaction;
    }

    @Override
    public final UnsupportedOperationException registerSynchRemoteTransaction() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.registerSynchRemoteTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String enlistDelistRemoteTransaction$str() {
        return enlistDelistRemoteTransaction;
    }

    @Override
    public final UnsupportedOperationException enlistDelistRemoteTransaction() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.enlistDelistRemoteTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToReceive$str() {
        return failedToReceive;
    }

    @Override
    public final SystemException failedToReceive(IOException e) {
        SystemException result = new SystemException(String.format(this.failedToReceive$str(), new Object[0]));
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToSend$str() {
        return failedToSend;
    }

    @Override
    public final SystemException failedToSend(Exception e) {
        SystemException result = new SystemException(String.format(this.failedToSend$str(), new Object[0]));
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerSystemException$str() {
        return peerSystemException;
    }

    @Override
    public final SystemException peerSystemException() {
        SystemException result = new SystemException(String.format(this.peerSystemException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerSecurityException$str() {
        return peerSecurityException;
    }

    @Override
    public final SecurityException peerSecurityException() {
        SecurityException result = new SecurityException(String.format(this.peerSecurityException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String protocolError$str() {
        return protocolError;
    }

    @Override
    public final SystemException protocolError() {
        SystemException result = new SystemException(String.format(this.protocolError$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String operationInterrupted$str() {
        return operationInterrupted;
    }

    @Override
    public final SystemException operationInterrupted() {
        SystemException result = new SystemException(String.format(this.operationInterrupted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionRolledBackByPeer$str() {
        return transactionRolledBackByPeer;
    }

    @Override
    public final RollbackException transactionRolledBackByPeer() {
        RollbackException result = new RollbackException(String.format(this.transactionRolledBackByPeer$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackOnlyRollback$str() {
        return rollbackOnlyRollback;
    }

    @Override
    public final RollbackException rollbackOnlyRollback() {
        RollbackException result = new RollbackException(String.format(this.rollbackOnlyRollback$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTxnState$str() {
        return invalidTxnState;
    }

    @Override
    public final IllegalStateException invalidTxnState() {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidTxnState$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerHeuristicMixedException$str() {
        return peerHeuristicMixedException;
    }

    @Override
    public final HeuristicMixedException peerHeuristicMixedException() {
        HeuristicMixedException result = new HeuristicMixedException(String.format(this.peerHeuristicMixedException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerHeuristicRollbackException$str() {
        return peerHeuristicRollbackException;
    }

    @Override
    public final HeuristicRollbackException peerHeuristicRollbackException() {
        HeuristicRollbackException result = new HeuristicRollbackException(String.format(this.peerHeuristicRollbackException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToAcquireConnection$str() {
        return failedToAcquireConnection;
    }

    @Override
    public final SystemException failedToAcquireConnection(IOException reason) {
        SystemException result = new SystemException(String.format(this.failedToAcquireConnection$str(), new Object[0]));
        result.initCause((Throwable)reason);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateEnlistment$str() {
        return duplicateEnlistment;
    }

    @Override
    public final XAException duplicateEnlistment(int errorCode, URI uri) {
        XAException result = new XAException(String.format(this.duplicateEnlistment$str(), uri));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String invalidFlags$str() {
        return invalidFlags;
    }

    @Override
    public final IllegalArgumentException invalidFlags() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidFlags$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateTransaction$str() {
        return duplicateTransaction;
    }

    @Override
    public final XAException duplicateTransaction(int errorCode, URI uri, Xid xid) {
        XAException result = new XAException(String.format(this.duplicateTransaction$str(), uri, xid));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String failedToReceiveXA$str() {
        return failedToReceiveXA;
    }

    @Override
    public final XAException failedToReceiveXA(IOException e, int errorCode) {
        XAException result = new XAException(String.format(this.failedToReceiveXA$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String failedToSendXA$str() {
        return failedToSendXA;
    }

    @Override
    public final XAException failedToSendXA(Exception e, int errorCode) {
        XAException result = new XAException(String.format(this.failedToSendXA$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String operationInterruptedXA$str() {
        return operationInterruptedXA;
    }

    @Override
    public final XAException operationInterruptedXA(int errorCode) {
        XAException result = new XAException(String.format(this.operationInterruptedXA$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String protocolErrorXA$str() {
        return protocolErrorXA;
    }

    @Override
    public final XAException protocolErrorXA(int errorCode) {
        XAException result = new XAException(String.format(this.protocolErrorXA$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String peerXaException$str() {
        return peerXaException;
    }

    @Override
    public final XAException peerXaException(int errorCode) {
        XAException result = new XAException(String.format(this.peerXaException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String invalidHandleType$str() {
        return invalidHandleType;
    }

    public final IllegalArgumentException invalidHandleType(Class<? extends Object> expected, Class<? extends Object> actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidHandleType$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String commitOnImported$str() {
        return commitOnImported;
    }

    @Override
    public final SystemException commitOnImported() {
        SystemException result = new SystemException(String.format(this.commitOnImported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackOnImported$str() {
        return rollbackOnImported;
    }

    @Override
    public final SystemException rollbackOnImported() {
        SystemException result = new SystemException(String.format(this.rollbackOnImported$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleProvidersRegistered$str() {
        return multipleProvidersRegistered;
    }

    @Override
    public final IllegalStateException multipleProvidersRegistered(Endpoint e) {
        IllegalStateException result = new IllegalStateException(String.format(this.multipleProvidersRegistered$str(), e));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedToAcquireConnectionXA$str() {
        return failedToAcquireConnectionXA;
    }

    @Override
    public final XAException failedToAcquireConnectionXA(IOException e, int errorCode) {
        XAException result = new XAException(String.format(this.failedToAcquireConnectionXA$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String invalidHandleTypeRequested$str() {
        return invalidHandleTypeRequested;
    }

    public final IllegalArgumentException invalidHandleTypeRequested(Class<? extends Object> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidHandleTypeRequested$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interruptedXA$str() {
        return interruptedXA;
    }

    @Override
    public final XAException interruptedXA(int errorCode) {
        XAException result = new XAException(String.format(this.interruptedXA$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String noTransactionProvider$str() {
        return noTransactionProvider;
    }

    @Override
    public final IllegalStateException noTransactionProvider() {
        IllegalStateException result = new IllegalStateException(String.format(this.noTransactionProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noLocalTransactionProvider$str() {
        return noLocalTransactionProvider;
    }

    @Override
    public final IllegalStateException noLocalTransactionProvider() {
        IllegalStateException result = new IllegalStateException(String.format(this.noLocalTransactionProvider$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullTransaction$str() {
        return nullTransaction;
    }

    @Override
    public final NullPointerException nullTransaction() {
        NullPointerException result = new NullPointerException(String.format(this.nullTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void rollbackFailed(Throwable e) {
        this.log.logf(FQCN, Logger.Level.DEBUG, e, this.rollbackFailed$str(), new Object[0]);
    }

    protected String rollbackFailed$str() {
        return rollbackFailed;
    }

    protected String noProviderInterface$str() {
        return noProviderInterface;
    }

    public final IllegalStateException noProviderInterface(Class<? extends Object> clazz) {
        IllegalStateException result = new IllegalStateException(String.format(this.noProviderInterface$str(), clazz));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionFailed$str() {
        return connectionFailed;
    }

    @Override
    public final SystemException connectionFailed(Throwable cause) {
        SystemException result = new SystemException(String.format(this.connectionFailed$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String connectionInterrupted$str() {
        return connectionInterrupted;
    }

    @Override
    public final SystemException connectionInterrupted() {
        SystemException result = new SystemException(String.format(this.connectionInterrupted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResponse$str() {
        return unknownResponse;
    }

    @Override
    public final SystemException unknownResponse() {
        SystemException result = new SystemException(String.format(this.unknownResponse$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String responseFailed$str() {
        return responseFailed;
    }

    @Override
    public final SystemException responseFailed(IOException cause) {
        SystemException result = new SystemException(String.format(this.responseFailed$str(), new Object[0]));
        result.initCause((Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String peerIllegalStateException$str() {
        return peerIllegalStateException;
    }

    @Override
    public final IllegalStateException peerIllegalStateException() {
        IllegalStateException result = new IllegalStateException(String.format(this.peerIllegalStateException$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResponseXa$str() {
        return unknownResponseXa;
    }

    @Override
    public final XAException unknownResponseXa(int errorCode) {
        XAException result = new XAException(String.format(this.unknownResponseXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String responseFailedXa$str() {
        return responseFailedXa;
    }

    @Override
    public final XAException responseFailedXa(IOException cause, int errorCode) {
        XAException result = new XAException(String.format(this.responseFailedXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String negativeTxnTimeoutXa$str() {
        return negativeTxnTimeoutXa;
    }

    @Override
    public final XAException negativeTxnTimeoutXa(int errorCode) {
        XAException result = new XAException(String.format(this.negativeTxnTimeoutXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String unrecognizedParameter$str() {
        return unrecognizedParameter;
    }

    @Override
    public final XAException unrecognizedParameter(int errorCode, int id) {
        XAException result = new XAException(String.format(this.unrecognizedParameter$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String expectedParameter$str() {
        return expectedParameter;
    }

    @Override
    public final SystemException expectedParameter(int expected, int actual) {
        SystemException result = new SystemException(String.format(this.expectedParameter$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedParameterXa$str() {
        return expectedParameterXa;
    }

    @Override
    public final XAException expectedParameterXa(int errorCode, int expected, int actual) {
        XAException result = new XAException(String.format(this.expectedParameterXa$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String delayedEnlistmentFailed$str() {
        return delayedEnlistmentFailed;
    }

    @Override
    public final DelayedEnlistmentException delayedEnlistmentFailed(Throwable cause) {
        DelayedEnlistmentException result = new DelayedEnlistmentException(String.format(this.delayedEnlistmentFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }

    @Override
    public final SynchronizationException beforeCompletionFailed(Throwable cause, XAResource resource) {
        SynchronizationException result = new SynchronizationException(String.format(this.beforeCompletionFailed$str(), resource), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String onePhaseUserTransaction$str() {
        return onePhaseUserTransaction;
    }

    @Override
    public final XAException onePhaseUserTransaction(int errorCode) {
        XAException result = new XAException(String.format(this.onePhaseUserTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String unknownProvider$str() {
        return unknownProvider;
    }

    @Override
    public final IllegalArgumentException unknownProvider(String scheme) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.unknownProvider$str(), scheme));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String outflowAcrossTransactionManagers$str() {
        return outflowAcrossTransactionManagers;
    }

    @Override
    public final SystemException outflowAcrossTransactionManagers() {
        SystemException result = new SystemException(String.format(this.outflowAcrossTransactionManagers$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyEnlisted$str() {
        return alreadyEnlisted;
    }

    @Override
    public final IllegalStateException alreadyEnlisted() {
        IllegalStateException result = new IllegalStateException(String.format(this.alreadyEnlisted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String alreadyForgotten$str() {
        return alreadyForgotten;
    }

    @Override
    public final IllegalStateException alreadyForgotten() {
        IllegalStateException result = new IllegalStateException(String.format(this.alreadyForgotten$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String transactionTimedOut$str() {
        return transactionTimedOut;
    }

    @Override
    public final XAException transactionTimedOut(int errorCode) {
        XAException result = new XAException(String.format(this.transactionTimedOut$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String markedRollbackOnly$str() {
        return markedRollbackOnly;
    }

    @Override
    public final RollbackException markedRollbackOnly() {
        RollbackException result = new RollbackException(String.format(this.markedRollbackOnly$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notActive$str() {
        return notActive;
    }

    @Override
    public final IllegalStateException notActive() {
        IllegalStateException result = new IllegalStateException(String.format(this.notActive$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String providerCreatedNullTransaction$str() {
        return providerCreatedNullTransaction;
    }

    @Override
    public final IllegalStateException providerCreatedNullTransaction() {
        IllegalStateException result = new IllegalStateException(String.format(this.providerCreatedNullTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidConnectionEndpoint$str() {
        return invalidConnectionEndpoint;
    }

    @Override
    public final IllegalArgumentException invalidConnectionEndpoint() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidConnectionEndpoint$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noTransactionForId$str() {
        return noTransactionForId;
    }

    @Override
    public final SystemException noTransactionForId(int id) {
        SystemException result = new SystemException(String.format(this.noTransactionForId$str(), id));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rollbackOnlyFailed$str() {
        return rollbackOnlyFailed;
    }

    @Override
    public final XAException rollbackOnlyFailed(int errorCode, SystemException e) {
        XAException result = new XAException(String.format(this.rollbackOnlyFailed$str(), new Object[0]));
        result.initCause(e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String notActiveXA$str() {
        return notActiveXA;
    }

    @Override
    public final XAException notActiveXA(int errorCode) {
        XAException result = new XAException(String.format(this.notActiveXA$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String couldNotEnlist$str() {
        return couldNotEnlist;
    }

    @Override
    public final SystemException couldNotEnlist() {
        SystemException result = new SystemException(String.format(this.couldNotEnlist$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTransactionConnection$str() {
        return invalidTransactionConnection;
    }

    @Override
    public final InvalidTransactionException invalidTransactionConnection() {
        InvalidTransactionException result = new InvalidTransactionException(String.format(this.invalidTransactionConnection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noTransactionXa$str() {
        return noTransactionXa;
    }

    @Override
    public final XAException noTransactionXa(int errorCode) {
        XAException result = new XAException(String.format(this.noTransactionXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String unexpectedFailure$str() {
        return unexpectedFailure;
    }

    @Override
    public final IllegalStateException unexpectedFailure(Throwable e) {
        IllegalStateException result = new IllegalStateException(String.format(this.unexpectedFailure$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noLocalTransactionProviderNodeName$str() {
        return noLocalTransactionProviderNodeName;
    }

    @Override
    public final IllegalStateException noLocalTransactionProviderNodeName() {
        IllegalStateException result = new IllegalStateException(String.format(this.noLocalTransactionProviderNodeName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedProviderTransactionMismatch$str() {
        return unexpectedProviderTransactionMismatch;
    }

    @Override
    public final IllegalStateException unexpectedProviderTransactionMismatch(Transaction expected, Transaction actual) {
        IllegalStateException result = new IllegalStateException(String.format(this.unexpectedProviderTransactionMismatch$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String heuristicMixedXa$str() {
        return heuristicMixedXa;
    }

    @Override
    public final XAException heuristicMixedXa(int errorCode, HeuristicMixedException cause) {
        XAException result = new XAException(String.format(this.heuristicMixedXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String heuristicCommitXa$str() {
        return heuristicCommitXa;
    }

    @Override
    public final XAException heuristicCommitXa(int errorCode, HeuristicCommitException cause) {
        XAException result = new XAException(String.format(this.heuristicCommitXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String rollbackXa$str() {
        return rollbackXa;
    }

    @Override
    public final XAException rollbackXa(int errorCode, RollbackException cause) {
        XAException result = new XAException(String.format(this.rollbackXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String heuristicRollbackXa$str() {
        return heuristicRollbackXa;
    }

    @Override
    public final XAException heuristicRollbackXa(int errorCode, HeuristicRollbackException cause) {
        XAException result = new XAException(String.format(this.heuristicRollbackXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String illegalStateXa$str() {
        return illegalStateXa;
    }

    @Override
    public final XAException illegalStateXa(int errorCode, IllegalStateException cause) {
        XAException result = new XAException(String.format(this.illegalStateXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String resourceManagerErrorXa$str() {
        return resourceManagerErrorXa;
    }

    @Override
    public final XAException resourceManagerErrorXa(int errorCode, Throwable cause) {
        XAException result = new XAException(String.format(this.resourceManagerErrorXa$str(), new Object[0]));
        result.initCause(cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String notImportedXa$str() {
        return notImportedXa;
    }

    @Override
    public final XAException notImportedXa(int errorCode) {
        XAException result = new XAException(String.format(this.notImportedXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String invalidTxStateXa$str() {
        return invalidTxStateXa;
    }

    @Override
    public final XAException invalidTxStateXa(int errorCode) {
        XAException result = new XAException(String.format(this.invalidTxStateXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String suspendedCannotCreateNew$str() {
        return suspendedCannotCreateNew;
    }

    @Override
    public final SystemException suspendedCannotCreateNew() {
        SystemException result = new SystemException(String.format(this.suspendedCannotCreateNew$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String suspendedCannotImportXa$str() {
        return suspendedCannotImportXa;
    }

    @Override
    public final XAException suspendedCannotImportXa(int errorCode) {
        XAException result = new XAException(String.format(this.suspendedCannotImportXa$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }

    protected String forbiddenContextForUserTransaction$str() {
        return forbiddenContextForUserTransaction;
    }

    @Override
    public final IllegalStateException forbiddenContextForUserTransaction() {
        IllegalStateException result = new IllegalStateException(String.format(this.forbiddenContextForUserTransaction$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedException$str() {
        return unexpectedException;
    }

    @Override
    public final SystemException unexpectedException(Exception e) {
        SystemException result = new SystemException(String.format(this.unexpectedException$str(), new Object[0]));
        result.initCause((Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

