/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public final class JBossLocalTransactionProvider
implements LocalTransactionProvider {
    private final int staleTransactionTime;
    private final ExtendedJBossXATerminator ext;
    private final XATerminator xt;
    private final TransactionManager tm;
    private final TransactionSynchronizationRegistry tsr;
    private final XAImporter xi = new XAImporterImpl();
    private static final int UID_LEN = 28;
    private static final int PREPARE_OK = 0;
    private static final int PREPARE_NOTOK = 1;
    private static final int PREPARE_READONLY = 2;
    private static final int HEURISTIC_ROLLBACK = 3;
    private static final int HEURISTIC_COMMIT = 4;
    private static final int HEURISTIC_MIXED = 5;
    private static final int HEURISTIC_HAZARD = 6;
    private static final int FINISH_OK = 7;
    private static final int FINISH_ERROR = 8;
    private static final int NOT_PREPARED = 9;
    private static final int ONE_PHASE_ERROR = 10;
    private static final int INVALID_TRANSACTION = 11;
    private static final int PREPARE_ONE_PHASE_COMMITTED = 12;

    JBossLocalTransactionProvider(int staleTransactionTime, XATerminator xt, ExtendedJBossXATerminator ext, TransactionManager tm, TransactionSynchronizationRegistry tsr) {
        this.staleTransactionTime = staleTransactionTime;
        this.ext = (ExtendedJBossXATerminator)Assert.checkNotNullParam((String)"ext", (Object)ext);
        this.xt = (XATerminator)Assert.checkNotNullParam((String)"xt", (Object)xt);
        this.tm = (TransactionManager)Assert.checkNotNullParam((String)"tm", (Object)tm);
        this.tsr = (TransactionSynchronizationRegistry)Assert.checkNotNullParam((String)"tsr", (Object)tsr);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    @NotNull
    public XAImporter getXAImporter() {
        return this.xi;
    }

    @Override
    @NotNull
    public Transaction createNewTransaction(int timeout) throws SystemException, SecurityException {
        Transaction suspended = this.tm.suspend();
        try {
            this.tm.begin();
            return this.tm.suspend();
        }
        catch (NotSupportedException e) {
            throw Log.log.unexpectedFailure(e);
        }
        catch (Throwable t) {
            if (suspended != null) {
                try {
                    this.tm.resume(suspended);
                }
                catch (InvalidTransactionException e) {
                    e.addSuppressed(t);
                    throw Log.log.unexpectedFailure(e);
                }
            }
            throw t;
        }
    }

    @Override
    public boolean isImported(@NotNull Transaction transaction) throws IllegalArgumentException {
        return transaction instanceof ImportedTransaction;
    }

    @Override
    public void registerInterposedSynchronization(@NotNull Transaction transaction, @NotNull Synchronization sync) throws IllegalArgumentException {
        Transaction transactionManagerTransaction = this.safeGetTransaction();
        if (!transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(transaction, transactionManagerTransaction);
        }
        this.tsr.registerInterposedSynchronization(sync);
    }

    @Override
    public Object getResource(@NotNull Transaction transaction, @NotNull Object key) {
        Transaction transactionManagerTransaction = this.safeGetTransaction();
        if (!transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(transaction, transactionManagerTransaction);
        }
        return this.tsr.getResource(key);
    }

    private Transaction safeGetTransaction() {
        try {
            return this.tm.getTransaction();
        }
        catch (SystemException e) {
            throw Log.log.unexpectedFailure(e);
        }
    }

    @Override
    public void putResource(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
        Transaction transactionManagerTransaction = this.safeGetTransaction();
        if (!transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(transaction, transactionManagerTransaction);
        }
        this.tsr.putResource(key, value);
    }

    @Override
    public boolean getRollbackOnly(@NotNull Transaction transaction) throws IllegalArgumentException {
        Transaction transactionManagerTransaction = this.safeGetTransaction();
        if (!transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(transaction, transactionManagerTransaction);
        }
        return this.tsr.getRollbackOnly();
    }

    @Override
    @NotNull
    public Object getKey(@NotNull Transaction transaction) throws IllegalArgumentException {
        Transaction transactionManagerTransaction = this.safeGetTransaction();
        if (!transaction.equals(transactionManagerTransaction)) {
            throw Log.log.unexpectedProviderTransactionMismatch(transaction, transactionManagerTransaction);
        }
        return this.tsr.getTransactionKey();
    }

    @Override
    @NotNull
    public String getNodeName() {
        String nodeIdentifier = arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier();
        if (nodeIdentifier == null) {
            throw Log.log.noLocalTransactionProviderNodeName();
        }
        return nodeIdentifier;
    }

    @Override
    public String getNameFromXid(@NotNull Xid xid) {
        int formatId = xid.getFormatId();
        if (formatId == 131072 || formatId == 131077 || formatId == 131080) {
            byte[] gtid = xid.getGlobalTransactionId();
            int length = gtid.length;
            if (length <= 28) {
                return null;
            }
            return new String(gtid, 28, length - 28, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public <T> T getProviderInterface(Transaction transaction, Class<T> providerInterfaceType) {
        return providerInterfaceType.isInstance(transaction) ? (T)providerInterfaceType.cast(transaction) : null;
    }

    public static final class Builder {
        private int staleTransactionTime = 600;
        private ExtendedJBossXATerminator extendedJBossXATerminator;
        private XATerminator xaTerminator;
        private TransactionManager transactionManager;
        private TransactionSynchronizationRegistry transactionSynchronizationRegistry;

        Builder() {
        }

        public int getStaleTransactionTime() {
            return this.staleTransactionTime;
        }

        public Builder setStaleTransactionTime(int staleTransactionTime) {
            Assert.checkMinimumParameter((String)"staleTransactionTime", (int)1, (int)staleTransactionTime);
            this.staleTransactionTime = staleTransactionTime;
            return this;
        }

        public ExtendedJBossXATerminator getExtendedJBossXATerminator() {
            return this.extendedJBossXATerminator;
        }

        public Builder setExtendedJBossXATerminator(ExtendedJBossXATerminator ext) {
            Assert.checkNotNullParam((String)"ext", (Object)ext);
            this.extendedJBossXATerminator = ext;
            return this;
        }

        public XATerminator getXATerminator() {
            return this.xaTerminator;
        }

        public Builder setXATerminator(XATerminator xt) {
            Assert.checkNotNullParam((String)"xt", (Object)xt);
            this.xaTerminator = xt;
            return this;
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public Builder setTransactionManager(TransactionManager tm) {
            Assert.checkNotNullParam((String)"tm", (Object)tm);
            this.transactionManager = tm;
            return this;
        }

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return this.transactionSynchronizationRegistry;
        }

        public Builder setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
            Assert.checkNotNullParam((String)"tsr", (Object)tsr);
            this.transactionSynchronizationRegistry = tsr;
            return this;
        }

        public JBossLocalTransactionProvider build() {
            Assert.checkNotNullParam((String)"extendedJBossXATerminator", (Object)this.extendedJBossXATerminator);
            Assert.checkNotNullParam((String)"xaTerminator", (Object)this.xaTerminator);
            Assert.checkNotNullParam((String)"transactionManager", (Object)this.transactionManager);
            Assert.checkNotNullParam((String)"transactionSynchronizationRegistry", (Object)this.transactionSynchronizationRegistry);
            return new JBossLocalTransactionProvider(this.staleTransactionTime, this.xaTerminator, this.extendedJBossXATerminator, this.transactionManager, this.transactionSynchronizationRegistry);
        }
    }

    final class XAImporterImpl
    implements XAImporter {
        private final Map<SimpleXid, Entry> knownImported = Collections.synchronizedMap(new LinkedHashMap<SimpleXid, Entry>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<SimpleXid, Entry> eldest) {
                return eldest.getValue().getRemainingNanos() == 0L;
            }
        });

        XAImporterImpl() {
        }

        @NotNull
        public ImportResult<ImportedTransaction> findOrImportTransaction(Xid xid, int timeout) throws XAException {
            int status;
            SimpleXid simpleXid = SimpleXid.of(xid);
            SimpleXid gtid = simpleXid.withoutBranch();
            Entry entry = this.knownImported.get(gtid);
            if (entry != null) {
                int status2;
                ImportedTransaction transaction = entry.getTransaction();
                try {
                    status2 = transaction.getStatus();
                }
                catch (SystemException e) {
                    throw new XAException(-7);
                }
                if (status2 == 0 || status2 == 1) {
                    entry.growTimeout(timeout);
                } else {
                    entry.shrinkTimeout(Math.min(JBossLocalTransactionProvider.this.staleTransactionTime, timeout));
                }
                return new ImportResult<ImportedTransaction>(transaction, entry, false);
            }
            TransactionImportResult result = JBossLocalTransactionProvider.this.ext.importTransaction(xid, timeout);
            ImportedTransaction transaction = result.getTransaction();
            try {
                status = transaction.getStatus();
            }
            catch (SystemException e) {
                throw new XAException(-7);
            }
            int newTimeout = status == 0 || status == 1 ? timeout : Math.min(JBossLocalTransactionProvider.this.staleTransactionTime, timeout);
            entry = new Entry(simpleXid, transaction, newTimeout);
            this.knownImported.putIfAbsent(gtid, entry);
            return new ImportResult<ImportedTransaction>(transaction, entry, result.isNewImportedTransaction());
        }

        @Override
        public Transaction findExistingTransaction(Xid xid) throws XAException {
            SimpleXid simpleXid = SimpleXid.of(xid);
            SimpleXid gtid = simpleXid.withoutBranch();
            Entry entry = this.knownImported.get(gtid);
            if (entry != null) {
                int status;
                ImportedTransaction transaction = entry.getTransaction();
                try {
                    status = transaction.getStatus();
                }
                catch (SystemException e) {
                    throw new XAException(-7);
                }
                if (status != 0 && status != 1) {
                    entry.shrinkTimeout(JBossLocalTransactionProvider.this.staleTransactionTime);
                }
                return entry.getTransaction();
            }
            Transaction transaction = JBossLocalTransactionProvider.this.ext.getTransaction(xid);
            if (transaction == null) {
                return null;
            }
            if (!(transaction instanceof ImportedTransaction)) {
                throw new XAException(-4);
            }
            this.knownImported.putIfAbsent(gtid, new Entry(simpleXid, (ImportedTransaction)transaction, JBossLocalTransactionProvider.this.staleTransactionTime));
            return transaction;
        }

        @Override
        public void beforeComplete(Xid xid) throws XAException {
            ImportedTransaction importedTransaction = this.requireTxn(xid);
            try {
                if (!importedTransaction.doBeforeCompletion()) {
                    throw Log.log.beforeCompletionFailed(null, null);
                }
            }
            catch (SystemException e) {
                throw Log.log.beforeCompletionFailed(e, null);
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            Entry entry = this.knownImported.get(SimpleXid.of(xid).withoutBranch());
            if (entry == null) {
                throw new XAException(-4);
            }
            entry.commit(onePhase);
        }

        @Override
        public void forget(Xid xid) throws XAException {
            Entry entry = this.knownImported.get(SimpleXid.of(xid).withoutBranch());
            if (entry == null) {
                throw new XAException(-4);
            }
            entry.forget();
        }

        public int prepare(Xid xid) throws XAException {
            Entry entry = this.knownImported.get(SimpleXid.of(xid).withoutBranch());
            if (entry != null) {
                return entry.prepare();
            }
            throw new XAException(-4);
        }

        public void rollback(Xid xid) throws XAException {
            Entry entry = this.knownImported.get(SimpleXid.of(xid).withoutBranch());
            if (entry == null) {
                throw new XAException(-4);
            }
            entry.rollback();
        }

        @Override
        @NotNull
        public Xid[] recover(int flag, String parentNodeName) throws XAException {
            try {
                return JBossLocalTransactionProvider.this.ext.doRecover(null, parentNodeName);
            }
            catch (NotSupportedException e) {
                throw new XAException(-7);
            }
        }

        private ImportedTransaction requireTxn(Xid xid) throws XAException {
            ImportedTransaction importedTransaction = JBossLocalTransactionProvider.this.ext.getImportedTransaction(xid);
            if (importedTransaction == null) {
                throw Log.log.notActiveXA(-4);
            }
            return importedTransaction;
        }
    }

    final class Entry
    implements SubordinateTransactionControl {
        private final SimpleXid xid;
        private final ImportedTransaction transaction;
        private final AtomicInteger timeoutRef;
        private final long start = System.nanoTime();

        Entry(SimpleXid xid, ImportedTransaction transaction, int timeout) {
            this.xid = xid;
            this.transaction = transaction;
            this.timeoutRef = new AtomicInteger(timeout);
        }

        SimpleXid getXid() {
            return this.xid;
        }

        ImportedTransaction getTransaction() {
            return this.transaction;
        }

        int getTimeout() {
            return this.timeoutRef.get();
        }

        long getRemainingNanos() {
            return Math.max(0L, (long)this.timeoutRef.get() * 1000000000L - Math.max(0L, System.nanoTime() - this.start));
        }

        void growTimeout(int newTimeout) {
            int timeout;
            AtomicInteger timeoutRef = this.timeoutRef;
            do {
                if (newTimeout > (timeout = timeoutRef.get())) continue;
                return;
            } while (!timeoutRef.compareAndSet(timeout, newTimeout));
        }

        void shrinkTimeout(int newTimeout) {
            int timeout;
            AtomicInteger timeoutRef = this.timeoutRef;
            do {
                if (newTimeout < (timeout = timeoutRef.get())) continue;
                return;
            } while (!timeoutRef.compareAndSet(timeout, newTimeout));
        }

        @Override
        public void rollback() throws XAException {
            ImportedTransaction transaction = this.transaction;
            if (transaction.activated()) {
                try {
                    transaction.doRollback();
                }
                catch (HeuristicCommitException e) {
                    throw new XAException(7);
                }
                catch (HeuristicMixedException e) {
                    throw new XAException(5);
                }
                catch (HeuristicRollbackException e) {
                    throw new XAException(6);
                }
                catch (RuntimeException | SystemException e) {
                    throw new XAException(-3);
                }
                finally {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.xid);
                }
            }
        }

        @Override
        public void end(int flags) throws XAException {
            if (flags == 0x20000000) {
                try {
                    this.transaction.setRollbackOnly();
                }
                catch (IllegalStateException e) {
                    throw new XAException(-4);
                }
                catch (RuntimeException | SystemException e) {
                    throw new XAException(-3);
                }
            }
        }

        @Override
        public void beforeCompletion() throws XAException {
            try {
                if (!this.transaction.doBeforeCompletion()) {
                    throw new XAException(-3);
                }
            }
            catch (IllegalStateException e) {
                throw new XAException(-4);
            }
            catch (RuntimeException | SystemException e) {
                throw new XAException(-3);
            }
        }

        @Override
        public int prepare() throws XAException {
            ImportedTransaction transaction = this.transaction;
            int tpo = transaction.doPrepare();
            switch (tpo) {
                case 2: {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.xid);
                    return 3;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    try {
                        transaction.doRollback();
                    }
                    catch (HeuristicCommitException | HeuristicMixedException | HeuristicRollbackException | SystemException e) {
                        JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.xid);
                        throw this.initializeSuppressed(new XAException(-3), transaction, e);
                    }
                    throw this.initializeSuppressed(new XAException(100), transaction, null);
                }
                case 11: {
                    throw new XAException(-4);
                }
            }
            throw new XAException(104);
        }

        @Override
        public void forget() throws XAException {
            try {
                this.transaction.doForget();
            }
            catch (IllegalStateException e) {
                throw new XAException(-4);
            }
            catch (RuntimeException e) {
                throw new XAException(-3);
            }
        }

        @Override
        public void commit(boolean onePhase) throws XAException {
            ImportedTransaction transaction = this.transaction;
            try {
                if (onePhase) {
                    transaction.doOnePhaseCommit();
                } else if (!transaction.doCommit()) {
                    throw new XAException(4);
                }
            }
            catch (HeuristicMixedException e) {
                throw this.initializeSuppressed(new XAException(5), transaction, e);
            }
            catch (RollbackException e) {
                throw this.initializeSuppressed(new XAException(100), transaction, e);
            }
            catch (HeuristicCommitException e) {
                throw this.initializeSuppressed(new XAException(7), transaction, e);
            }
            catch (HeuristicRollbackException e) {
                throw this.initializeSuppressed(new XAException(6), transaction, e);
            }
            catch (IllegalStateException e) {
                throw this.initializeSuppressed(new XAException(-4), transaction, e);
            }
            catch (RuntimeException | SystemException e) {
                throw this.initializeSuppressed(new XAException(-3), transaction, e);
            }
        }

        private XAException initializeSuppressed(XAException ex, ImportedTransaction transaction, Throwable cause) {
            if (cause != null) {
                ex.initCause(cause);
            }
            try {
                if (transaction instanceof AtomicAction) {
                    for (Throwable t : ((AtomicAction)transaction).getDeferredThrowables()) {
                        ex.addSuppressed(t);
                    }
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            return ex;
        }
    }
}

