/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.security.AccessController;
import java.security.Permission;
import java.util.function.Supplier;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransactionContext
implements Contextual<LocalTransactionContext> {
    private static final ContextManager<LocalTransactionContext> CONTEXT_MANAGER = new ContextManager(LocalTransactionContext.class, "org.wildfly.transaction.client.context.local");
    private static final Supplier<LocalTransactionContext> PRIVILEGED_SUPPLIER = AccessController.doPrivileged(() -> CONTEXT_MANAGER.getPrivilegedSupplier());
    private static final Object LOCAL_TXN_KEY = new Object();
    private final LocalTransactionProvider provider;

    public LocalTransactionContext(LocalTransactionProvider provider) {
        Assert.checkNotNullParam((String)"provider", (Object)provider);
        this.provider = provider;
    }

    @NotNull
    public static ContextManager<LocalTransactionContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    @NotNull
    public ContextManager<LocalTransactionContext> getInstanceContextManager() {
        return LocalTransactionContext.getContextManager();
    }

    @NotNull
    public static LocalTransactionContext getCurrent() {
        return PRIVILEGED_SUPPLIER.get();
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout) throws SystemException, SecurityException {
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        Transaction newTransaction = this.provider.createNewTransaction(timeout);
        if (newTransaction == null) {
            throw Log.log.providerCreatedNullTransaction();
        }
        return new LocalTransaction(this, newTransaction);
    }

    @NotNull
    public ImportResult<LocalTransaction> findOrImportTransaction(Xid xid, int timeout) throws XAException {
        Assert.checkNotNullParam((String)"xid", (Object)xid);
        Assert.checkMinimumParameter((String)"timeout", (int)0, (int)timeout);
        XAImporter xaImporter = this.provider.getXAImporter();
        ImportResult<?> result = xaImporter.findOrImportTransaction(xid, timeout);
        return result.withTransaction(this.getOrAttach((Transaction)result.getTransaction(), xid));
    }

    public boolean importProviderTransaction() throws SystemException, NotSupportedException {
        ContextTransactionManager.State state = ContextTransactionManager.INSTANCE.getStateRef().get();
        if (state.transaction != null) {
            throw Log.log.nestedNotSupported();
        }
        Transaction transaction = this.provider.getTransactionManager().getTransaction();
        if (transaction == null) {
            return false;
        }
        state.transaction = this.getOrAttach(transaction, null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTransaction getOrAttach(Transaction transaction, Xid xid) {
        LocalTransaction txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
        if (txn == null) {
            Object object = LOCAL_TXN_KEY;
            synchronized (object) {
                txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
                if (txn == null) {
                    txn = new LocalTransaction(this, transaction);
                    this.provider.putResource(transaction, LOCAL_TXN_KEY, txn);
                }
            }
        }
        return txn;
    }

    @NotNull
    public XARecoverable getRecoveryInterface() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)((Object)TransactionPermission.forName("getRecoveryInterface")));
        }
        final XAImporter xaImporter = this.provider.getXAImporter();
        return new XARecoverable(){

            @Override
            public Xid[] recover(int flag, String parentName) throws XAException {
                return xaImporter.recover(flag, parentName);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaImporter.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaImporter.forget(xid);
            }
        };
    }

    LocalTransactionProvider getProvider() {
        return this.provider;
    }

    static {
        AccessController.doPrivileged(() -> {
            CONTEXT_MANAGER.setGlobalDefault((Contextual)new LocalTransactionContext(LocalTransactionProvider.EMPTY));
            return null;
        });
    }
}

