/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.util.Arrays;
import javax.transaction.xa.Xid;

public final class SimpleXid
implements Xid,
Comparable<SimpleXid> {
    public static final Xid[] NO_XIDS = new Xid[0];
    public static final SimpleXid[] NO_SIMPLE_XIDS = new SimpleXid[0];
    private static final byte[] NO_BYTES = new byte[0];
    private final int formatId;
    private final byte[] globalId;
    private final byte[] branchId;
    private final int hashCode;

    public SimpleXid(int formatId, byte[] gtId, byte[] bq) {
        this(formatId, gtId, bq, true);
    }

    private SimpleXid(int formatId, byte[] gtId, byte[] bq, boolean clone) {
        this.formatId = formatId;
        int globalIdLength = gtId.length;
        int branchIdLength = bq.length;
        byte[] byArray = globalIdLength > 0 ? (clone ? (byte[])gtId.clone() : gtId) : (this.globalId = NO_BYTES);
        this.branchId = branchIdLength > 0 ? (clone ? (byte[])bq.clone() : bq) : NO_BYTES;
        this.hashCode = (formatId * 31 + Arrays.hashCode(this.globalId)) * 31 + Arrays.hashCode(this.branchId);
    }

    @Override
    public int getFormatId() {
        return this.formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        byte[] globalId = this.globalId;
        return globalId.length == 0 ? globalId : (byte[])globalId.clone();
    }

    @Override
    public byte[] getBranchQualifier() {
        byte[] branchId = this.branchId;
        return branchId.length == 0 ? branchId : (byte[])branchId.clone();
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleXid && this.equals((SimpleXid)obj);
    }

    public boolean equals(SimpleXid obj) {
        return obj != null && this.hashCode == obj.hashCode && this.formatId == obj.formatId && Arrays.equals(this.globalId, obj.globalId) && Arrays.equals(this.branchId, obj.branchId);
    }

    public SimpleXid withoutBranch() {
        if (this.branchId.length == 0) {
            return this;
        }
        return new SimpleXid(this.formatId, this.globalId, NO_BYTES, false);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static SimpleXid of(Xid xid) {
        return xid instanceof SimpleXid ? (SimpleXid)xid : new SimpleXid(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
    }

    @Override
    public int compareTo(SimpleXid o) {
        int res = Integer.signum(this.formatId - o.formatId);
        if (res == 0) {
            res = SimpleXid.compareByteArrays(this.globalId, o.globalId);
        }
        if (res == 0) {
            res = SimpleXid.compareByteArrays(this.branchId, o.branchId);
        }
        assert (res == 0 == this.equals(o));
        return res;
    }

    private static int compareByteArrays(byte[] a1, byte[] a2) {
        int l1 = a1.length;
        int l2 = a2.length;
        int minLen = Math.min(l1, l2);
        for (int i = 0; i < minLen; ++i) {
            int res = Integer.signum((a1[i] & 0xFF) - (a2[i] & 0xFF));
            if (res == 0) continue;
            return res;
        }
        return Integer.signum(l1 - l2);
    }
}

