/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.spi;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.TransactionProvider;

public interface LocalTransactionProvider
extends TransactionProvider {
    public static final LocalTransactionProvider EMPTY = new LocalTransactionProvider(){
        private final TransactionManager transactionManager = new TransactionManager(){

            public void begin() throws NotSupportedException, SystemException {
                throw Assert.unsupported();
            }

            public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
                throw Log.log.noTransaction();
            }

            public void rollback() throws IllegalStateException, SecurityException, SystemException {
                throw Log.log.noTransaction();
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
                throw Log.log.noTransaction();
            }

            public int getStatus() throws SystemException {
                return 6;
            }

            public Transaction getTransaction() throws SystemException {
                return null;
            }

            public void setTransactionTimeout(int seconds) throws SystemException {
            }

            public Transaction suspend() throws SystemException {
                throw Log.log.noTransaction();
            }

            public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
                throw Log.log.transactionNotAssociatedWithThisProvider();
            }
        };
        private final XAImporter xaImporter = new XAImporter(){

            @Override
            public ImportResult<?> findOrImportTransaction(Xid xid, int timeout, boolean doNotImport) throws XAException {
                if (doNotImport) {
                    return null;
                }
                throw Assert.unsupported();
            }

            @Override
            public Transaction findExistingTransaction(Xid xid) throws XAException {
                return null;
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                throw Log.log.noTransactionXa(-4);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                throw Log.log.noTransactionXa(-4);
            }

            @Override
            @NotNull
            public Xid[] recover(int flag, String parentName) throws XAException {
                return SimpleXid.NO_XIDS;
            }
        };

        @Override
        @NotNull
        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        @Override
        @NotNull
        public XAImporter getXAImporter() {
            return this.xaImporter;
        }

        @Override
        @NotNull
        public Transaction createNewTransaction(int timeout) throws SystemException, SecurityException {
            throw Assert.unsupported();
        }

        @Override
        public boolean isImported(@NotNull Transaction transaction) throws IllegalArgumentException {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        public void registerInterposedSynchronization(@NotNull Transaction transaction, @NotNull Synchronization sync) throws IllegalArgumentException {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        public Object getResource(@NotNull Transaction transaction, @NotNull Object key) {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        public void putResource(@NotNull Transaction transaction, @NotNull Object key, Object value) throws IllegalArgumentException {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        public boolean getRollbackOnly(@NotNull Transaction transaction) throws IllegalArgumentException {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        @NotNull
        public Object getKey(@NotNull Transaction transaction) throws IllegalArgumentException {
            throw new IllegalArgumentException(Log.log.transactionNotAssociatedWithThisProvider().getMessage());
        }

        @Override
        public void commitLocal(@NotNull Transaction transaction) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            throw Log.log.noTransaction();
        }

        @Override
        public void rollbackLocal(@NotNull Transaction transaction) throws IllegalStateException, SystemException {
            throw Log.log.noTransaction();
        }

        @Override
        public void dropLocal(@NotNull Transaction transaction) {
        }

        @Override
        @NotNull
        public Xid getXid(@NotNull Transaction transaction) {
            throw Log.log.noTransaction();
        }

        @Override
        public int getTimeout(@NotNull Transaction transaction) {
            throw Log.log.noTransaction();
        }

        @Override
        @NotNull
        public String getNodeName() {
            return "<<none>>";
        }
    };

    @NotNull
    public TransactionManager getTransactionManager();

    @NotNull
    public XAImporter getXAImporter();

    @NotNull
    public Transaction createNewTransaction(int var1) throws SystemException, SecurityException;

    public boolean isImported(@NotNull Transaction var1) throws IllegalArgumentException;

    public void registerInterposedSynchronization(@NotNull Transaction var1, @NotNull Synchronization var2) throws IllegalArgumentException;

    public Object getResource(@NotNull Transaction var1, @NotNull Object var2);

    public void putResource(@NotNull Transaction var1, @NotNull Object var2, Object var3) throws IllegalArgumentException;

    public boolean getRollbackOnly(@NotNull Transaction var1) throws IllegalArgumentException;

    @NotNull
    public Object getKey(@NotNull Transaction var1) throws IllegalArgumentException;

    public void commitLocal(@NotNull Transaction var1) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException;

    public void rollbackLocal(@NotNull Transaction var1) throws IllegalStateException, SystemException;

    public void dropLocal(@NotNull Transaction var1);

    public int getTimeout(@NotNull Transaction var1);

    @NotNull
    public Xid getXid(@NotNull Transaction var1);

    @NotNull
    public String getNodeName();

    default public String getNameFromXid(@NotNull Xid xid) {
        return null;
    }

    default public <T> T getProviderInterface(Transaction transaction, Class<T> providerInterfaceType) {
        return null;
    }
}

