/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SubordinateXAResource;
import org.wildfly.transaction.client.SynchronizationException;
import org.wildfly.transaction.client._private.Log;

final class XAOutflowedResources {
    private final LocalTransaction transaction;
    private final ConcurrentMap<Key, SubordinateXAResource> enlistments = new ConcurrentHashMap<Key, SubordinateXAResource>();
    private int enlistedSubordinates = 0;

    XAOutflowedResources(LocalTransaction transaction) {
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubordinateXAResource getOrEnlist(URI location, String parentName) throws SystemException, RollbackException {
        Key key = new Key(location, parentName);
        SubordinateXAResource xaResource = (SubordinateXAResource)this.enlistments.get(key);
        if (xaResource != null) {
            return xaResource;
        }
        XAOutflowedResources xAOutflowedResources = this;
        synchronized (xAOutflowedResources) {
            block9: {
                xaResource = (SubordinateXAResource)this.enlistments.get(key);
                if (xaResource != null) {
                    return xaResource;
                }
                xaResource = new SubordinateXAResource(location, parentName);
                if (!this.transaction.enlistResource(xaResource)) {
                    throw Log.log.couldNotEnlist();
                }
                ++this.enlistedSubordinates;
                final SubordinateXAResource finalXaResource = xaResource;
                int status = this.transaction.getStatus();
                if (status == 0 || status == 1) {
                    try {
                        this.transaction.registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                                try {
                                    if (finalXaResource.commitToEnlistment()) {
                                        finalXaResource.beforeCompletion(finalXaResource.getXid());
                                    }
                                }
                                catch (XAException e) {
                                    throw new SynchronizationException(e);
                                }
                            }

                            public void afterCompletion(int status) {
                            }
                        });
                    }
                    catch (IllegalStateException e) {
                        status = this.transaction.getStatus();
                        if (status != 0 && status != 1) break block9;
                        throw e;
                    }
                }
            }
            this.enlistments.put(key, xaResource);
            return xaResource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getEnlistedSubordinates() {
        XAOutflowedResources xAOutflowedResources = this;
        synchronized (xAOutflowedResources) {
            return this.enlistedSubordinates;
        }
    }

    static final class Key {
        private final URI location;
        private final String parentName;

        Key(URI location, String parentName) {
            this.location = location;
            this.parentName = parentName;
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && this.equals((Key)obj);
        }

        private boolean equals(Key key) {
            return Objects.equals(this.location, key.location) && Objects.equals(this.parentName, key.parentName);
        }

        public int hashCode() {
            return Objects.hashCode(this.location) * 31 + Objects.hashCode(this.parentName);
        }
    }
}

