/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client.provider.jboss;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.internal.jta.transaction.jts.TransactionManagerImple;
import com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.resource.spi.XATerminator;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.tm.ExtendedJBossXATerminator;
import org.jboss.tm.ImportedTransaction;
import org.jboss.tm.TransactionImportResult;
import org.jboss.tm.XAResourceRecoveryRegistry;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.SimpleXid;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client.XAResourceRegistry;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.provider.jboss.FileSystemXAResourceRegistry;
import org.wildfly.transaction.client.provider.jboss.JBossJTALocalTransactionProvider;
import org.wildfly.transaction.client.provider.jboss.JBossJTSLocalTransactionProvider;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public abstract class JBossLocalTransactionProvider
implements LocalTransactionProvider {
    private static final Object ENTRY_KEY = new Object();
    private final int staleTransactionTime;
    private final ExtendedJBossXATerminator ext;
    private final TransactionManager tm;
    private final XAImporterImpl xi = new XAImporterImpl();
    private final ConcurrentSkipListSet<XidKey> timeoutSet = new ConcurrentSkipListSet();
    private final ConcurrentMap<SimpleXid, Entry> known = new ConcurrentHashMap<SimpleXid, Entry>();
    private final FileSystemXAResourceRegistry fileSystemXAResourceRegistry;
    private static final long TIME_START = System.nanoTime();
    private static final int UID_LEN = 28;

    JBossLocalTransactionProvider(ExtendedJBossXATerminator ext, int staleTransactionTime, TransactionManager tm, XAResourceRecoveryRegistry registry, Path xaRecoveryDirRelativeToPath) {
        Assert.checkMinimumParameter((String)"setTransactionTimeout", (int)0, (int)staleTransactionTime);
        this.staleTransactionTime = staleTransactionTime;
        this.ext = (ExtendedJBossXATerminator)Assert.checkNotNullParam((String)"ext", (Object)ext);
        this.tm = (TransactionManager)Assert.checkNotNullParam((String)"tm", (Object)tm);
        try {
            ext.doRecover(null, null);
        }
        catch (Exception e) {
            Log.log.doRecoverFailureOnIntialization(e);
        }
        this.fileSystemXAResourceRegistry = new FileSystemXAResourceRegistry(this, xaRecoveryDirRelativeToPath);
        registry.addXAResourceRecovery(this.fileSystemXAResourceRegistry::getInDoubtXAResources);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    @NotNull
    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    @Override
    @NotNull
    public XAImporter getXAImporter() {
        return this.xi;
    }

    @Override
    @NotNull
    public Transaction createNewTransaction(int timeout) throws SystemException, SecurityException {
        TransactionManager tm = this.tm;
        int oldTimeout = this.getTransactionManagerTimeout();
        tm.setTransactionTimeout(timeout);
        try {
            Transaction suspended = tm.suspend();
            try {
                tm.begin();
                Transaction transaction = tm.suspend();
                SimpleXid gtid = SimpleXid.of(this.getXid(transaction)).withoutBranch();
                this.known.put(gtid, this.getEntryFor(transaction, gtid));
                tm.setTransactionTimeout(oldTimeout);
                return transaction;
            }
            catch (NotSupportedException e) {
                throw Log.log.unexpectedFailure(e);
            }
            catch (Throwable t) {
                if (suspended != null) {
                    try {
                        tm.resume(suspended);
                    }
                    catch (InvalidTransactionException e) {
                        e.addSuppressed(t);
                        throw Log.log.unexpectedFailure(e);
                    }
                }
                throw t;
            }
        }
        catch (Throwable t) {
            try {
                tm.setTransactionTimeout(oldTimeout);
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                throw t2;
            }
            throw t;
        }
    }

    @Override
    public XAResourceRegistry getXAResourceRegistry(LocalTransaction transaction) throws SystemException {
        return this.fileSystemXAResourceRegistry.getXAResourceRegistryFile(transaction);
    }

    abstract int getTransactionManagerTimeout() throws SystemException;

    @Override
    public boolean isImported(@NotNull Transaction transaction) throws IllegalArgumentException {
        return transaction instanceof ImportedTransaction;
    }

    @Override
    public abstract void registerInterposedSynchronization(@NotNull Transaction var1, @NotNull Synchronization var2) throws IllegalArgumentException;

    @Override
    @NotNull
    public abstract Object getKey(@NotNull Transaction var1) throws IllegalArgumentException;

    @Override
    public void dropLocal(@NotNull Transaction transaction) {
        Xid xid = this.getXid(transaction);
        SimpleXid gtid = SimpleXid.of(xid).withoutBranch();
        Entry entry = (Entry)this.known.remove(gtid);
        if (entry != null) {
            this.timeoutSet.remove(entry.getXidKey());
        }
    }

    @Override
    public abstract int getTimeout(@NotNull Transaction var1);

    @Override
    @NotNull
    public abstract Xid getXid(@NotNull Transaction var1);

    @Override
    @NotNull
    public String getNodeName() {
        String nodeIdentifier = arjPropertyManager.getCoreEnvironmentBean().getNodeIdentifier();
        if (nodeIdentifier == null) {
            throw Log.log.noLocalTransactionProviderNodeName();
        }
        return nodeIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getEntryFor(Transaction transaction, SimpleXid gtid) {
        Entry entry;
        block8: {
            XidKey xidKey;
            entry = (Entry)this.getResource(transaction, ENTRY_KEY);
            if (entry != null) {
                return entry;
            }
            Transaction transaction2 = transaction;
            synchronized (transaction2) {
                entry = (Entry)this.getResource(transaction, ENTRY_KEY);
                if (entry != null) {
                    return entry;
                }
                int lifetime = this.getTimeout(transaction) + this.staleTransactionTime;
                long timeTick = this.getTimeTick();
                xidKey = new XidKey(gtid, timeTick + (long)lifetime * 1000000000L);
                entry = new Entry(gtid, transaction, xidKey);
                this.putResource(transaction, ENTRY_KEY, entry);
            }
            this.timeoutSet.add(xidKey);
            if (!this.isStatusInactive(transaction)) {
                try {
                    this.registerInterposedSynchronization(transaction, new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            long timeTick = JBossLocalTransactionProvider.this.getTimeTick();
                            ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                            Iterator iterator = JBossLocalTransactionProvider.this.timeoutSet.headSet(new XidKey(SimpleXid.EMPTY, timeTick)).iterator();
                            while (iterator.hasNext()) {
                                SimpleXid xidToRemove = ((XidKey)iterator.next()).getId();
                                Entry knownEntry = (Entry)known.remove(xidToRemove);
                                if (knownEntry == null) {
                                    Log.log.unknownXidToBeRemovedFromTheKnownTransactionInstances(xidToRemove);
                                } else {
                                    Transaction transaction = knownEntry.getTransaction();
                                    if (transaction instanceof ImportedTransaction) {
                                        try {
                                            JBossLocalTransactionProvider.this.ext.removeImportedTransaction(JBossLocalTransactionProvider.this.getXid(transaction));
                                        }
                                        catch (XAException xae) {
                                            Log.log.cannotRemoveImportedTransaction(xidToRemove, xae);
                                        }
                                    }
                                }
                                iterator.remove();
                            }
                        }
                    });
                }
                catch (IllegalStateException e) {
                    if (this.isStatusInactive(transaction)) break block8;
                    throw e;
                }
            }
        }
        return entry;
    }

    boolean isStatusInactive(Transaction transaction) {
        switch (this.getStatus(transaction)) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    int getStatus(Transaction transaction) {
        try {
            return transaction.getStatus();
        }
        catch (SystemException e) {
            return 5;
        }
    }

    long getTimeTick() {
        return System.nanoTime() - TIME_START;
    }

    @Override
    public String getNameFromXid(@NotNull Xid xid) {
        int formatId = xid.getFormatId();
        if (formatId == 131072 || formatId == 131077 || formatId == 131080) {
            byte[] gtid = xid.getGlobalTransactionId();
            int length = gtid.length;
            if (length <= 28) {
                return null;
            }
            return new String(gtid, 28, length - 28, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public <T> T getProviderInterface(Transaction transaction, Class<T> providerInterfaceType) {
        return providerInterfaceType.isInstance(transaction) ? (T)providerInterfaceType.cast(transaction) : null;
    }

    public static final class Builder {
        private int staleTransactionTime = 600;
        private ExtendedJBossXATerminator extendedJBossXATerminator;
        private XATerminator xaTerminator;
        private TransactionManager transactionManager;
        private TransactionSynchronizationRegistry transactionSynchronizationRegistry;
        private XAResourceRecoveryRegistry xaResourceRecoveryRegistry;
        private Path xaRecoveryLogDirRelativeToPath;

        Builder() {
        }

        public int getStaleTransactionTime() {
            return this.staleTransactionTime;
        }

        public Builder setStaleTransactionTime(int staleTransactionTime) {
            Assert.checkMinimumParameter((String)"staleTransactionTime", (int)1, (int)staleTransactionTime);
            this.staleTransactionTime = staleTransactionTime;
            return this;
        }

        public ExtendedJBossXATerminator getExtendedJBossXATerminator() {
            return this.extendedJBossXATerminator;
        }

        public Builder setExtendedJBossXATerminator(ExtendedJBossXATerminator ext) {
            Assert.checkNotNullParam((String)"ext", (Object)ext);
            this.extendedJBossXATerminator = ext;
            return this;
        }

        @Deprecated
        public XATerminator getXATerminator() {
            return this.xaTerminator;
        }

        @Deprecated
        public Builder setXATerminator(XATerminator xt) {
            Assert.checkNotNullParam((String)"xt", (Object)xt);
            this.xaTerminator = xt;
            return this;
        }

        public TransactionManager getTransactionManager() {
            return this.transactionManager;
        }

        public Builder setTransactionManager(TransactionManager tm) {
            Assert.checkNotNullParam((String)"tm", (Object)tm);
            this.transactionManager = tm;
            return this;
        }

        @Deprecated
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return this.transactionSynchronizationRegistry;
        }

        @Deprecated
        public Builder setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
            Assert.checkNotNullParam((String)"tsr", (Object)tsr);
            this.transactionSynchronizationRegistry = tsr;
            return this;
        }

        public Builder setXAResourceRecoveryRegistry(XAResourceRecoveryRegistry reg) {
            Assert.checkNotNullParam((String)"reg", (Object)reg);
            this.xaResourceRecoveryRegistry = reg;
            return this;
        }

        public Builder setXARecoveryLogDirRelativeToPath(Path path) {
            Assert.checkNotNullParam((String)"path", (Object)path);
            this.xaRecoveryLogDirRelativeToPath = path;
            return this;
        }

        public JBossLocalTransactionProvider build() {
            ExtendedJBossXATerminator extendedJBossXATerminator = this.extendedJBossXATerminator;
            TransactionManager transactionManager = this.transactionManager;
            int staleTransactionTime = this.staleTransactionTime;
            Assert.checkNotNullParam((String)"extendedJBossXATerminator", (Object)extendedJBossXATerminator);
            Assert.checkNotNullParam((String)"transactionManager", (Object)transactionManager);
            Assert.checkMinimumParameter((String)"staleTransactionTime", (int)0, (int)staleTransactionTime);
            Assert.checkNotNullParam((String)"xaResourceRecoveryRegistry", (Object)this.xaResourceRecoveryRegistry);
            if (transactionManager instanceof com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple || transactionManager instanceof TransactionManagerDelegate) {
                return new JBossJTALocalTransactionProvider(staleTransactionTime, extendedJBossXATerminator, transactionManager, this.xaResourceRecoveryRegistry, this.xaRecoveryLogDirRelativeToPath);
            }
            if (transactionManager instanceof TransactionManagerImple || transactionManager instanceof com.arjuna.ats.jbossatx.jts.TransactionManagerDelegate) {
                return new JBossJTSLocalTransactionProvider(staleTransactionTime, extendedJBossXATerminator, transactionManager, this.xaResourceRecoveryRegistry, this.xaRecoveryLogDirRelativeToPath);
            }
            throw Log.log.unknownTransactionManagerType(transactionManager.getClass());
        }
    }

    final class XAImporterImpl
    implements XAImporter {
        XAImporterImpl() {
        }

        public ImportResult<Transaction> findOrImportTransaction(Xid xid, int timeout, boolean doNotImport) throws XAException {
            try {
                Entry appearing;
                Transaction transaction;
                boolean imported;
                SimpleXid simpleXid = SimpleXid.of(xid);
                SimpleXid gtid = simpleXid.withoutBranch();
                ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                Entry entry = (Entry)known.get(gtid);
                if (entry != null) {
                    return new ImportResult<Transaction>(entry.getTransaction(), entry, false);
                }
                if (doNotImport) {
                    imported = false;
                    transaction = JBossLocalTransactionProvider.this.ext.getTransaction(xid);
                    if (transaction == null) {
                        return null;
                    }
                } else {
                    TransactionImportResult result = JBossLocalTransactionProvider.this.ext.importTransaction(xid, timeout);
                    transaction = result.getTransaction();
                    imported = result.isNewImportedTransaction();
                }
                if ((appearing = known.putIfAbsent(gtid, entry = JBossLocalTransactionProvider.this.getEntryFor(transaction, gtid))) != null) {
                    return new ImportResult<Transaction>(transaction, appearing, imported);
                }
                return new ImportResult<Transaction>(transaction, entry, imported);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public Transaction findExistingTransaction(Xid xid) throws XAException {
            try {
                SimpleXid simpleXid = SimpleXid.of(xid);
                SimpleXid gtid = simpleXid.withoutBranch();
                ConcurrentMap known = JBossLocalTransactionProvider.this.known;
                Entry entry = (Entry)known.get(gtid);
                if (entry != null) {
                    return entry.getTransaction();
                }
                Transaction transaction = JBossLocalTransactionProvider.this.ext.getTransaction(xid);
                if (transaction == null) {
                    return null;
                }
                return known.computeIfAbsent(gtid, g -> JBossLocalTransactionProvider.this.getEntryFor(transaction, (SimpleXid)g)).getTransaction();
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public void commit(Xid xid, boolean onePhase) throws XAException {
            try {
                Entry entry = (Entry)JBossLocalTransactionProvider.this.known.get(SimpleXid.of(xid).withoutBranch());
                if (entry == null) {
                    throw new XAException(-4);
                }
                entry.commit(onePhase);
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        public void forget(Xid xid) throws XAException {
            try {
                Entry entry = (Entry)JBossLocalTransactionProvider.this.known.get(SimpleXid.of(xid).withoutBranch());
                if (entry == null) {
                    throw new XAException(-4);
                }
                entry.forget();
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }

        @Override
        @NotNull
        public Xid[] recover(int flag, String parentNodeName) throws XAException {
            try {
                try {
                    Xid[] xids = JBossLocalTransactionProvider.this.ext.doRecover(null, parentNodeName);
                    return xids == null ? SimpleXid.NO_XIDS : xids;
                }
                catch (NotSupportedException e) {
                    throw new XAException(-7);
                }
            }
            catch (XAException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Log.log.resourceManagerErrorXa(-7, t);
            }
        }
    }

    final class Entry
    implements SubordinateTransactionControl {
        private final SimpleXid gtid;
        private final Transaction transaction;
        private final XidKey xidKey;

        Entry(SimpleXid gtid, Transaction transaction, XidKey xidKey) {
            this.gtid = gtid;
            this.transaction = transaction;
            this.xidKey = xidKey;
        }

        XidKey getXidKey() {
            return this.xidKey;
        }

        Transaction getTransaction() {
            return this.transaction;
        }

        void rollbackLocal() throws SystemException {
            if (this.transaction instanceof ImportedTransaction) {
                throw Log.log.rollbackOnImported();
            }
            this.transaction.rollback();
        }

        void commitLocal() throws HeuristicRollbackException, RollbackException, HeuristicMixedException, SystemException {
            if (this.transaction instanceof ImportedTransaction) {
                throw Log.log.commitOnImported();
            }
            this.transaction.commit();
        }

        @Override
        public void rollback() throws XAException {
            Transaction transaction = this.transaction;
            try {
                int status = transaction.getStatus();
                if (status == 9 || status == 4) {
                    return;
                }
            }
            catch (SystemException status) {
                // empty catch block
            }
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return;
            }
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            if (importedTransaction.activated()) {
                try {
                    importedTransaction.doRollback();
                }
                catch (HeuristicCommitException e) {
                    throw Log.log.heuristicCommitXa(7, e);
                }
                catch (HeuristicMixedException e) {
                    throw Log.log.heuristicMixedXa(5, e);
                }
                catch (HeuristicRollbackException e) {
                    throw Log.log.heuristicRollbackXa(6, e);
                }
                catch (IllegalStateException e) {
                    throw Log.log.illegalStateXa(-4, e);
                }
                catch (Throwable e) {
                    throw Log.log.resourceManagerErrorXa(-3, e);
                }
                finally {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                }
            }
        }

        @Override
        public void end(int flags) throws XAException {
            if (flags != 0x20000000) {
                return;
            }
            Transaction transaction = this.transaction;
            try {
                int status = transaction.getStatus();
                if (status == 1 || status == 9 || status == 4) {
                    return;
                }
            }
            catch (SystemException status) {
                // empty catch block
            }
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return;
            }
            try {
                transaction.setRollbackOnly();
            }
            catch (IllegalStateException e) {
                throw Log.log.illegalStateXa(-4, e);
            }
            catch (Throwable e) {
                throw Log.log.resourceManagerErrorXa(-3, e);
            }
        }

        @Override
        public void beforeCompletion() throws XAException {
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return;
            }
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                if (!importedTransaction.doBeforeCompletion()) {
                    throw new XAException(-3);
                }
            }
            catch (IllegalStateException e) {
                throw Log.log.illegalStateXa(-4, e);
            }
            catch (Throwable e) {
                throw Log.log.resourceManagerErrorXa(-3, e);
            }
        }

        @Override
        public int prepare() throws XAException {
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return 0;
            }
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            int tpo = importedTransaction.doPrepare();
            switch (tpo) {
                case 2: {
                    JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                    return 3;
                }
                case 0: {
                    return 0;
                }
                case 1: {
                    try {
                        importedTransaction.doRollback();
                    }
                    catch (HeuristicCommitException | HeuristicMixedException | HeuristicRollbackException | SystemException e) {
                        JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                        throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, e), importedTransaction);
                    }
                    catch (Throwable t) {
                        JBossLocalTransactionProvider.this.ext.removeImportedTransaction((Xid)this.gtid);
                        throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, t), importedTransaction);
                    }
                    throw this.initializeSuppressed(new XAException(100), importedTransaction);
                }
                case 11: {
                    throw new XAException(-4);
                }
            }
            throw new XAException(104);
        }

        @Override
        public void forget() throws XAException {
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return;
            }
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                importedTransaction.doForget();
            }
            catch (IllegalStateException e) {
                throw Log.log.illegalStateXa(-4, e);
            }
            catch (Throwable e) {
                throw Log.log.resourceManagerErrorXa(-3, e);
            }
        }

        @Override
        public void commit(boolean onePhase) throws XAException {
            Transaction transaction = this.transaction;
            if (!(transaction instanceof ImportedTransaction)) {
                Log.log.notImportedXa();
                return;
            }
            ImportedTransaction importedTransaction = (ImportedTransaction)transaction;
            try {
                if (onePhase) {
                    importedTransaction.doOnePhaseCommit();
                } else if (!importedTransaction.doCommit()) {
                    JBossLocalTransactionProvider.this.dropLocal((Transaction)importedTransaction);
                    JBossLocalTransactionProvider.this.ext.doRecover(null, null);
                    throw new XAException(4);
                }
            }
            catch (XAException e) {
                throw this.initializeSuppressed(e, importedTransaction);
            }
            catch (HeuristicMixedException e) {
                throw this.initializeSuppressed(Log.log.heuristicMixedXa(5, e), importedTransaction);
            }
            catch (RollbackException e) {
                throw this.initializeSuppressed(Log.log.rollbackXa(100, e), importedTransaction);
            }
            catch (HeuristicCommitException e) {
                throw this.initializeSuppressed(Log.log.heuristicCommitXa(7, e), importedTransaction);
            }
            catch (HeuristicRollbackException e) {
                throw this.initializeSuppressed(Log.log.heuristicRollbackXa(6, e), importedTransaction);
            }
            catch (IllegalStateException e) {
                throw this.initializeSuppressed(Log.log.illegalStateXa(-4, e), importedTransaction);
            }
            catch (Throwable e) {
                throw this.initializeSuppressed(Log.log.resourceManagerErrorXa(-3, e), importedTransaction);
            }
        }

        private XAException initializeSuppressed(XAException ex, ImportedTransaction transaction) {
            if (ex != null && transaction.supportsDeferredThrowables()) {
                for (Throwable suppressedThrowable : transaction.getDeferredThrowables()) {
                    ex.addSuppressed(suppressedThrowable);
                }
            }
            return ex;
        }
    }

    static final class XidKey
    implements Comparable<XidKey> {
        private final SimpleXid gtid;
        private final long expiration;

        XidKey(SimpleXid gtid, long expiration) {
            this.gtid = gtid;
            this.expiration = expiration;
        }

        @Override
        public int compareTo(XidKey o) {
            int res = Long.signum(this.expiration - o.expiration);
            return res == 0 ? this.gtid.compareTo(o.gtid) : res;
        }

        SimpleXid getId() {
            return this.gtid;
        }
    }
}

