package org.wildfly.transaction.client._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.util.ServiceConfigurationError;
import javax.transaction.InvalidTransactionException;
import java.lang.String;
import java.net.URISyntaxException;
import org.jboss.logging.Logger;
import javax.transaction.RollbackException;
import java.net.URI;
import org.wildfly.transaction.client.DelayedEnlistmentException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.SystemException;
import org.jboss.remoting3.Endpoint;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.security.Permission;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import java.nio.file.Path;
import javax.annotation.Generated;
import javax.transaction.xa.XAException;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.Exception;
import javax.transaction.xa.Xid;
import javax.transaction.xa.XAResource;
import javax.transaction.Transaction;
import javax.transaction.HeuristicMixedException;
import java.lang.Throwable;
import java.util.Arrays;
import javax.transaction.NotSupportedException;
import javax.transaction.HeuristicCommitException;
import java.io.File;
import org.wildfly.transaction.client.SynchronizationException;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-07-10T16:00:12-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String subordinateXaResource = "Subordinate XAResource at %s";
    protected String subordinateXaResource$str() {
        return subordinateXaResource;
    }
    @Override
    public final String subordinateXaResource(final URI location) {
        return String.format(getLoggingLocale(), subordinateXaResource$str(), location);
    }
    @Override
    public final void serviceConfigurationFailed(final ServiceConfigurationError e) {
        super.log.logf(FQCN, DEBUG, e, serviceConfigurationFailed$str());
    }
    private static final String serviceConfigurationFailed = "Failed to configure a remote transaction service provider";
    protected String serviceConfigurationFailed$str() {
        return serviceConfigurationFailed;
    }
    @Override
    public final void recoverySuppressedException(final XAException e) {
        super.log.logf(FQCN, DEBUG, e, recoverySuppressedException$str());
    }
    private static final String recoverySuppressedException = "Closing the recovery stream after recovery failed threw an exception";
    protected String recoverySuppressedException$str() {
        return recoverySuppressedException;
    }
    @Override
    public final void inboundException(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, inboundException$str());
    }
    private static final String inboundException = "Got exception on inbound message";
    protected String inboundException$str() {
        return inboundException;
    }
    @Override
    public final void outboundException(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, outboundException$str());
    }
    private static final String outboundException = "Got exception on outbound message";
    protected String outboundException$str() {
        return outboundException;
    }
    @Override
    public final void doRecoverFailureOnIntialization(final Throwable e) {
        super.log.logf(FQCN, TRACE, e, doRecoverFailureOnIntialization$str());
    }
    private static final String doRecoverFailureOnIntialization = "Failure on running doRecover during initialization";
    protected String doRecoverFailureOnIntialization$str() {
        return doRecoverFailureOnIntialization;
    }
    @Override
    public final void xaResourceRecoveryFileCreated(final Path path) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryFileCreated$str(), path);
    }
    private static final String xaResourceRecoveryFileCreated = "Created xa resource recovery file: %s";
    protected String xaResourceRecoveryFileCreated$str() {
        return xaResourceRecoveryFileCreated;
    }
    @Override
    public final void xaResourceRecoveryFileDeleted(final Path path) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryFileDeleted$str(), path);
    }
    private static final String xaResourceRecoveryFileDeleted = "Deleted xa resource recovery file: %s";
    protected String xaResourceRecoveryFileDeleted$str() {
        return xaResourceRecoveryFileDeleted;
    }
    @Override
    public final void xaResourceRecoveryRegistryReloaded(final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveryRegistryReloaded$str(), filePath);
    }
    private static final String xaResourceRecoveryRegistryReloaded = "Reloaded xa resource recovery registry file: %s";
    protected String xaResourceRecoveryRegistryReloaded$str() {
        return xaResourceRecoveryRegistryReloaded;
    }
    @Override
    public final void xaResourceAddedToRecoveryRegistry(final URI uri, final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceAddedToRecoveryRegistry$str(), uri, filePath);
    }
    private static final String xaResourceAddedToRecoveryRegistry = "Added resource (%s) to xa resource recovery registry %s";
    protected String xaResourceAddedToRecoveryRegistry$str() {
        return xaResourceAddedToRecoveryRegistry;
    }
    @Override
    public final void xaResourceRecoveredFromRecoveryRegistry(final URI uri, final Path filePath) {
        super.log.logf(FQCN, TRACE, null, xaResourceRecoveredFromRecoveryRegistry$str(), uri, filePath);
    }
    private static final String xaResourceRecoveredFromRecoveryRegistry = "Recovered in doubt xa resource (%s) from xa resource recovery registry %s";
    protected String xaResourceRecoveredFromRecoveryRegistry$str() {
        return xaResourceRecoveredFromRecoveryRegistry;
    }
    @Override
    public final void unknownXidToBeRemovedFromTheKnownTransactionInstances(final Xid xid) {
        super.log.logf(FQCN, TRACE, null, unknownXidToBeRemovedFromTheKnownTransactionInstances$str(), xid);
    }
    private static final String unknownXidToBeRemovedFromTheKnownTransactionInstances = "Unknown xid %s to be removed from the instances known to the wfly txn client";
    protected String unknownXidToBeRemovedFromTheKnownTransactionInstances$str() {
        return unknownXidToBeRemovedFromTheKnownTransactionInstances;
    }
    private static final String noTransaction = "No transaction associated with the current thread";
    protected String noTransaction$str() {
        return noTransaction;
    }
    @Override
    public final IllegalStateException noTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nestedNotSupported = "WFTXN0001: A transaction is already in progress";
    protected String nestedNotSupported$str() {
        return nestedNotSupported;
    }
    @Override
    public final NotSupportedException nestedNotSupported() {
        final NotSupportedException result = new NotSupportedException(String.format(getLoggingLocale(), nestedNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notSupportedTransaction = "WFTXN0002: Transaction is not a supported instance: %s";
    protected String notSupportedTransaction$str() {
        return notSupportedTransaction;
    }
    @Override
    public final InvalidTransactionException notSupportedTransaction(final Transaction transaction) {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), notSupportedTransaction$str(), transaction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionLocationUri = "WFTXN0003: Invalid transaction location URI (must be absolute): %s";
    protected String invalidTransactionLocationUri$str() {
        return invalidTransactionLocationUri;
    }
    @Override
    public final IllegalArgumentException invalidTransactionLocationUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidTransactionLocationUri$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noProviderForUri = "WFTXN0004: No transaction provider installed for URI: %s";
    protected String noProviderForUri$str() {
        return noProviderForUri;
    }
    @Override
    public final IllegalArgumentException noProviderForUri(final URI uri) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noProviderForUri$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionNotAssociatedWithThisProvider = "WFTXN0005: Transaction not associated with this provider";
    protected String transactionNotAssociatedWithThisProvider$str() {
        return transactionNotAssociatedWithThisProvider;
    }
    @Override
    public final InvalidTransactionException transactionNotAssociatedWithThisProvider() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), transactionNotAssociatedWithThisProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String negativeTxnTimeout = "WFTXN0006: Negative transaction timeout provided";
    protected String negativeTxnTimeout$str() {
        return negativeTxnTimeout;
    }
    @Override
    public final SystemException negativeTxnTimeout() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), negativeTxnTimeout$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyAssociated = "WFTXN0007: A transaction is already associated with the current thread";
    protected String alreadyAssociated$str() {
        return alreadyAssociated;
    }
    @Override
    public final IllegalStateException alreadyAssociated() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyAssociated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String registerSynchRemoteTransaction = "WFTXN0008: Cannot register a synchronization on a remote transaction";
    protected String registerSynchRemoteTransaction$str() {
        return registerSynchRemoteTransaction;
    }
    @Override
    public final UnsupportedOperationException registerSynchRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), registerSynchRemoteTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String enlistDelistRemoteTransaction = "WFTXN0009: Cannot enlist or delist resources on a remote transaction";
    protected String enlistDelistRemoteTransaction$str() {
        return enlistDelistRemoteTransaction;
    }
    @Override
    public final UnsupportedOperationException enlistDelistRemoteTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), enlistDelistRemoteTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReceive = "WFTXN0010: Failed to receive protocol message from remote peer";
    protected String failedToReceive$str() {
        return failedToReceive;
    }
    @Override
    public final SystemException failedToReceive(final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToReceive$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToSend = "WFTXN0011: Failed to send protocol message to remote peer";
    protected String failedToSend$str() {
        return failedToSend;
    }
    @Override
    public final SystemException failedToSend(final Exception e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToSend$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerSystemException = "WFTXN0012: The peer threw a SystemException; see peer logs for more information";
    protected String peerSystemException$str() {
        return peerSystemException;
    }
    @Override
    public final SystemException peerSystemException() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), peerSystemException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerSecurityException = "WFTXN0013: The peer threw a SecurityException; see peer logs for more information";
    protected String peerSecurityException$str() {
        return peerSecurityException;
    }
    @Override
    public final SecurityException peerSecurityException() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), peerSecurityException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String protocolError = "WFTXN0014: An unexpected protocol error occurred";
    protected String protocolError$str() {
        return protocolError;
    }
    @Override
    public final SystemException protocolError() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), protocolError$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationInterrupted = "WFTXN0015: The protocol operation was interrupted locally";
    protected String operationInterrupted$str() {
        return operationInterrupted;
    }
    @Override
    public final SystemException operationInterrupted() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), operationInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionRolledBackByPeer = "WFTXN0016: The remote peer rolled back the transaction";
    protected String transactionRolledBackByPeer$str() {
        return transactionRolledBackByPeer;
    }
    @Override
    public final RollbackException transactionRolledBackByPeer() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), transactionRolledBackByPeer$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnlyRollback = "WFTXN0017: Rollback-only transaction rolled back";
    protected String rollbackOnlyRollback$str() {
        return rollbackOnlyRollback;
    }
    @Override
    public final RollbackException rollbackOnlyRollback() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), rollbackOnlyRollback$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTxnState = "WFTXN0018: Invalid transaction state";
    protected String invalidTxnState$str() {
        return invalidTxnState;
    }
    @Override
    public final IllegalStateException invalidTxnState() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidTxnState$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerHeuristicMixedException = "WFTXN0019: The peer threw a HeuristicMixedException; see peer logs for more information";
    protected String peerHeuristicMixedException$str() {
        return peerHeuristicMixedException;
    }
    @Override
    public final HeuristicMixedException peerHeuristicMixedException() {
        final HeuristicMixedException result = new HeuristicMixedException(String.format(getLoggingLocale(), peerHeuristicMixedException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerHeuristicRollbackException = "WFTXN0020: The peer threw a HeuristicRollbackException; see peer logs for more information";
    protected String peerHeuristicRollbackException$str() {
        return peerHeuristicRollbackException;
    }
    @Override
    public final HeuristicRollbackException peerHeuristicRollbackException() {
        final HeuristicRollbackException result = new HeuristicRollbackException(String.format(getLoggingLocale(), peerHeuristicRollbackException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAcquireConnection = "WFTXN0021: Failed to acquire a connection for this operation";
    protected String failedToAcquireConnection$str() {
        return failedToAcquireConnection;
    }
    @Override
    public final SystemException failedToAcquireConnection(final IOException reason) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), failedToAcquireConnection$str()));
        result.initCause(reason);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateEnlistment = "WFTXN0022: The resource manager for remote connection to %s was already enlisted in a transaction";
    protected String duplicateEnlistment$str() {
        return duplicateEnlistment;
    }
    @Override
    public final XAException duplicateEnlistment(final int errorCode, final URI uri) {
        final XAException result = new XAException(String.format(getLoggingLocale(), duplicateEnlistment$str(), uri));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidFlags = "WFTXN0023: Invalid flag value";
    protected String invalidFlags$str() {
        return invalidFlags;
    }
    @Override
    public final IllegalArgumentException invalidFlags() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidFlags$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateTransaction = "WFTXN0024: Duplicate transaction encountered for destination %s, transaction ID %s";
    protected String duplicateTransaction$str() {
        return duplicateTransaction;
    }
    @Override
    public final XAException duplicateTransaction(final int errorCode, final URI uri, final Xid xid) {
        final XAException result = new XAException(String.format(getLoggingLocale(), duplicateTransaction$str(), uri, xid));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String failedToReceiveXA = "WFTXN0025: Failed to receive protocol message from remote peer";
    protected String failedToReceiveXA$str() {
        return failedToReceiveXA;
    }
    @Override
    public final XAException failedToReceiveXA(final IOException e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToReceiveXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String failedToSendXA = "WFTXN0026: Failed to send protocol message to remote peer";
    protected String failedToSendXA$str() {
        return failedToSendXA;
    }
    @Override
    public final XAException failedToSendXA(final Exception e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToSendXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String operationInterruptedXA = "WFTXN0027: The protocol operation was interrupted locally";
    protected String operationInterruptedXA$str() {
        return operationInterruptedXA;
    }
    @Override
    public final XAException operationInterruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), operationInterruptedXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String protocolErrorXA = "WFTXN0028: An unexpected protocol error occurred";
    protected String protocolErrorXA$str() {
        return protocolErrorXA;
    }
    @Override
    public final XAException protocolErrorXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), protocolErrorXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String peerXaException = "WFTXN0029: The peer threw an XA exception";
    protected String peerXaException$str() {
        return peerXaException;
    }
    @Override
    public final XAException peerXaException(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), peerXaException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidHandleType = "WFTXN0030: Invalid handle type; expected %s, actually received %s";
    protected String invalidHandleType$str() {
        return invalidHandleType;
    }
    @Override
    public final IllegalArgumentException invalidHandleType(final Class<?> expected, final Class<?> actual) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHandleType$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String commitOnImported = "WFTXN0031: Commit not allowed on imported transaction";
    protected String commitOnImported$str() {
        return commitOnImported;
    }
    @Override
    public final SystemException commitOnImported() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), commitOnImported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnImported = "WFTXN0032: Rollback not allowed on imported transaction";
    protected String rollbackOnImported$str() {
        return rollbackOnImported;
    }
    @Override
    public final SystemException rollbackOnImported() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), rollbackOnImported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleProvidersRegistered = "WFTXN0033: Multiple remote transaction providers registered on endpoint: %s";
    protected String multipleProvidersRegistered$str() {
        return multipleProvidersRegistered;
    }
    @Override
    public final IllegalStateException multipleProvidersRegistered(final Endpoint e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleProvidersRegistered$str(), e));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToAcquireConnectionXA = "WFTXN0034: Failed to acquire a connection for this operation";
    protected String failedToAcquireConnectionXA$str() {
        return failedToAcquireConnectionXA;
    }
    @Override
    public final XAException failedToAcquireConnectionXA(final IOException e, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), failedToAcquireConnectionXA$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidHandleTypeRequested = "WFTXN0035: Invalid handle type requested; expected a subtype of Transaction (non-inclusive), got %s";
    protected String invalidHandleTypeRequested$str() {
        return invalidHandleTypeRequested;
    }
    @Override
    public final IllegalArgumentException invalidHandleTypeRequested(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHandleTypeRequested$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interruptedXA = "WFTXN0036: Transaction operation failed due to thread interruption";
    protected String interruptedXA$str() {
        return interruptedXA;
    }
    @Override
    public final XAException interruptedXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), interruptedXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String noTransactionProvider = "WFTXN0037: No transaction provider associated with the current thread";
    protected String noTransactionProvider$str() {
        return noTransactionProvider;
    }
    @Override
    public final IllegalStateException noTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noTransactionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noLocalTransactionProvider = "WFTXN0038: No local transaction provider associated with the current thread";
    protected String noLocalTransactionProvider$str() {
        return noLocalTransactionProvider;
    }
    @Override
    public final IllegalStateException noLocalTransactionProvider() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noLocalTransactionProvider$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullTransaction = "WFTXN0039: Invalid null transaction";
    protected String nullTransaction$str() {
        return nullTransaction;
    }
    @Override
    public final NullPointerException nullTransaction() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void rollbackFailed(final Throwable e) {
        super.log.logf(FQCN, DEBUG, e, rollbackFailed$str());
    }
    private static final String rollbackFailed = "WFTXN0040: Rollback failed unexpectedly";
    protected String rollbackFailed$str() {
        return rollbackFailed;
    }
    private static final String noProviderInterface = "WFTXN0041: No provider interface matching %s is available from the transaction provider";
    protected String noProviderInterface$str() {
        return noProviderInterface;
    }
    @Override
    public final IllegalStateException noProviderInterface(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noProviderInterface$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionFailed = "WFTXN0042: Connection to remote transaction service failed";
    protected String connectionFailed$str() {
        return connectionFailed;
    }
    @Override
    public final SystemException connectionFailed(final Throwable cause) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), connectionFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String connectionInterrupted = "WFTXN0043: Connection to remote transaction service interrupted";
    protected String connectionInterrupted$str() {
        return connectionInterrupted;
    }
    @Override
    public final SystemException connectionInterrupted() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), connectionInterrupted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownResponse = "WFTXN0044: Unknown response received from peer";
    protected String unknownResponse$str() {
        return unknownResponse;
    }
    @Override
    public final SystemException unknownResponse() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), unknownResponse$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String responseFailed = "WFTXN0045: Failed to receive a response from peer";
    protected String responseFailed$str() {
        return responseFailed;
    }
    @Override
    public final SystemException responseFailed(final IOException cause) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), responseFailed$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String peerIllegalStateException = "WFTXN0046: The peer threw an IllegalStateException; see peer logs for more information";
    protected String peerIllegalStateException$str() {
        return peerIllegalStateException;
    }
    @Override
    public final IllegalStateException peerIllegalStateException() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), peerIllegalStateException$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownResponseXa = "WFTXN0047: Unknown XA response received from peer";
    protected String unknownResponseXa$str() {
        return unknownResponseXa;
    }
    @Override
    public final XAException unknownResponseXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), unknownResponseXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String responseFailedXa = "WFTXN0048: Failed to receive an XA response from peer";
    protected String responseFailedXa$str() {
        return responseFailedXa;
    }
    @Override
    public final XAException responseFailedXa(final IOException cause, final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), responseFailedXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String negativeTxnTimeoutXa = "WFTXN0049: Negative transaction timeout provided";
    protected String negativeTxnTimeoutXa$str() {
        return negativeTxnTimeoutXa;
    }
    @Override
    public final XAException negativeTxnTimeoutXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), negativeTxnTimeoutXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unrecognizedParameter = "WFTXN0050: Unrecognized parameter with ID 0x%02x received";
    protected String unrecognizedParameter$str() {
        return unrecognizedParameter;
    }
    @Override
    public final XAException unrecognizedParameter(final int errorCode, final int id) {
        final XAException result = new XAException(String.format(getLoggingLocale(), unrecognizedParameter$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String expectedParameter = "WFTXN0051: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    protected String expectedParameter$str() {
        return expectedParameter;
    }
    @Override
    public final SystemException expectedParameter(final int expected, final int actual) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), expectedParameter$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedParameterXa = "WFTXN0052: Expected parameter with ID 0x%02x, got parameter with ID 0x%02x instead";
    protected String expectedParameterXa$str() {
        return expectedParameterXa;
    }
    @Override
    public final XAException expectedParameterXa(final int errorCode, final int expected, final int actual) {
        final XAException result = new XAException(String.format(getLoggingLocale(), expectedParameterXa$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String delayedEnlistmentFailed = "WFTXN0053: Delayed enlistment has failed";
    protected String delayedEnlistmentFailed$str() {
        return delayedEnlistmentFailed;
    }
    @Override
    public final DelayedEnlistmentException delayedEnlistmentFailed(final Throwable cause) {
        final DelayedEnlistmentException result = new DelayedEnlistmentException(String.format(getLoggingLocale(), delayedEnlistmentFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beforeCompletionFailed = "WFTXN0054: Before-completion failed for resource %s";
    protected String beforeCompletionFailed$str() {
        return beforeCompletionFailed;
    }
    @Override
    public final SynchronizationException beforeCompletionFailed(final Throwable cause, final XAResource resource) {
        final SynchronizationException result = new SynchronizationException(String.format(getLoggingLocale(), beforeCompletionFailed$str(), resource), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onePhaseUserTransaction = "WFTXN0055: Two-phase operation on single-phase transaction";
    protected String onePhaseUserTransaction$str() {
        return onePhaseUserTransaction;
    }
    @Override
    public final XAException onePhaseUserTransaction(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), onePhaseUserTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unknownProvider = "WFTXN0056: Unknown provider for remote transactions with URI scheme \"%s\"";
    protected String unknownProvider$str() {
        return unknownProvider;
    }
    @Override
    public final IllegalArgumentException unknownProvider(final String scheme) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownProvider$str(), scheme));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String outflowAcrossTransactionManagers = "WFTXN0057: Attempted to outflow the same transaction from two different transaction managers";
    protected String outflowAcrossTransactionManagers$str() {
        return outflowAcrossTransactionManagers;
    }
    @Override
    public final SystemException outflowAcrossTransactionManagers() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), outflowAcrossTransactionManagers$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyEnlisted = "WFTXN0058: This delayed enlistment handle was already enlisted";
    protected String alreadyEnlisted$str() {
        return alreadyEnlisted;
    }
    @Override
    public final IllegalStateException alreadyEnlisted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyEnlisted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyForgotten = "WFTXN0059: This delayed enlistment handle was already forgotten";
    protected String alreadyForgotten$str() {
        return alreadyForgotten;
    }
    @Override
    public final IllegalStateException alreadyForgotten() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyForgotten$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionTimedOut = "WFTXN0060: Transaction timed out";
    protected String transactionTimedOut$str() {
        return transactionTimedOut;
    }
    @Override
    public final XAException transactionTimedOut(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), transactionTimedOut$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String markedRollbackOnly = "WFTXN0061: Transaction is marked rollback-only";
    protected String markedRollbackOnly$str() {
        return markedRollbackOnly;
    }
    @Override
    public final RollbackException markedRollbackOnly() {
        final RollbackException result = new RollbackException(String.format(getLoggingLocale(), markedRollbackOnly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notActive = "WFTXN0062: Transaction is not active";
    protected String notActive$str() {
        return notActive;
    }
    @Override
    public final IllegalStateException notActive() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notActive$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String providerCreatedNullTransaction = "WFTXN0063: Provider created a null transaction";
    protected String providerCreatedNullTransaction$str() {
        return providerCreatedNullTransaction;
    }
    @Override
    public final IllegalStateException providerCreatedNullTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), providerCreatedNullTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnectionEndpoint = "WFTXN0064: Invalid connection endpoint provided";
    protected String invalidConnectionEndpoint$str() {
        return invalidConnectionEndpoint;
    }
    @Override
    public final IllegalArgumentException invalidConnectionEndpoint() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidConnectionEndpoint$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransactionForId = "WFTXN0065: No transaction for ID %d";
    protected String noTransactionForId$str() {
        return noTransactionForId;
    }
    @Override
    public final SystemException noTransactionForId(final int id) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), noTransactionForId$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rollbackOnlyFailed = "WFTXN0066: Failed to set transaction as rollback-only";
    protected String rollbackOnlyFailed$str() {
        return rollbackOnlyFailed;
    }
    @Override
    public final XAException rollbackOnlyFailed(final int errorCode, final SystemException e) {
        final XAException result = new XAException(String.format(getLoggingLocale(), rollbackOnlyFailed$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String notActiveXA = "WFTXN0067: Transaction is not active";
    protected String notActiveXA$str() {
        return notActiveXA;
    }
    @Override
    public final XAException notActiveXA(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), notActiveXA$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String couldNotEnlist = "WFTXN0068: Subordinate enlistment failed for unknown reason";
    protected String couldNotEnlist$str() {
        return couldNotEnlist;
    }
    @Override
    public final SystemException couldNotEnlist() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), couldNotEnlist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTransactionConnection = "WFTXN0069: Connection does not match the transaction; the connection may have closed";
    protected String invalidTransactionConnection$str() {
        return invalidTransactionConnection;
    }
    @Override
    public final InvalidTransactionException invalidTransactionConnection() {
        final InvalidTransactionException result = new InvalidTransactionException(String.format(getLoggingLocale(), invalidTransactionConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noTransactionXa = "WFTXN0070: No such transaction";
    protected String noTransactionXa$str() {
        return noTransactionXa;
    }
    @Override
    public final XAException noTransactionXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), noTransactionXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String unexpectedFailure = "WFTXN0071: An unexpected failure condition occurred";
    protected String unexpectedFailure$str() {
        return unexpectedFailure;
    }
    @Override
    public final IllegalStateException unexpectedFailure(final Throwable e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedFailure$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noLocalTransactionProviderNodeName = "WFTXN0072: No local transaction provider node name specified in the transaction manager environment";
    protected String noLocalTransactionProviderNodeName$str() {
        return noLocalTransactionProviderNodeName;
    }
    @Override
    public final IllegalStateException noLocalTransactionProviderNodeName() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noLocalTransactionProviderNodeName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedProviderTransactionMismatch = "WFTXN0073: Unexpected provider transaction mismatch; expected %s, got %s";
    protected String unexpectedProviderTransactionMismatch$str() {
        return unexpectedProviderTransactionMismatch;
    }
    @Override
    public final IllegalStateException unexpectedProviderTransactionMismatch(final Transaction expected, final Transaction actual) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedProviderTransactionMismatch$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String heuristicMixedXa = "WFTXN0074: Heuristic-mixed outcome";
    protected String heuristicMixedXa$str() {
        return heuristicMixedXa;
    }
    @Override
    public final XAException heuristicMixedXa(final int errorCode, final HeuristicMixedException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicMixedXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String heuristicCommitXa = "WFTXN0075: Heuristic-commit outcome";
    protected String heuristicCommitXa$str() {
        return heuristicCommitXa;
    }
    @Override
    public final XAException heuristicCommitXa(final int errorCode, final HeuristicCommitException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicCommitXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String rollbackXa = "WFTXN0076: Transaction rolled back";
    protected String rollbackXa$str() {
        return rollbackXa;
    }
    @Override
    public final XAException rollbackXa(final int errorCode, final RollbackException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), rollbackXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String heuristicRollbackXa = "WFTXN0077: Heuristic-rollback outcome";
    protected String heuristicRollbackXa$str() {
        return heuristicRollbackXa;
    }
    @Override
    public final XAException heuristicRollbackXa(final int errorCode, final HeuristicRollbackException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), heuristicRollbackXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String illegalStateXa = "WFTXN0078: Invalid transaction state";
    protected String illegalStateXa$str() {
        return illegalStateXa;
    }
    @Override
    public final XAException illegalStateXa(final int errorCode, final IllegalStateException cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), illegalStateXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String resourceManagerErrorXa = "WFTXN0079: An unexpected resource manager error occurred";
    protected String resourceManagerErrorXa$str() {
        return resourceManagerErrorXa;
    }
    @Override
    public final XAException resourceManagerErrorXa(final int errorCode, final Throwable cause) {
        final XAException result = new XAException(String.format(getLoggingLocale(), resourceManagerErrorXa$str()));
        result.initCause(cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String notImportedXa = "WFTXN0080: Operation not allowed on non-imported transaction";
    protected String notImportedXa$str() {
        return notImportedXa;
    }
    @Override
    public final XAException notImportedXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), notImportedXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String invalidTxStateXa = "WFTXN0081: Invalid transaction state for operation";
    protected String invalidTxStateXa$str() {
        return invalidTxStateXa;
    }
    @Override
    public final XAException invalidTxStateXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), invalidTxStateXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String suspendedCannotCreateNew = "WFTXN0082: Cannot import a new transaction on a suspended server";
    protected String suspendedCannotCreateNew$str() {
        return suspendedCannotCreateNew;
    }
    @Override
    public final SystemException suspendedCannotCreateNew() {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), suspendedCannotCreateNew$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String suspendedCannotImportXa = "WFTXN0083: Cannot import a new transaction on a suspended server";
    protected String suspendedCannotImportXa$str() {
        return suspendedCannotImportXa;
    }
    @Override
    public final XAException suspendedCannotImportXa(final int errorCode) {
        final XAException result = new XAException(String.format(getLoggingLocale(), suspendedCannotImportXa$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String forbiddenContextForUserTransaction = "WFTXN0084: UserTransaction access is forbidden in the current context";
    protected String forbiddenContextForUserTransaction$str() {
        return forbiddenContextForUserTransaction;
    }
    @Override
    public final IllegalStateException forbiddenContextForUserTransaction() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), forbiddenContextForUserTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedException = "WFTXN0085: Operation failed with an unexpected exception type";
    protected String unexpectedException$str() {
        return unexpectedException;
    }
    @Override
    public final SystemException unexpectedException(final Exception e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), unexpectedException$str()));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownTransactionType = "WFTXN0086: Unexpected transaction type encountered; expected %s but encountered %s";
    protected String unknownTransactionType$str() {
        return unknownTransactionType;
    }
    @Override
    public final IllegalStateException unknownTransactionType(final Class<?> expectedType, final Class<?> actualType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownTransactionType$str(), expectedType, actualType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownTransactionManagerType = "WFTXN0087: Unknown transaction manager type %s";
    protected String unknownTransactionManagerType$str() {
        return unknownTransactionManagerType;
    }
    @Override
    public final IllegalArgumentException unknownTransactionManagerType(final Class<?> actualType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownTransactionManagerType$str(), actualType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPermission = "WFTXN0088: User %s does not have permission %s";
    protected String noPermission$str() {
        return noPermission;
    }
    @Override
    public final SecurityException noPermission(final String user, final Permission permission) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), noPermission$str(), user, permission));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String setTimeoutFailed = "WFTXN0089: Failed to configure transaction timeout of %d";
    protected String setTimeoutFailed$str() {
        return setTimeoutFailed;
    }
    @Override
    public final SystemException setTimeoutFailed(final int timeout, final XAException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), setTimeoutFailed$str(), timeout));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String locationAlreadyInitialized = "WFTXN0090: Cannot assign location \"%s\" to transaction because it is already located at \"%s\"";
    protected String locationAlreadyInitialized$str() {
        return locationAlreadyInitialized;
    }
    @Override
    public final IllegalStateException locationAlreadyInitialized(final URI newLocation, final URI oldLocation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), locationAlreadyInitialized$str(), newLocation, oldLocation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String createXAResourceRecoveryFileFailed = "WFTXN0091: Failed to create xa resource recovery file: %s";
    protected String createXAResourceRecoveryFileFailed$str() {
        return createXAResourceRecoveryFileFailed;
    }
    @Override
    public final SystemException createXAResourceRecoveryFileFailed(final Path filePath, final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), createXAResourceRecoveryFileFailed$str(), filePath));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String appendXAResourceRecoveryFileFailed = "WFTXN0092: Failed to append xa resource (%s) to xa recovery file: %s";
    protected String appendXAResourceRecoveryFileFailed$str() {
        return appendXAResourceRecoveryFileFailed;
    }
    @Override
    public final SystemException appendXAResourceRecoveryFileFailed(final URI uri, final Path filePath, final IOException e) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), appendXAResourceRecoveryFileFailed$str(), uri, filePath));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deleteXAResourceRecoveryFileFailed = "WFTXN0093: Failed to delete xa recovery registry file %s on removal of %s";
    protected String deleteXAResourceRecoveryFileFailed$str() {
        return deleteXAResourceRecoveryFileFailed;
    }
    @Override
    public final XAException deleteXAResourceRecoveryFileFailed(final int errorCode, final Path filePath, final XAResource resource, final IOException e) {
        final XAException result = new XAException(String.format(getLoggingLocale(), deleteXAResourceRecoveryFileFailed$str(), filePath, resource));
        result.initCause(e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        result.errorCode = errorCode;
        return result;
    }
    private static final String readXAResourceRecoveryFileFailed = "WFTXN0094: Failed to read xa resource recovery file %s";
    protected String readXAResourceRecoveryFileFailed$str() {
        return readXAResourceRecoveryFileFailed;
    }
    @Override
    public final IOException readXAResourceRecoveryFileFailed(final Path filePath, final IOException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readXAResourceRecoveryFileFailed$str(), filePath), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readURIFromXAResourceRecoveryFileFailed = "WFTXN0095: Failed to read URI '%s' from xa resource recovery file %s";
    protected String readURIFromXAResourceRecoveryFileFailed$str() {
        return readURIFromXAResourceRecoveryFileFailed;
    }
    @Override
    public final IOException readURIFromXAResourceRecoveryFileFailed(final String uriString, final Path filePath, final URISyntaxException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), readURIFromXAResourceRecoveryFileFailed$str(), uriString, filePath), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedExceptionOnXAResourceRecovery = "WFTXN0096: Unexpected exception on XA recovery";
    protected String unexpectedExceptionOnXAResourceRecovery$str() {
        return unexpectedExceptionOnXAResourceRecovery;
    }
    @Override
    public final IllegalStateException unexpectedExceptionOnXAResourceRecovery(final IOException e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedExceptionOnXAResourceRecovery$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotEnlistToTimeOutTransaction = "WFTXN0097: Cannot enlist XA resource '%s' to transaction '%s' as timeout already elapsed";
    protected String cannotEnlistToTimeOutTransaction$str() {
        return cannotEnlistToTimeOutTransaction;
    }
    @Override
    public final SystemException cannotEnlistToTimeOutTransaction(final XAResource xaRes, final Transaction transaction) {
        final SystemException result = new SystemException(String.format(getLoggingLocale(), cannotEnlistToTimeOutTransaction$str(), xaRes, transaction));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void listXAResourceRecoveryFilesNull(final File dir) {
        super.log.logf(FQCN, WARN, null, listXAResourceRecoveryFilesNull$str(), dir);
    }
    private static final String listXAResourceRecoveryFilesNull = "WFTXN0098: Unknown I/O error when listing xa resource recovery files in %s (File.list() returned null)";
    protected String listXAResourceRecoveryFilesNull$str() {
        return listXAResourceRecoveryFilesNull;
    }
    @Override
    public final void cannotRemoveImportedTransaction(final Xid xid, final XAException e) {
        super.log.logf(FQCN, WARN, e, cannotRemoveImportedTransaction$str(), xid);
    }
    private static final String cannotRemoveImportedTransaction = "WFTXN0099: Error while removing imported transaction of xid %s from the underlying transaction manager";
    protected String cannotRemoveImportedTransaction$str() {
        return cannotRemoveImportedTransaction;
    }
}
