/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.unstable.api.annotation.classpath.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wildfly.unstable.api.annotation.classpath.index.OverallIndex;
import org.wildfly.unstable.api.annotation.classpath.plugin.Filter;

@Mojo(name="index-unstable-api-annotations", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresProject=true)
public class UnstableAPIAnnotationIndexMojo
extends AbstractMojo {
    @Parameter(property="filters", required=true)
    private List<Filter> filters = new ArrayList<Filter>();
    @Parameter(property="outputFile", required=true)
    private File outputFile;
    @Component
    private MavenProject mavenProject;
    OverallIndex overallIndex;

    public void execute() throws MojoExecutionException {
        try {
            Log log = this.getLog();
            log.info((CharSequence)"Running plugin");
            this.overallIndex = new OverallIndex();
            log.info((CharSequence)this.filters.toString());
            List dependencies = this.mavenProject.getDependencies();
            for (Filter indexFilter : this.filters) {
                HashSet<String> allGroupIds = new HashSet<String>();
                HashSet<Pattern> wildcardGroupIds = new HashSet<Pattern>();
                for (String id : indexFilter.getGroupIds()) {
                    if (id.contains("*")) {
                        wildcardGroupIds.add(UnstableAPIAnnotationIndexMojo.createPattern(id));
                        continue;
                    }
                    allGroupIds.add(id);
                }
                for (Artifact artifact : this.mavenProject.getArtifacts()) {
                    log.info((CharSequence)(artifact.getGroupId() + ":" + artifact.getArtifactId()));
                    if (!artifact.getType().equals("jar")) continue;
                    if (allGroupIds.contains(artifact.getGroupId())) {
                        this.overallIndex.scanJar(artifact.getFile(), indexFilter.getAnnotation(), indexFilter.getExcludedClasses());
                        continue;
                    }
                    for (Pattern pattern : wildcardGroupIds) {
                        if (!pattern.matcher(artifact.getGroupId()).matches()) continue;
                        this.overallIndex.scanJar(artifact.getFile(), indexFilter.getAnnotation(), indexFilter.getExcludedClasses());
                    }
                }
            }
            Path path = Paths.get(this.outputFile.toURI());
            this.overallIndex.save(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Pattern createPattern(String s) {
        StringBuilder builder = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (c == '.') {
                builder.append('\\');
            } else if (c == '*') {
                builder.append('.');
            }
            builder.append(c);
        }
        return Pattern.compile(builder.toString());
    }
}

