/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.ai.injection.chat;

import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.mistralai.MistralAiChatModel;
import dev.langchain4j.model.mistralai.MistralAiStreamingChatModel;
import java.time.Duration;
import java.util.List;
import org.wildfly.extension.ai.injection.chat.WildFlyChatModelConfig;

public class WildFlyMistralAiChatModelLanguage
implements WildFlyChatModelConfig {
    private String key;
    private String baseUrl;
    private Boolean logRequests;
    private Boolean logResponses;
    private Integer maxTokens;
    private String modelName;
    private Integer randomSeed;
    private Boolean safePrompt;
    private Double temperature;
    private Duration connectTimeOut;
    private Double topP;
    private boolean isJson;
    private boolean streaming;
    private boolean observable;
    private Object instance = null;

    @Override
    public ChatLanguageModel createLanguageModel(List<ChatModelListener> listeners) {
        if (this.instance == null) {
            MistralAiChatModel.MistralAiChatModelBuilder builder = MistralAiChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).logRequests(this.logRequests).logResponses(this.logResponses).maxRetries(Integer.valueOf(5)).maxTokens(this.maxTokens).modelName(this.modelName).randomSeed(this.randomSeed).safePrompt(this.safePrompt).temperature(this.temperature).timeout(this.connectTimeOut).topP(this.topP);
            if (this.isJson) {
                builder.responseFormat("json_object");
            }
            if (this.observable) {
                // empty if block
            }
            this.instance = builder.build();
        }
        return (ChatLanguageModel)this.instance;
    }

    @Override
    public StreamingChatLanguageModel createStreamingLanguageModel(List<ChatModelListener> listeners) {
        if (this.instance == null) {
            MistralAiStreamingChatModel.MistralAiStreamingChatModelBuilder builder = MistralAiStreamingChatModel.builder().apiKey(this.key).baseUrl(this.baseUrl).logRequests(this.logRequests).logResponses(this.logResponses).maxTokens(this.maxTokens).modelName(this.modelName).randomSeed(this.randomSeed).safePrompt(this.safePrompt).temperature(this.temperature).timeout(this.connectTimeOut).topP(this.topP);
            if (this.isJson) {
                builder.responseFormat("json_object");
            }
            this.instance = builder.build();
        }
        return (StreamingChatLanguageModel)this.instance;
    }

    public WildFlyMistralAiChatModelLanguage apiKey(String key) {
        this.key = key;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage logRequests(Boolean logRequests) {
        this.logRequests = logRequests;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage logResponses(Boolean logResponses) {
        this.logResponses = logResponses;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage maxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage modelName(String modelName) {
        this.modelName = modelName;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage randomSeed(Integer randomSeed) {
        this.randomSeed = randomSeed;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage safePrompt(Boolean safePrompt) {
        this.safePrompt = safePrompt;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage setJson(boolean isJson) {
        this.isJson = isJson;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage temperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage timeout(long timeOut) {
        if (timeOut <= 0L) {
            this.connectTimeOut = null;
            return this;
        }
        this.connectTimeOut = Duration.ofMillis(timeOut);
        return this;
    }

    public WildFlyMistralAiChatModelLanguage topP(Double topP) {
        this.topP = topP;
        return this;
    }

    public WildFlyMistralAiChatModelLanguage streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    @Override
    public boolean isObservable() {
        return false;
    }
}

