/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.logging;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

public class AppClientLogger_$logger
extends DelegatingBasicLogger
implements AppClientLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AppClientLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public AppClientLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void exceptionRunningAppClient(Throwable cause, String exceptionName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.exceptionRunningAppClient$str(), (Object)exceptionName);
    }

    protected String exceptionRunningAppClient$str() {
        return "WFLYAC0002: %s running app client main";
    }

    protected String argAppClientConfig$str() {
        return "Name of the app client configuration file to use (default is \"appclient.xml\")";
    }

    @Override
    public final String argAppClientConfig() {
        return String.format(this.getLoggingLocale(), this.argAppClientConfig$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String argHost$str() {
        return "Set the url of the application server instance to connect to";
    }

    @Override
    public final String argHost() {
        return String.format(this.getLoggingLocale(), this.argHost$str(), new Object[0]);
    }

    protected String argConnectionProperties$str() {
        return "Load ejb-client.properties file from the given url";
    }

    @Override
    public final String argConnectionProperties() {
        return String.format(this.getLoggingLocale(), this.argConnectionProperties$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return "Load system properties from the given url";
    }

    @Override
    public final String argProperties() {
        return String.format(this.getLoggingLocale(), this.argProperties$str(), new Object[0]);
    }

    protected String argSystemProperty$str() {
        return "Set a system property";
    }

    @Override
    public final String argSystemProperty() {
        return String.format(this.getLoggingLocale(), this.argSystemProperty$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return "Print version and exit";
    }

    @Override
    public final String argVersion() {
        return String.format(this.getLoggingLocale(), this.argVersion$str(), new Object[0]);
    }

    protected String argSecMgr$str() {
        return "Runs the container with the security manager enabled.";
    }

    @Override
    public final String argSecMgr() {
        return String.format(this.getLoggingLocale(), this.argSecMgr$str(), new Object[0]);
    }

    protected String usageDescription$str() {
        return "The appclient script starts an application client which can be used to test and access the deployed Jakarta Enterprise Beans.";
    }

    @Override
    public final String usageDescription() {
        return String.format(this.getLoggingLocale(), this.usageDescription$str(), new Object[0]);
    }

    protected String appClientNotSpecified$str() {
        return "WFLYAC0004: You must specify the application client to execute";
    }

    @Override
    public final String appClientNotSpecified() {
        return String.format(this.getLoggingLocale(), this.appClientNotSpecified$str(), new Object[0]);
    }

    protected String argumentExpected$str() {
        return "WFLYAC0005: Argument expected for option %s";
    }

    @Override
    public final String argumentExpected(String arg) {
        return String.format(this.getLoggingLocale(), this.argumentExpected$str(), arg);
    }

    protected String cannotFindAppClient0$str() {
        return "WFLYAC0006: Could not find application client jar in deployment";
    }

    @Override
    public final RuntimeException cannotFindAppClient() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotFindAppClient0$str(), new Object[0]));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotFindAppClient1$str() {
        return "WFLYAC0007: Could not find application client %s";
    }

    @Override
    public final DeploymentUnitProcessingException cannotFindAppClient(String deploymentName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.cannotFindAppClient1$str(), deploymentName));
        AppClientLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotLoadAppClientMainClass$str() {
        return "WFLYAC0008: Could not load application client main class";
    }

    @Override
    public final RuntimeException cannotLoadAppClientMainClass(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotLoadAppClientMainClass$str(), new Object[0]), cause);
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLoadProperties$str() {
        return "WFLYAC0010: Unable to load properties from URL %s";
    }

    @Override
    public final String cannotLoadProperties(URL url) {
        return String.format(this.getLoggingLocale(), this.cannotLoadProperties$str(), url);
    }

    protected String cannotStartAppClient1$str() {
        return "WFLYAC0011: Could not start app client %s as no main class was found";
    }

    @Override
    public final RuntimeException cannotStartAppClient(String deploymentName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotStartAppClient1$str(), deploymentName));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotStartAppClient2$str() {
        return "WFLYAC0012: Could not start app client %s as no main method was found on main class %s";
    }

    @Override
    public final RuntimeException cannotStartAppClient(String deploymentName, Class<?> mainClass) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotStartAppClient2$str(), deploymentName, mainClass));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateSubsystemDeclaration$str() {
        return "WFLYAC0013: Duplicate subsystem declaration";
    }

    @Override
    public final XMLStreamException duplicateSubsystemDeclaration(Location location) {
        XMLStreamException result = new XMLStreamException(String.format(this.getLoggingLocale(), this.duplicateSubsystemDeclaration$str(), new Object[0]), location);
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToParseXml1$str() {
        return "WFLYAC0015: Failed to parse %s";
    }

    @Override
    public final DeploymentUnitProcessingException failedToParseXml(Throwable cause, VirtualFile appXml) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParseXml1$str(), appXml), cause);
        AppClientLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToParseXml3$str() {
        return "WFLYAC0016: Failed to parse %s at [%d,%d]";
    }

    @Override
    public final DeploymentUnitProcessingException failedToParseXml(Throwable cause, VirtualFile appXml, int lineNumber, int columnNumber) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.failedToParseXml3$str(), appXml, lineNumber, columnNumber), cause);
        AppClientLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String malformedUrl$str() {
        return "WFLYAC0017: Malformed URL provided for option %s";
    }

    @Override
    public final String malformedUrl(String arg) {
        return String.format(this.getLoggingLocale(), this.malformedUrl$str(), arg);
    }

    protected String multipleAppClientsFound$str() {
        return "WFLYAC0018: More than one application client found and no app client name specified";
    }

    @Override
    public final RuntimeException multipleAppClientsFound() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.multipleAppClientsFound$str(), new Object[0]));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownOption$str() {
        return "WFLYAC0020: Unknown option %s";
    }

    @Override
    public final String unknownOption(String option) {
        return String.format(this.getLoggingLocale(), this.unknownOption$str(), option);
    }

    protected String couldNotLoadCallbackClass$str() {
        return "WFLYAC0021: Could not load callback-handler class %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotLoadCallbackClass(String clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotLoadCallbackClass$str(), clazz));
        AppClientLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotCreateCallbackHandler$str() {
        return "WFLYAC0022: Could not create instance of callback-handler class %s";
    }

    @Override
    public final DeploymentUnitProcessingException couldNotCreateCallbackHandler(String clazz) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.couldNotCreateCallbackHandler$str(), clazz));
        AppClientLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotFindAppClientFile$str() {
        return "WFLYAC0023: Could not find application client %s";
    }

    @Override
    public final RuntimeException cannotFindAppClientFile(File deploymentName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotFindAppClientFile$str(), deploymentName));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSpecifyBothHostAndPropertiesFile$str() {
        return "WFLYAC0024: Cannot specify both a host to connect to and an ejb-client.properties file. ";
    }

    @Override
    public final RuntimeException cannotSpecifyBothHostAndPropertiesFile() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotSpecifyBothHostAndPropertiesFile$str(), new Object[0]));
        AppClientLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

