/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.testenricher.msc.ServiceTargetAssociation;
import org.jboss.arquillian.testenricher.osgi.BundleAssociation;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class ArquillianConfig
implements Service<ArquillianConfig> {
    static final AttachmentKey<ArquillianConfig> KEY = AttachmentKey.create(ArquillianConfig.class);
    private final ArquillianService arqService;
    private final DeploymentUnit depUnit;
    private final ServiceName serviceName;
    private final List<String> testClasses = new ArrayList<String>();
    private final InjectedValue<BundleContext> injectedBundleContext = new InjectedValue();
    private ServiceTarget serviceTarget;

    static ServiceName getServiceName(DeploymentUnit depUnit) {
        return ServiceName.JBOSS.append(new String[]{"arquillian", "config", depUnit.getName()});
    }

    ArquillianConfig(ArquillianService arqService, DeploymentUnit depUnit, Set<String> testClasses) {
        this.arqService = arqService;
        this.depUnit = depUnit;
        this.serviceName = ArquillianConfig.getServiceName(depUnit);
        this.testClasses.addAll(testClasses);
    }

    ServiceBuilder<ArquillianConfig> buildService(ServiceTarget serviceTarget, ServiceController<?> depController) {
        ServiceBuilder builder = serviceTarget.addService(this.getServiceName(), (Service)this);
        builder.addDependency(ServiceBuilder.DependencyType.OPTIONAL, Services.FRAMEWORK_CREATE, BundleContext.class, this.injectedBundleContext);
        builder.addDependency(depController.getName());
        return builder;
    }

    ServiceName getServiceName() {
        return this.serviceName;
    }

    DeploymentUnit getDeploymentUnit() {
        return this.depUnit;
    }

    List<String> getTestClasses() {
        return Collections.unmodifiableList(this.testClasses);
    }

    BundleContext getBundleContext() {
        return (BundleContext)this.injectedBundleContext.getOptionalValue();
    }

    Class<?> loadClass(String className) throws ClassNotFoundException {
        Class testClass;
        if (!this.testClasses.contains(className)) {
            throw new ClassNotFoundException("Class '" + className + "' not found in: " + this.testClasses);
        }
        XBundleRevision brev = (XBundleRevision)this.depUnit.getAttachment(OSGiConstants.BUNDLE_REVISION_KEY);
        Module module = (Module)this.depUnit.getAttachment(Attachments.MODULE);
        if (brev == null && module == null) {
            throw new IllegalStateException("Cannot determine deployment type: " + this.depUnit);
        }
        if (brev != null) {
            XBundle bundle = brev.getBundle();
            testClass = bundle.loadClass(className);
            BundleAssociation.setBundle((Bundle)bundle);
        } else {
            testClass = module.getClassLoader().loadClass(className);
        }
        return testClass;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.serviceTarget = context.getChildTarget();
        this.arqService.registerArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.setServiceTarget((String)testClass, (ServiceTarget)this.serviceTarget);
        }
    }

    public synchronized void stop(StopContext context) {
        context.getController().setMode(ServiceController.Mode.REMOVE);
        this.arqService.unregisterArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.clearServiceTarget((String)testClass);
        }
    }

    public synchronized ArquillianConfig getValue() {
        return this;
    }

    public String toString() {
        String uname = this.depUnit.getName();
        String sname = this.serviceName.getCanonicalName();
        return "ArquillianConfig[service=" + sname + ",unit=" + uname + ",tests=" + this.testClasses + "]";
    }
}

