/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;

public class ArquillianConfigBuilder {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private static final String CLASS_NAME_JUNIT_RUNNER = "org.junit.runner.RunWith";
    private static final String CLASS_NAME_TESTNG_RUNNER = "org.jboss.arquillian.testng.Arquillian";
    private static final AttachmentKey<Set<String>> CLASSES = AttachmentKey.create(Set.class);

    ArquillianConfigBuilder(DeploymentUnit deploymentUnit) {
    }

    static ArquillianConfig processDeployment(ArquillianService arqService, DeploymentUnit depUnit) {
        Set testClasses = (Set)depUnit.getAttachment(CLASSES);
        if (testClasses == null || testClasses.isEmpty()) {
            return null;
        }
        ArquillianConfig arqConfig = new ArquillianConfig(arqService, depUnit, testClasses);
        ServiceController service = arqService.getServiceContainer().getService(arqConfig.getServiceName());
        if (service != null) {
            service.setMode(ServiceController.Mode.REMOVE);
            StabilityMonitor monitor = new StabilityMonitor();
            monitor.addController(service);
            try {
                monitor.awaitStability(20L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            finally {
                monitor.removeController(service);
            }
        }
        depUnit.putAttachment(ArquillianConfig.KEY, (Object)arqConfig);
        return arqConfig;
    }

    static void handleParseAnnotations(DeploymentUnit deploymentUnit) {
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)deploymentUnit);
            return;
        }
        DotName runWithName = DotName.createSimple((String)CLASS_NAME_JUNIT_RUNNER);
        List runWithList = compositeIndex.getAnnotations(runWithName);
        DotName testNGClassName = DotName.createSimple((String)CLASS_NAME_TESTNG_RUNNER);
        Set testNgTests = compositeIndex.getAllKnownSubclasses(testNGClassName);
        HashSet<String> testClasses = new HashSet<String>();
        for (AnnotationInstance instance : runWithList) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            String testClassName = classInfo.name().toString();
            testClasses.add(testClassName);
        }
        for (ClassInfo classInfo : testNgTests) {
            testClasses.add(classInfo.name().toString());
        }
        deploymentUnit.putAttachment(CLASSES, testClasses);
    }
}

