/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    DEFAULT_JOB_REPOSITORY("default-job-repository"),
    DEFAULT_THREAD_POOL("default-thread-pool"),
    JOB_REPOSITORY("job-repository"),
    JDBC("jdbc"),
    IN_MEMORY("in-memory"),
    NAMED("named"),
    THREAD_FACTORY("thread-factory"),
    THREAD_POOL("thread-pool");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

