/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.wildfly.extension.batch.jberet.thread.pool;

import org.jberet.spi.JobExecutor;
import org.jberet.spi.JobTask;
import org.jboss.as.threads.ManagedJBossThreadPoolExecutorService;
import org.wildfly.extension.requestcontroller.ControlPointTask;

/**
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
class WildFlyJobExecutor extends JobExecutor {
    private final ManagedJBossThreadPoolExecutorService delegate;

    public WildFlyJobExecutor(final ManagedJBossThreadPoolExecutorService delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    protected int getMaximumPoolSize() {
        return delegate.getMaxThreads();
    }

    @Override
    protected JobTask wrap(final Runnable task) {
        if (task instanceof JobTask) {
            return (JobTask) task;
        }

        final int requiredRemaining;
        if (task instanceof ControlPointTask) {
            final Runnable originalTask = ((ControlPointTask) task).getOriginalTask();
            if (originalTask instanceof JobTask) {
                requiredRemaining = ((JobTask) originalTask).getRequiredRemainingPermits();
            } else {
                requiredRemaining = 0;
            }
        } else {
            requiredRemaining = 0;
        }

        return new JobTask() {
            @Override
            public int getRequiredRemainingPermits() {
                return requiredRemaining;
            }

            @Override
            public void run() {
                task.run();
            }
        };
    }
}
