/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.io.PomIO;
import org.jboss.logging.Logger;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channelplugin.utils.PMEUtils;

@Mojo(name="inject-repositories", requiresDirectInvocation=true)
public class InjectRepositoriesMojo
extends AbstractMojo {
    private static final Logger logger = Logger.getLogger(InjectRepositoriesMojo.class);
    private static final String CENTRAL_URL = "https://repo.maven.apache.org/maven2";
    @Parameter(property="fromChannelFile")
    String fromChannelFile;
    @Parameter(property="repositories")
    List<String> repositories;
    @Inject
    MavenSession mavenSession;
    @Inject
    PomIO pomIO;
    @Inject
    MavenProject mavenProject;

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.fromChannelFile) && (this.repositories == null || this.repositories.isEmpty())) {
            throw new MojoExecutionException("Exactly one of `fromChannelFile` and `repositories` parameters is needed.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.fromChannelFile) && this.repositories != null && !this.repositories.isEmpty()) {
            throw new MojoExecutionException("Exactly one of `fromChannelFile` and `repositories` parameters is needed.");
        }
        HashMap<String, String> repositoriesToInject = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.fromChannelFile)) {
            List channels;
            Path channelFilePath = Path.of(this.fromChannelFile, new String[0]);
            if (!channelFilePath.isAbsolute()) {
                channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
            }
            this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
            try (InputStream is = channelFilePath.toUri().toURL().openStream();){
                channels = ChannelMapper.fromString((String)new String(is.readAllBytes()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Can't read channel file", (Exception)e);
            }
            channels.stream().flatMap(c -> c.getRepositories().stream()).forEach(repository -> {
                if (!repositoriesToInject.containsValue(repository.getUrl())) {
                    repositoriesToInject.put(repository.getId(), repository.getUrl());
                }
            });
        } else if (this.repositories != null && !this.repositories.isEmpty()) {
            AbstractChannelMojo.createRepositories(this.repositories).forEach(r -> repositoriesToInject.put(r.getId(), r.getUrl()));
        }
        try {
            List<Project> projects = PMEUtils.parsePmeProjects(this.pomIO, this.mavenProject);
            Project rootProject = PMEUtils.findRootProject(projects);
            this.getLog().info((CharSequence)("Root project: " + rootProject.getArtifactId()));
            PomManipulator manipulator = new PomManipulator(rootProject);
            InjectRepositoriesMojo.insertRepositories(rootProject, manipulator, repositoriesToInject);
            manipulator.writePom();
        }
        catch (ManipulationException e) {
            throw new MojoExecutionException("Can't parse project POM files", (Exception)((Object)e));
        }
    }

    static void insertRepositories(Project project, PomManipulator manipulator, Map<String, String> repositories) {
        Set existingRepositories = project.getModel().getRepositories().stream().map(RepositoryBase::getUrl).collect(Collectors.toSet());
        existingRepositories.add(CENTRAL_URL);
        repositories.forEach((id, url) -> {
            if (!existingRepositories.contains(url)) {
                try {
                    logger.infof("Inserting repository %s", url);
                    manipulator.injectRepository((String)id, (String)url);
                }
                catch (XMLStreamException e) {
                    ChannelPluginLogger.LOGGER.errorf("Failed to inject repository: %s", (Object)e.getMessage());
                }
            } else {
                logger.infof("Repository with URL %s is already present.", url);
            }
        });
        Set existingPluginRepositories = project.getModel().getPluginRepositories().stream().map(RepositoryBase::getUrl).collect(Collectors.toSet());
        existingPluginRepositories.add(CENTRAL_URL);
        repositories.forEach((id, url) -> {
            if (!existingPluginRepositories.contains(url)) {
                try {
                    logger.infof("Inserting plugin repository %s", url);
                    manipulator.injectPluginRepository((String)id, (String)url);
                }
                catch (XMLStreamException e) {
                    ChannelPluginLogger.LOGGER.errorf("Failed to inject plugin repository: %s", (Object)e.getMessage());
                }
            } else {
                logger.infof("Plugin repository with URL %s is already present.", url);
            }
        });
    }
}

