/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import groovy.lang.Tuple;
import groovy.lang.Tuple3;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.codehaus.mojo.versions.ordering.MavenVersionComparator;
import org.codehaus.mojo.versions.ordering.VersionComparator;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.VersionResult;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.InjectRepositoriesMojo;
import org.wildfly.channelplugin.MojoConfigurator;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channelplugin.utils.PMEUtils;
import org.wildfly.channeltools.util.ConversionUtils;
import org.wildfly.channeltools.util.VersionUtils;

@Mojo(name="upgrade", requiresDirectInvocation=true)
public class UpgradeComponentsMojo
extends AbstractChannelMojo {
    private static final VersionComparator VERSION_COMPARATOR = new MavenVersionComparator();
    @Parameter(property="ignoreStreams")
    List<String> ignoreStreams;
    @Parameter(property="dontIgnoreStreams")
    List<String> dontIgnoreStreams;
    @Parameter(property="ignoreModules")
    List<String> ignoreModules;
    @Parameter(property="ignoreProperties")
    List<String> ignoreProperties;
    @Parameter(property="ignorePropertiesPrefixedWith")
    List<String> ignorePropertiesPrefixedWith;
    @Parameter(property="overrideProperties")
    List<String> overrideProperties;
    @Parameter(property="overrideDependencies")
    List<String> overrideDependencies;
    @Parameter(property="inlineUpgradedVersions", defaultValue="false")
    boolean inlineUpgradedVersions;
    @Parameter(property="injectTransitiveDependencies", defaultValue="true")
    boolean injectTransitiveDependencies;
    @Parameter(property="ignoreTestDependencies", defaultValue="true")
    boolean ignoreTestDependencies;
    @Parameter(property="injectExternalProperties", defaultValue="true")
    boolean injectExternalProperties;
    @Parameter(property="injectRepositories", defaultValue="true")
    boolean injectRepositories;
    @Parameter(property="doNotDowngrade", defaultValue="false")
    boolean doNotDowngrade;
    @Inject
    DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    ManipulationSession manipulationSession;
    private final List<ProjectRef> ignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> unignoredStreams = new ArrayList<ProjectRef>();
    private final List<ProjectRef> ignoredModules = new ArrayList<ProjectRef>();
    private Set<ProjectVersionRef> projectGavs;
    private final HashMap<Pair<String, String>, PomManipulator> manipulators = new HashMap();
    private PomManipulator rootManipulator;
    private final HashMap<Pair<Project, String>, String> upgradedProperties = new HashMap();
    private final Set<ProjectRef> declaredDependencies = new HashSet<ProjectRef>();

    private void init() throws MojoExecutionException {
        this.initChannelSession();
        this.ignoreStreams.forEach(ga -> this.ignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.dontIgnoreStreams.forEach(ga -> this.unignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.ignoreModules.forEach(ga -> this.ignoredModules.add(SimpleProjectRef.parse((String)ga)));
    }

    private void reconfigure() throws MojoExecutionException {
        File configFile = new File(this.mavenSession.getExecutionRootDirectory(), ".wildfly-channel-maven-plugin");
        try {
            MojoConfigurator configurator = new MojoConfigurator(configFile);
            configurator.configureProperties(this);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read plugin configuration from .wildfly-channel-maven-plugin", (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.reconfigure();
        this.init();
        try {
            List<Project> pmeProjects = PMEUtils.parsePmeProjects(this.pomIO, this.mavenProject);
            this.projectGavs = pmeProjects.stream().map(p -> new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), p.getVersion())).collect(Collectors.toSet());
            for (Project project : pmeProjects) {
                ProjectRef moduleGA = project.getKey().asProjectRef();
                if (this.ignoredModules.contains(moduleGA)) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", project.getGroupId(), project.getArtifactId()));
                PomManipulator manipulator = new PomManipulator(project);
                this.manipulators.put((Pair<String, String>)Pair.of((Object)project.getGroupId(), (Object)project.getArtifactId()), manipulator);
                this.processModule(project, manipulator);
            }
            Project rootProject = PMEUtils.findRootProject(pmeProjects);
            this.rootManipulator = this.manipulators.get(Pair.of((Object)rootProject.getGroupId(), (Object)rootProject.getArtifactId()));
            if (this.injectTransitiveDependencies) {
                this.injectTransitiveDependencies();
            }
            if (this.injectRepositories) {
                Map<String, String> repositoriesToInject = this.channels.stream().flatMap(c -> c.getRepositories().stream()).distinct().collect(Collectors.toMap(Repository::getId, Repository::getUrl));
                InjectRepositoriesMojo.insertRepositories(rootProject, this.rootManipulator, repositoriesToInject);
            }
            for (PomManipulator manipulator : this.manipulators.values()) {
                manipulator.writePom();
            }
        }
        catch (XMLStreamException | ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)e);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Dependency collector error", (Exception)((Object)e));
        }
    }

    private void processModule(Project pmeProject, PomManipulator manipulator) throws ManipulationException, XMLStreamException {
        Map<ArtifactRef, Dependency> resolvedProjectDependencies = this.collectResolvedProjectDependencies(pmeProject);
        resolvedProjectDependencies.keySet().forEach(a -> this.declaredDependencies.add(a.asProjectRef()));
        List<String> overriddenProperties = this.performHardPropertyOverrides(manipulator);
        List<Dependency> overriddenDependencies = this.performHardDependencyOverrides(resolvedProjectDependencies, manipulator);
        List<Tuple3<Dependency, ArtifactRef, String>> dependenciesToUpgrade = this.findDependenciesToUpgrade(resolvedProjectDependencies);
        for (Tuple3<Dependency, ArtifactRef, String> upgrade : dependenciesToUpgrade) {
            String newVersion = (String)upgrade.getV3();
            Dependency locatedDependency = (Dependency)upgrade.getV1();
            ArtifactRef resolvedDependency = (ArtifactRef)upgrade.getV2();
            Dependency d = locatedDependency;
            if (overriddenDependencies.contains(locatedDependency)) continue;
            if (VersionUtils.isProperty((String)locatedDependency.getVersion()) && !this.inlineUpgradedVersions) {
                PomManipulator targetManipulator;
                Pair<String, String> externalProperty;
                String originalVersionString = locatedDependency.getVersion();
                String versionPropertyName = VersionUtils.extractPropertyName((String)originalVersionString);
                if (overriddenProperties.contains(versionPropertyName)) continue;
                Pair projectProperty = UpgradeComponentsMojo.followProperties(pmeProject, versionPropertyName);
                if (projectProperty == null && (externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, versionPropertyName)) != null) {
                    projectProperty = Pair.of(null, (Object)((String)externalProperty.getLeft()));
                }
                if (projectProperty == null) {
                    ChannelPluginLogger.LOGGER.errorf("Unable to upgrade %s:%s:%s to '%s', can't locate property '%s' in the project", new Object[]{d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, versionPropertyName});
                    continue;
                }
                Project targetProject = (Project)projectProperty.getLeft();
                String targetPropertyName = (String)projectProperty.getRight();
                if (this.isIgnoredProperty(targetPropertyName)) {
                    this.getLog().info((CharSequence)String.format("Ignoring property '%s'", targetPropertyName));
                    continue;
                }
                if (this.upgradedProperties.containsKey(projectProperty) && !this.upgradedProperties.get(projectProperty).trim().equals(newVersion.trim())) {
                    String propertyName = (String)projectProperty.getRight();
                    String currentPropertyValue = this.upgradedProperties.get(projectProperty);
                    this.getLog().warn((CharSequence)String.format("Inlining version string for %s:%s:%s, new version '%s'. The original version property '%s' has already been modified to '%s'.", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, propertyName, currentPropertyValue));
                    manipulator.overrideDependencyVersion(d.getGroupId(), d.getArtifactId(), originalVersionString, newVersion);
                    continue;
                }
                this.upgradedProperties.put((Pair<Project, String>)projectProperty, newVersion);
                if (targetProject != null) {
                    targetManipulator = this.manipulators.get(Pair.of((Object)targetProject.getGroupId(), (Object)targetProject.getArtifactId()));
                    targetManipulator.overrideProperty(targetPropertyName, newVersion);
                    continue;
                }
                if (this.injectExternalProperties) {
                    targetManipulator = this.manipulators.get(Pair.of((Object)pmeProject.getGroupId(), (Object)pmeProject.getArtifactId()));
                    targetManipulator.injectProperty(targetPropertyName, newVersion);
                    continue;
                }
                this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to %s, property %s is not defined in the scope of the project (consider enabling the injectExternalProperties parameter).", d.getGroupId(), d.getArtifactId(), d.getVersion(), newVersion, targetPropertyName));
                continue;
            }
            manipulator.overrideDependencyVersionWithComment(resolvedDependency, newVersion);
        }
    }

    private List<String> performHardPropertyOverrides(PomManipulator manipulator) throws XMLStreamException {
        ArrayList<String> overriddenProperties = new ArrayList<String>();
        for (String nameValue : this.overrideProperties) {
            String[] split = nameValue.split("=");
            if (split.length != 2) {
                this.getLog().error((CharSequence)String.format("Can't interpret property to override settings: '%s'", nameValue));
                continue;
            }
            String propertyName = split[0];
            String propertyValue = split[1];
            if (!manipulator.overrideProperty(propertyName, propertyValue)) continue;
            this.getLog().info((CharSequence)String.format("Property '%s' overridden to '%s'", propertyName, propertyValue));
            overriddenProperties.add(propertyName);
        }
        return overriddenProperties;
    }

    private List<Dependency> performHardDependencyOverrides(Map<ArtifactRef, Dependency> resolvedProjectDependencies, PomManipulator manipulator) throws XMLStreamException {
        ArrayList<Dependency> overriddenDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : resolvedProjectDependencies.values()) {
            Optional<String> overridenVersion = this.findOverriddenVersion(dependency);
            if (!overridenVersion.isPresent()) continue;
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)dependency), overridenVersion.get());
            overriddenDependencies.add(dependency);
        }
        return overriddenDependencies;
    }

    private Optional<String> findOverriddenVersion(Dependency dependency) {
        for (String gav : this.overrideDependencies) {
            String[] split = gav.split(":");
            if (split.length != 3) continue;
            String g = split[0];
            String a = split[1];
            String v = split[2];
            if (!dependency.getGroupId().equals(g) || !dependency.getArtifactId().equals(a)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    private boolean isIgnoredProperty(String propertyName) {
        if (this.ignoreProperties.contains(propertyName)) {
            return true;
        }
        for (String prefix : this.ignorePropertiesPrefixedWith) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private Map<ArtifactRef, Dependency> collectResolvedProjectDependencies(Project pmeProject) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> projectDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.putAll(pmeProject.getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession));
        projectDependencies.putAll(pmeProject.getResolvedDependencies((MavenSessionHandler)this.manipulationSession));
        if (projectDependencies.isEmpty()) {
            this.getLog().debug((CharSequence)("No dependencies found in " + pmeProject.getArtifactId()));
        }
        return projectDependencies;
    }

    private List<Tuple3<Dependency, ArtifactRef, String>> findDependenciesToUpgrade(Map<ArtifactRef, Dependency> resolvedProjectDependencies) {
        ArrayList<Tuple3<Dependency, ArtifactRef, String>> dependenciesToUpgrade = new ArrayList<Tuple3<Dependency, ArtifactRef, String>>();
        for (Map.Entry<ArtifactRef, Dependency> entry : resolvedProjectDependencies.entrySet()) {
            ArtifactRef resolvedArtifact = entry.getKey();
            Dependency dependency = entry.getValue();
            Objects.requireNonNull(resolvedArtifact);
            Objects.requireNonNull(dependency);
            if (this.projectGavs.contains(resolvedArtifact.asProjectVersionRef())) {
                this.getLog().debug((CharSequence)("Ignoring in-project dependency: " + resolvedArtifact.asProjectVersionRef().toString()));
                continue;
            }
            if (!this.unignoredStreams.contains(resolvedArtifact.asProjectRef())) {
                if (this.ignoredStreams.contains(resolvedArtifact.asProjectRef())) {
                    this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + resolvedArtifact.asProjectVersionRef().toString()));
                    continue;
                }
                SimpleProjectRef wildCardIgnoredProjectRef = new SimpleProjectRef(resolvedArtifact.getGroupId(), "*");
                if (this.ignoredStreams.contains(wildCardIgnoredProjectRef)) {
                    this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + resolvedArtifact.asProjectVersionRef().toString()));
                    continue;
                }
            }
            if (resolvedArtifact.getVersionString() == null) {
                this.getLog().error((CharSequence)("Resolved dependency has null version: " + resolvedArtifact));
                continue;
            }
            if (VersionUtils.isProperty((String)resolvedArtifact.getVersionString())) {
                Pair<String, String> externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, VersionUtils.extractPropertyName((String)resolvedArtifact.getVersionString()));
                if (externalProperty != null) {
                    resolvedArtifact = new SimpleArtifactRef(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), (String)externalProperty.getRight(), resolvedArtifact.getType(), resolvedArtifact.getClassifier());
                } else {
                    this.getLog().error((CharSequence)("Resolved dependency has version with property: " + resolvedArtifact));
                    continue;
                }
            }
            if ("test".equals(dependency.getScope()) && this.ignoreTestDependencies) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored scope): " + resolvedArtifact.asProjectVersionRef().toString()));
                continue;
            }
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(resolvedArtifact.getGroupId(), resolvedArtifact.getArtifactId(), resolvedArtifact.getType(), resolvedArtifact.getClassifier(), resolvedArtifact.getVersionString());
                String channelVersion = versionResult.getVersion();
                int comparison = UpgradeComponentsMojo.compareVersions(channelVersion, resolvedArtifact.getVersionString());
                if (comparison <= 0 && (this.doNotDowngrade || comparison >= 0)) continue;
                this.getLog().info((CharSequence)("Updating dependency " + resolvedArtifact.getGroupId() + ":" + resolvedArtifact.getArtifactId() + ":" + resolvedArtifact.getVersionString() + " to version " + channelVersion));
                dependenciesToUpgrade.add((Tuple3<Dependency, ArtifactRef, String>)Tuple.tuple((Object)dependency, (Object)resolvedArtifact, (Object)channelVersion));
            }
            catch (UnresolvedMavenArtifactException e) {
                this.getLog().debug((CharSequence)("Can't resolve artifact: " + resolvedArtifact), (Throwable)e);
            }
        }
        return dependenciesToUpgrade;
    }

    private void injectTransitiveDependencies() throws DependencyGraphBuilderException {
        List projectGAs = this.projectGavs.stream().map(ProjectRef::asProjectRef).collect(Collectors.toList());
        HashMap dependenciesToInject = new HashMap();
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>();
        projects.add(this.mavenProject);
        projects.addAll(this.mavenProject.getCollectedProjects());
        for (MavenProject module : projects) {
            HashMap artifactExclusions = new HashMap();
            List managedDependencies = Collections.emptyList();
            if (module.getModel().getDependencyManagement() != null) {
                managedDependencies = module.getModel().getDependencyManagement().getDependencies();
            }
            managedDependencies.forEach(dep -> artifactExclusions.put(ConversionUtils.toArtifactRef((Dependency)dep), ConversionUtils.toProjectRefs((List)dep.getExclusions())));
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            buildingRequest.setProject(module);
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            visitor.getNodes().forEach(node -> {
                ArtifactRef artifact = ConversionUtils.toArtifactRef((Artifact)node.getArtifact());
                if (projectGAs.contains(artifact.asProjectRef())) {
                    return;
                }
                if (this.declaredDependencies.contains(artifact.asProjectRef())) {
                    return;
                }
                if ("test".equals(node.getArtifact().getScope()) && this.ignoreTestDependencies) {
                    return;
                }
                boolean isIgnored = this.ignoredStreams.contains(artifact.asProjectRef()) || this.ignoredStreams.contains(new SimpleProjectRef(artifact.getGroupId(), "*"));
                boolean isUnignored = this.unignoredStreams.contains(artifact.asProjectRef());
                if (isIgnored && !isUnignored) {
                    return;
                }
                Collection exclusions = artifactExclusions.getOrDefault(artifact, Collections.emptyList());
                Collection existingExclusions = dependenciesToInject.computeIfAbsent(artifact, a -> new HashSet());
                existingExclusions.addAll(exclusions);
            });
        }
        dependenciesToInject.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
            String newVersion;
            ArtifactRef artifact = (ArtifactRef)entry.getKey();
            Collection exclusions = (Collection)entry.getValue();
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersionString());
                newVersion = versionResult.getVersion();
                int comparison = UpgradeComponentsMojo.compareVersions(newVersion, artifact.getVersionString());
                if (this.doNotDowngrade && comparison < 0 || comparison == 0) {
                    return;
                }
            }
            catch (NoStreamFoundException e) {
                return;
            }
            SimpleArtifactRef newDependency = new SimpleArtifactRef(artifact.getGroupId(), artifact.getArtifactId(), newVersion, artifact.getType(), artifact.getClassifier());
            this.getLog().info((CharSequence)String.format("Injecting undeclared dependency: %s (original version was %s)", newDependency, artifact.getVersionString()));
            try {
                this.rootManipulator.injectManagedDependency((ArtifactRef)newDependency, exclusions, artifact.getVersionString());
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Failed to inject a managed dependency", e);
            }
        });
    }

    static Pair<Project, String> followProperties(Project pmeProject, String propertyName) {
        String newPropertyName;
        Pair<Project, String> targetProperty;
        Properties properties = pmeProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            Project parentProject = pmeProject.getProjectParent();
            if (parentProject == null) {
                return null;
            }
            return UpgradeComponentsMojo.followProperties(parentProject, propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.followProperties(pmeProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)pmeProject, (Object)propertyName);
    }

    static Pair<String, String> resolveExternalProperty(MavenProject mavenProject, String propertyName) {
        String newPropertyName;
        Pair<String, String> targetProperty;
        if (mavenProject == null) {
            return null;
        }
        Properties properties = mavenProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            return UpgradeComponentsMojo.resolveExternalProperty(mavenProject.getParent(), propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.resolveExternalProperty(mavenProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return Pair.of((Object)propertyName, (Object)propertyValue);
    }

    private static int compareVersions(String v1, String v2) {
        return VERSION_COMPARATOR.compare((Object)new DefaultArtifactVersion(v1.trim()), (Object)new DefaultArtifactVersion(v2.trim()));
    }
}

