/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.Stream;

@Mojo(name="create-manifest", requiresProject=true, requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.TEST, aggregator=true, defaultPhase=LifecyclePhase.PACKAGE)
public class CreateManifestMojo
extends AbstractMojo {
    @Inject
    MavenProject mavenProject;
    @Parameter(name="excludedScopes", property="excludedScopes", defaultValue="test,provided")
    private String excludedScopes;
    @Parameter(name="manifestName", property="manifestName")
    private String manifestName;
    @Parameter(name="manifestId", property="manifestId")
    private String manifestId;
    @Parameter(name="manifestDescription", property="manifestDescription")
    private String manifestDescription;
    @Parameter(name="manifestLogicalVersion", property="manifestLogicalVersion")
    private String manifestLogicalVersion;
    @Inject
    private MavenProject project;
    @Inject
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        artifacts.addAll(this.mavenProject.getArtifacts());
        artifacts.add(this.mavenProject.getArtifact());
        for (MavenProject project : this.mavenProject.getCollectedProjects()) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Including child module: " + project.getId()));
            }
            artifacts.addAll(project.getArtifacts());
            artifacts.add(project.getArtifact());
        }
        TreeSet<Stream> streams = new TreeSet<Stream>();
        Set<String> excludedScopesSet = this.excludedScopes != null ? Arrays.stream(this.excludedScopes.split(",")).map(String::trim).collect(Collectors.toSet()) : Set.of("test", "provided");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Excluded scopes: " + String.join((CharSequence)",", excludedScopesSet)));
        }
        for (Artifact artifact : artifacts) {
            if (artifact == null) {
                throw new RuntimeException("Artifact cannot be null.");
            }
            if (artifact.getType() != null && artifact.getType().equals("pom")) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Ignoring pom artifact " + artifact));
                continue;
            }
            if (artifact.getScope() != null && excludedScopesSet.contains(artifact.getScope())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Ignoring artifact in ignored scope: " + artifact));
                continue;
            }
            streams.add(new Stream(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        }
        ChannelManifest channelManifest = new ChannelManifest(this.manifestName, this.manifestId, this.manifestLogicalVersion, this.manifestDescription, Collections.emptyList(), streams);
        try {
            String yaml = ChannelManifestMapper.toYaml((ChannelManifest)channelManifest);
            String manifestFileName = String.format("%s-%s-%s.%s", this.project.getArtifactId(), this.project.getVersion(), "manifest", "yaml");
            Path outputDirectory = Path.of(this.project.getBuild().getDirectory(), new String[0]);
            if (!Files.exists(outputDirectory, new LinkOption[0])) {
                Files.createDirectory(outputDirectory, new FileAttribute[0]);
            }
            Path outputPath = Path.of(this.project.getBuild().getDirectory(), manifestFileName);
            Files.writeString(outputPath, (CharSequence)yaml, StandardCharsets.UTF_8, new OpenOption[0]);
            this.projectHelper.attachArtifact(this.project, "yaml", "manifest", outputPath.toFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to serialize manifest", (Exception)e);
        }
    }
}

