/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.commonjava.maven.ext.io.PomIO;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.channel.Channel;
import org.wildfly.channel.ChannelManifestCoordinate;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.ChannelSession;
import org.wildfly.channel.Repository;
import org.wildfly.channel.maven.ChannelCoordinate;
import org.wildfly.channel.maven.VersionResolverFactory;
import org.wildfly.channel.spi.MavenVersionsResolver;
import org.wildfly.channelplugin.utils.IOUtils;

public abstract class AbstractChannelMojo
extends AbstractMojo {
    @Parameter(property="channelFile")
    String channelFile;
    @Parameter(property="manifestFile")
    String manifestFile;
    @Parameter(property="channelGAV")
    String channelGAV;
    @Parameter(property="manifestGAV")
    String manifestGAV;
    @Parameter(property="remoteRepositories")
    List<String> remoteRepositories;
    @Parameter(property="localRepository")
    String localRepositoryPath;
    @Inject
    MavenSession mavenSession;
    @Inject
    MavenProject mavenProject;
    @Inject
    RepositorySystem repositorySystem;
    @Inject
    PomIO pomIO;
    protected List<Channel> channels = new ArrayList<Channel>();
    protected ChannelSession channelSession;

    protected void initChannelSession() throws MojoExecutionException {
        try {
            String[] gavs;
            String[] paths;
            if (StringUtils.isNotBlank((CharSequence)this.channelFile)) {
                for (String path : paths = this.channelFile.split(",")) {
                    Path channelFilePath = Path.of(path, new String[0]);
                    if (!channelFilePath.isAbsolute()) {
                        channelFilePath = Path.of(this.mavenSession.getExecutionRootDirectory(), new String[0]).resolve(channelFilePath);
                    }
                    this.getLog().info((CharSequence)("Reading channel file " + channelFilePath));
                    String yaml = Files.readString(channelFilePath);
                    this.channels.addAll(ChannelMapper.fromString((String)yaml));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.channelGAV)) {
                for (String gav : gavs = this.channelGAV.split(",")) {
                    this.channels.addAll(this.resolveChannelsFromGav(gav));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestFile)) {
                for (String path : paths = this.manifestFile.split(",")) {
                    URL manifestUrl = Path.of(path, new String[0]).toUri().toURL();
                    ChannelManifestCoordinate coordinate = new ChannelManifestCoordinate(manifestUrl);
                    this.channels.add(new Channel("a-channel", null, null, null, coordinate, null, null));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.manifestGAV)) {
                for (String gav : gavs = this.manifestGAV.split(",")) {
                    ChannelManifestCoordinate coordinate = AbstractChannelMojo.toManifestCoordinate(gav);
                    List repositories = this.mavenProject.getRemoteProjectRepositories().stream().map(rr -> new Repository(rr.getId(), rr.getUrl())).collect(Collectors.toList());
                    repositories.addAll(AbstractChannelMojo.createRepositories(this.remoteRepositories));
                    this.channels.add(new Channel("a-channel", null, null, repositories, coordinate, null, null));
                }
            }
            if (this.channels.isEmpty()) {
                throw new MojoExecutionException("No channel or manifest specified.");
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Can't parse the channel or manifest file path", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't read channel metadata file", (Exception)e);
        }
        if (!this.remoteRepositories.isEmpty()) {
            this.channels = AbstractChannelMojo.overrideRemoteRepositories(this.channels, this.remoteRepositories);
        }
        if (StringUtils.isBlank((CharSequence)this.localRepositoryPath)) {
            try {
                this.localRepositoryPath = IOUtils.createTemporaryCache();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create local maven cache", (Exception)e);
            }
        }
        DefaultRepositorySystemSession repositorySystemSession = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepository = new LocalRepository(this.localRepositoryPath);
        LocalRepositoryManager localRepoManager = this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)repositorySystemSession, localRepository);
        repositorySystemSession.setLocalRepositoryManager(localRepoManager);
        this.channelSession = new ChannelSession(this.channels, (MavenVersionsResolver.Factory)new VersionResolverFactory(this.repositorySystem, (RepositorySystemSession)repositorySystemSession));
    }

    protected List<Channel> resolveChannelsFromGav(String gavString) {
        List list;
        ChannelCoordinate channelCoordinate = AbstractChannelMojo.toChannelCoordinate(gavString);
        RepositorySystemSession repoSession = this.mavenSession.getRepositorySession();
        ArrayList<RemoteRepository> channelRepos = new ArrayList<RemoteRepository>(this.mavenProject.getRemoteProjectRepositories());
        int repoNumber = 0;
        if (this.remoteRepositories != null && !this.remoteRepositories.isEmpty()) {
            for (String repoUrl : this.remoteRepositories) {
                RemoteRepository repo = new RemoteRepository.Builder("repo-" + repoNumber++, "default", repoUrl).build();
                channelRepos.add(repo);
            }
        }
        VersionResolverFactory versionResolverFactory = new VersionResolverFactory(this.repositorySystem, repoSession);
        try {
            list = versionResolverFactory.resolveChannels(List.of(channelCoordinate), channelRepos);
        }
        catch (Throwable throwable) {
            try {
                try {
                    versionResolverFactory.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Couldn't resolve channel GAV", e);
            }
        }
        versionResolverFactory.close();
        return list;
    }

    protected static ChannelCoordinate toChannelCoordinate(String gavString) {
        ChannelCoordinate coordinate;
        String[] gavSegments = gavString.split(":");
        if (gavSegments.length == 2) {
            coordinate = new ChannelCoordinate(gavSegments[0], gavSegments[1]);
        } else if (gavSegments.length == 3) {
            coordinate = new ChannelCoordinate(gavSegments[0], gavSegments[1], gavSegments[2]);
        } else {
            throw new IllegalArgumentException("Invalid GAV string, channel GAV has to have two or three segments separated with ':'. Given value was: " + gavString);
        }
        return coordinate;
    }

    protected static ChannelManifestCoordinate toManifestCoordinate(String gavString) {
        ChannelManifestCoordinate coordinate;
        String[] gavSegments = gavString.split(":");
        if (gavSegments.length == 2) {
            coordinate = new ChannelManifestCoordinate(gavSegments[0], gavSegments[1]);
        } else if (gavSegments.length == 3) {
            coordinate = new ChannelManifestCoordinate(gavSegments[0], gavSegments[1], gavSegments[2]);
        } else {
            throw new IllegalArgumentException("Invalid GAV string, manifest GAV has to have two or three segments separated with ':'. Given value was: " + gavString);
        }
        return coordinate;
    }

    protected static List<Channel> overrideRemoteRepositories(List<Channel> channels, List<String> repositories) {
        ArrayList<Channel> updatedChannels = new ArrayList<Channel>(channels.size());
        for (Channel channel : channels) {
            updatedChannels.add(new Channel(channel.getName(), channel.getDescription(), channel.getVendor(), AbstractChannelMojo.createRepositories(repositories), channel.getManifestCoordinate(), channel.getBlocklistCoordinate(), channel.getNoStreamStrategy()));
        }
        return updatedChannels;
    }

    protected static List<Repository> createRepositories(List<String> userRepositories) {
        HashMap<Object, Repository> result = new HashMap<Object, Repository>();
        int idx = 0;
        for (String input : userRepositories) {
            Repository previous;
            Object id;
            String[] segments = input.split("::");
            if (segments.length == 1) {
                id = "repo-" + idx++;
                previous = result.put(id, new Repository((String)id, segments[0]));
            } else if (segments.length == 2) {
                id = segments[0];
                previous = result.put(id, new Repository((String)id, segments[1]));
            } else {
                throw new IllegalArgumentException("Invalid remote repository entry: " + input);
            }
            if (previous == null) continue;
            throw new IllegalArgumentException("Duplicate remote repository key: '" + (String)id + "'");
        }
        return new ArrayList<Repository>(result.values());
    }
}

