/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.maven.plugin.AbstractMojo;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;

class MojoConfigurator {
    private static final String INDEX_PATH = "/META-INF/jandex.idx";
    public static final String DEFAULT_CONFIGURATION_FILE = ".wildfly-channel-maven-plugin";
    private static final DotName PROPERTY_ANNOTATION_NAME = DotName.createSimple((String)"org.apache.maven.plugins.annotations.Parameter");
    private final Index index;
    private final Map<String, String> preconfiguredParameters;

    public MojoConfigurator() throws IOException {
        this(new File(DEFAULT_CONFIGURATION_FILE));
    }

    public MojoConfigurator(File configFile) throws IOException {
        try (InputStream input = this.getClass().getResourceAsStream(INDEX_PATH);){
            IndexReader reader = new IndexReader(input);
            this.index = reader.read();
        }
        if (configFile.isFile()) {
            try {
                this.preconfiguredParameters = MojoConfigurator.readConfiguration(configFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Can't read configuration file", e);
            }
        } else {
            this.preconfiguredParameters = Collections.emptyMap();
        }
    }

    public void configureProperties(AbstractMojo mojo) {
        if (this.preconfiguredParameters.isEmpty()) {
            return;
        }
        for (Class<?> aClass = mojo.getClass(); aClass != null && !aClass.equals(Object.class); aClass = aClass.getSuperclass()) {
            ClassInfo classInfo = this.index.getClassByName(aClass);
            if (classInfo == null) continue;
            for (FieldInfo fieldInfo : classInfo.fields()) {
                try {
                    AnnotationInstance annotation = fieldInfo.annotation(PROPERTY_ANNOTATION_NAME);
                    if (annotation == null) continue;
                    Field field = aClass.getDeclaredField(fieldInfo.name());
                    Object currentValue = field.get(mojo);
                    String preconfiguredValue = this.preconfiguredParameters.get(annotation.value("property").asString());
                    if (preconfiguredValue == null || !MojoConfigurator.isDefaultValue(currentValue, annotation)) continue;
                    if (field.getType().equals(String.class)) {
                        field.set(mojo, preconfiguredValue);
                        continue;
                    }
                    if (field.getType().equals(Boolean.TYPE)) {
                        field.set(mojo, Boolean.valueOf(preconfiguredValue));
                        continue;
                    }
                    if (field.getType().equals(List.class)) {
                        field.set(mojo, Arrays.asList(preconfiguredValue.split(",")));
                        continue;
                    }
                    throw new NotImplementedException("Don't know how to handle this type: " + field.getType());
                }
                catch (IllegalAccessException e) {
                    mojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
                }
                catch (NoSuchFieldException e) {
                    mojo.getLog().error((CharSequence)("Field not found: " + fieldInfo.name()), (Throwable)e);
                }
            }
        }
    }

    private static boolean isDefaultValue(Object currentValue, AnnotationInstance annotation) {
        DotName fieldType = ((FieldInfo)annotation.target()).type().name();
        String defaultValue = annotation.value("defaultValue") != null ? annotation.value("defaultValue").asString() : null;
        switch (fieldType.toString()) {
            case "java.util.List": {
                return defaultValue == null && (currentValue == null || ((List)currentValue).isEmpty());
            }
            case "java.lang.String": 
            case "java.lang.Boolean": {
                return currentValue == null || defaultValue != null && defaultValue.equals(currentValue);
            }
        }
        return false;
    }

    private static Map<String, String> readConfiguration(File file) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        List<String> lines = Files.readAllLines(file.toPath());
        for (String line : lines) {
            String[] segments;
            if (line.isBlank()) continue;
            if (line.startsWith("-D")) {
                line = line.substring(2);
            }
            if ((segments = line.split("=", 2)).length == 1) {
                properties.put(segments[0], "true");
                continue;
            }
            if (segments.length == 2) {
                properties.put(segments[0], segments[1]);
                continue;
            }
            throw new IllegalArgumentException("Can't read configuration, expected lines in format `-Dprop=value`, but got: " + line);
        }
        return properties;
    }
}

