/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.wildfly.channel.VersionResult;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channelplugin.utils.PMEUtils;

@Mojo(name="set-property", requiresDirectInvocation=true)
public class SetPropertyMojo
extends AbstractChannelMojo {
    @Parameter(property="property", required=true)
    String property;
    @Parameter(property="stream", required=true)
    String stream;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.initChannelSession();
        if (!this.mavenProject.getModel().getProperties().containsKey(this.property)) {
            throw new MojoFailureException(String.format("Property %s is not present in this project's pom.xml.", this.property));
        }
        ProjectRef ga = SimpleProjectRef.parse((String)this.stream);
        VersionResult result = this.channelSession.findLatestMavenArtifactVersion(ga.getGroupId(), ga.getArtifactId(), "pom", null, null);
        if (StringUtils.isBlank((CharSequence)result.getVersion())) {
            throw new MojoFailureException(String.format("Given channels contain no version for %s:%s.", ga.getGroupId(), ga.getArtifactId()));
        }
        try {
            List<Project> projects = PMEUtils.parsePmeProjects(this.pomIO, this.mavenProject);
            Project rootProject = PMEUtils.findRootProject(projects);
            PomManipulator manipulator = new PomManipulator(rootProject);
            manipulator.overrideProperty(this.property, result.getVersion());
            manipulator.writePom();
        }
        catch (ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            throw new MojoExecutionException("Failed to override the version property.", (Exception)e);
        }
    }
}

