/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin.manipulation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.http.util.Asserts;
import org.apache.maven.model.Model;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.ext.common.model.Project;

public class PomManipulator {
    private static final String DEPENDENCY_MANAGEMENT_PATH = "/project/dependencyManagement";
    private static final String DEPENDENCY_MANAGEMENT_DEPENDENCIES_PATH = "/project/dependencyManagement/dependencies";
    private static final String REPOSITORIES_PATH = "/project/repositories";
    private static final String PLUGIN_REPOSITORIES_PATH = "/project/pluginRepositories";
    private static final String PROJECT = "project";
    private static final String DEPENDENCY_MANAGEMENT = "dependencyManagement";
    private static final String DEPENDENCIES = "dependencies";
    private static final String REPOSITORIES = "repositories";
    private static final String PLUGIN_REPOSITORIES = "pluginRepositories";
    private final Project project;
    private final ModifiedPomXMLEventReader eventReader;
    private final StringBuilder content;
    private boolean closed = false;

    public PomManipulator(Project project) {
        try {
            this.project = project;
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            this.content = PomHelper.readXmlFile((File)project.getPom());
            this.eventReader = new ModifiedPomXMLEventReader(this.content, inputFactory, project.getPom().getPath());
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Couldn't initialize PomWriter instance", e);
        }
    }

    public void overrideDependencyVersion(ArtifactRef d, String newVersion) throws XMLStreamException {
        PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)this.eventReader, (String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getVersionString(), (String)newVersion, (Model)this.project.getModel());
    }

    public void overrideDependencyVersion(String groupId, String artifactId, String oldVersionString, String newVersion) throws XMLStreamException {
        PomHelper.setDependencyVersion((ModifiedPomXMLEventReader)this.eventReader, (String)groupId, (String)artifactId, (String)oldVersionString, (String)newVersion, (Model)this.project.getModel());
    }

    public void overrideDependencyVersionWithComment(ArtifactRef d, String newVersion) throws XMLStreamException {
        PomManipulator.overrideDependencyVersionWithComment(this.eventReader, d.getGroupId(), d.getArtifactId(), d.getVersionString(), newVersion);
    }

    static void overrideDependencyVersionWithComment(ModifiedPomXMLEventReader eventReader, String groupId, String artifactId, String oldVersionString, String newVersion) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        List<String> locations = Arrays.asList("/project/dependencyManagement/dependencies/dependency", "/project/dependencies/dependency");
        boolean matchingGroupId = false;
        boolean matchingArtifactId = false;
        boolean hasVersion = false;
        while (eventReader.hasNext()) {
            String elementName;
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                String parentElementPath = path;
                stack.push((String)path);
                elementName = event.asStartElement().getName().getLocalPart();
                path = (String)path + "/" + elementName;
                if (!locations.contains(parentElementPath)) continue;
                switch (elementName) {
                    case "groupId": {
                        matchingGroupId = groupId.equals(eventReader.getElementText().trim());
                        path = (String)stack.pop();
                        break;
                    }
                    case "artifactId": {
                        matchingArtifactId = artifactId.equals(eventReader.getElementText().trim());
                        path = (String)stack.pop();
                        break;
                    }
                    case "version": {
                        eventReader.mark(0);
                    }
                }
                continue;
            }
            if (!event.isEndElement()) continue;
            String parentPath = (String)stack.peek();
            elementName = event.asEndElement().getName().getLocalPart();
            if (locations.contains(parentPath) || locations.contains(path)) {
                switch (elementName) {
                    case "version": {
                        eventReader.mark(1);
                        String versionString = eventReader.getBetween(0, 1);
                        hasVersion = !versionString.trim().isEmpty();
                        break;
                    }
                    case "dependency": {
                        if (matchingGroupId && matchingArtifactId && hasVersion) {
                            eventReader.replaceMark(1, "</version> <!-- Original version: " + oldVersionString + " -->");
                            eventReader.replaceBetween(0, 1, newVersion);
                        }
                        matchingGroupId = false;
                        matchingArtifactId = false;
                        hasVersion = false;
                        eventReader.clearMark(0);
                        eventReader.clearMark(1);
                    }
                }
            }
            path = (String)stack.pop();
        }
    }

    public boolean overrideProperty(String propertyName, String propertyValue) throws XMLStreamException {
        return PomHelper.setPropertyVersion((ModifiedPomXMLEventReader)this.eventReader, null, (String)propertyName, (String)propertyValue);
    }

    public void injectManagedDependency(ArtifactRef dependency, Collection<ProjectRef> exclusions, String oldVersion) throws XMLStreamException {
        PomManipulator.injectDependencyManagementSection(this.eventReader);
        PomManipulator.injectDependencyManagementDependenciesSection(this.eventReader);
        PomManipulator.injectManagedDependency(this.eventReader, dependency, exclusions, oldVersion);
    }

    static void injectRepositoriesSection(ModifiedPomXMLEventReader eventReader) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                if (((String)path).equals("/project") && event.asStartElement().getName().getLocalPart().equals(REPOSITORIES)) {
                    return;
                }
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(PROJECT)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composeRepositoriesElementString() + "</project>");
                eventReader.clearMark(0);
                return;
            }
            path = (String)stack.pop();
        }
    }

    static void injectPluginRepositoriesSection(ModifiedPomXMLEventReader eventReader) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                if (((String)path).equals("/project") && event.asStartElement().getName().getLocalPart().equals(PLUGIN_REPOSITORIES)) {
                    return;
                }
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(PROJECT)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composePluginRepositoriesElementString() + "</project>");
                eventReader.clearMark(0);
                return;
            }
            path = (String)stack.pop();
        }
    }

    public void injectRepository(String id, String url) throws XMLStreamException {
        PomManipulator.injectRepository(this.eventReader, id, url);
    }

    public void injectPluginRepository(String id, String url) throws XMLStreamException {
        PomManipulator.injectPluginRepository(this.eventReader, id, url);
    }

    static void injectRepository(ModifiedPomXMLEventReader eventReader, String id, String url) throws XMLStreamException {
        PomManipulator.injectRepositoriesSection(eventReader);
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            String elementName = event.asEndElement().getName().getLocalPart();
            if (elementName.equals(REPOSITORIES) && ((String)path).equals(REPOSITORIES_PATH)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composeRepositoryElementString(id, url) + "    </repositories>");
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    static void injectPluginRepository(ModifiedPomXMLEventReader eventReader, String id, String url) throws XMLStreamException {
        PomManipulator.injectPluginRepositoriesSection(eventReader);
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            String elementName = event.asEndElement().getName().getLocalPart();
            if (elementName.equals(PLUGIN_REPOSITORIES) && ((String)path).equals(PLUGIN_REPOSITORIES_PATH)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composePluginRepositoryElementString(id, url) + "    </pluginRepositories>");
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    public void injectProperty(String key, String version) throws XMLStreamException {
        PomManipulator.injectProperty(this.eventReader, key, version);
    }

    public void writePom() {
        this.assertOpen();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)this.project.getPom());){
            this.closed = true;
            IOUtil.copy((String)this.content.toString(), (Writer)writer);
            this.eventReader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to the pom file", e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Couldn't close event reader", e);
        }
    }

    private void assertOpen() {
        Asserts.check((!this.closed ? 1 : 0) != 0, (String)"This instance cannot be used repeatedly.");
    }

    static void injectManagedDependency(ModifiedPomXMLEventReader eventReader, ArtifactRef dependency, Collection<ProjectRef> exclusions, String oldVersion) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(DEPENDENCIES) && ((String)path).equals(DEPENDENCY_MANAGEMENT_DEPENDENCIES_PATH)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composeDependencyElementString(dependency, exclusions, oldVersion) + "        </dependencies>");
                eventReader.clearMark(0);
                return;
            }
            path = (String)stack.pop();
        }
    }

    static void injectDependencyManagementSection(ModifiedPomXMLEventReader eventReader) throws XMLStreamException {
        eventReader.rewind();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                if (!event.asStartElement().getName().getLocalPart().equals(DEPENDENCY_MANAGEMENT)) continue;
                return;
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(PROJECT)) continue;
            eventReader.mark(0);
            eventReader.replaceMark(0, PomManipulator.composeDependencyManagementElementString() + "</project>");
            eventReader.clearMark(0);
            return;
        }
    }

    static void injectDependencyManagementDependenciesSection(ModifiedPomXMLEventReader eventReader) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                if (event.asStartElement().getName().getLocalPart().equals(DEPENDENCIES) && ((String)path).equals(DEPENDENCY_MANAGEMENT_PATH)) {
                    return;
                }
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals(DEPENDENCY_MANAGEMENT)) {
                eventReader.mark(0);
                eventReader.replaceMark(0, PomManipulator.composeDependenciesElementString() + "    </dependencyManagement>");
                eventReader.clearMark(0);
                return;
            }
            path = (String)stack.pop();
        }
    }

    static void injectProperty(ModifiedPomXMLEventReader eventReader, String key, String version) throws XMLStreamException {
        eventReader.rewind();
        Stack<String> stack = new Stack<String>();
        Object path = "";
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement()) {
                stack.push((String)path);
                path = (String)path + "/" + event.asStartElement().getName().getLocalPart();
                continue;
            }
            if (!event.isEndElement()) continue;
            if (event.asEndElement().getName().getLocalPart().equals("properties") && ((String)path).equals("/project/properties")) {
                eventReader.mark(0);
                eventReader.replaceMark(0, String.format("    <%s>%s</%s>\n", key, version, key) + "    </properties>");
                eventReader.clearMark(0);
                break;
            }
            path = (String)stack.pop();
        }
    }

    private static String composeDependencyManagementElementString() {
        return "    <dependencyManagement>\n    </dependencyManagement>\n";
    }

    private static String composeDependenciesElementString() {
        return "    <dependencies>\n        </dependencies>\n";
    }

    private static String composeRepositoriesElementString() {
        return "    <repositories>\n    </repositories>\n";
    }

    private static String composePluginRepositoriesElementString() {
        return "    <pluginRepositories>\n    </pluginRepositories>\n";
    }

    private static String composeDependencyElementString(ArtifactRef artifact, Collection<ProjectRef> exclusions, String oldVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append("    <dependency>\n");
        sb.append(String.format("                <groupId>%s</groupId>\n", artifact.getGroupId()));
        sb.append(String.format("                <artifactId>%s</artifactId>\n", artifact.getArtifactId()));
        sb.append(String.format("                <version>%s</version> <!-- Original version: %s -->\n", artifact.getVersionString(), oldVersion));
        if (artifact.getClassifier() != null) {
            sb.append(String.format("                <classifier>%s</classifier>\n", artifact.getClassifier()));
        }
        if (!"jar".equals(artifact.getType())) {
            sb.append(String.format("                <type>%s</type>\n", artifact.getType()));
        }
        if (exclusions != null && !exclusions.isEmpty()) {
            sb.append("                <exclusions>\n");
            for (ProjectRef e : exclusions) {
                sb.append("                    <exclusion>\n");
                sb.append("                        <groupId>" + e.getGroupId() + "</groupId>\n");
                sb.append("                        <artifactId>" + e.getArtifactId() + "</artifactId>\n");
                sb.append("                    </exclusion>\n");
            }
            sb.append("                </exclusions>\n");
        }
        sb.append("            </dependency>\n");
        return sb.toString();
    }

    private static String composeRepositoryElementString(String id, String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("    <repository>\n");
        sb.append(String.format("            <id>%s</id>\n", id));
        sb.append(String.format("            <url>%s</url>\n", url));
        sb.append("            <releases>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </releases>\n");
        sb.append("            <snapshots>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </snapshots>\n");
        sb.append("        </repository>\n");
        return sb.toString();
    }

    private static String composePluginRepositoryElementString(String id, String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("    <pluginRepository>\n");
        sb.append(String.format("            <id>%s</id>\n", id));
        sb.append(String.format("            <url>%s</url>\n", url));
        sb.append("            <releases>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </releases>\n");
        sb.append("            <snapshots>\n");
        sb.append("                <enabled>true</enabled>\n");
        sb.append("                <updatePolicy>always</updatePolicy>\n");
        sb.append("            </snapshots>\n");
        sb.append("        </pluginRepository>\n");
        return sb.toString();
    }
}

