/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.channel.ChannelManifest;
import org.wildfly.channel.ChannelManifestMapper;
import org.wildfly.channel.ManifestRequirement;
import org.wildfly.channel.MavenCoordinate;

@Mojo(name="edit-manifest", requiresProject=false, requiresDirectInvocation=true, requiresDependencyResolution=ResolutionScope.NONE, defaultPhase=LifecyclePhase.PACKAGE)
public class EditManifestMojo
extends AbstractMojo {
    @Parameter(name="manifestPath", property="manifestPath", required=true)
    private String manifestPath;
    @Parameter(name="manifestName", property="manifestName")
    private String manifestName;
    @Parameter(name="manifestId", property="manifestId")
    private String manifestId;
    @Parameter(name="manifestDescription", property="manifestDescription")
    private String manifestDescription;
    @Parameter(name="manifestRequirements")
    private List<Requirement> manifestRequirements;
    @Parameter(name="manifestLogicalVersion")
    private String manifestLogicalVersion;

    public void execute() throws MojoExecutionException {
        ChannelManifest source;
        Path streamsManifestFile = Path.of(this.manifestPath, new String[0]);
        EditManifestMojo.verifyFileExists(streamsManifestFile);
        try {
            source = ChannelManifestMapper.from((URL)streamsManifestFile.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to read the source manifest", (Exception)e);
        }
        List requirements = this.manifestRequirements == null ? Collections.emptyList() : this.manifestRequirements.stream().map(r -> {
            MavenCoordinate mavenCoordinate;
            if (r.getGroupId() != null && r.getArtifactId() != null) {
                mavenCoordinate = new MavenCoordinate(r.getGroupId(), r.getArtifactId(), r.getVersion());
            } else {
                if (r.getGroupId() != null || r.getArtifactId() != null || r.getVersion() != null) {
                    throw new IllegalArgumentException("When using a requirement maven coordinate both groupId and artifactId needs to be set");
                }
                mavenCoordinate = null;
            }
            return new ManifestRequirement(r.getId(), mavenCoordinate);
        }).collect(Collectors.toList());
        ChannelManifest combinedManifest = new ChannelManifest(source.getSchemaVersion(), this.manifestName, this.manifestId, this.manifestLogicalVersion, this.manifestDescription, requirements, source.getStreams());
        try {
            Files.writeString(streamsManifestFile, (CharSequence)ChannelManifestMapper.toYaml((ChannelManifest)combinedManifest), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write to a manifest file", (Exception)e);
        }
    }

    private static void verifyFileExists(Path metadataTemplate) {
        if (!metadataTemplate.toFile().exists()) {
            throw new IllegalArgumentException(String.format("The manifest file [%s] cannot be found.", metadataTemplate));
        }
    }

    public static class Requirement {
        @Parameter(name="id")
        private String id;
        @Parameter(name="groupId")
        private String groupId;
        @Parameter(name="artifactId")
        private String artifactId;
        @Parameter(name="version")
        private String version;

        public String getId() {
            return this.id;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

