/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channelplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.wildfly.channel.NoStreamFoundException;
import org.wildfly.channel.Repository;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.VersionResult;
import org.wildfly.channelplugin.AbstractChannelMojo;
import org.wildfly.channelplugin.ChannelPluginLogger;
import org.wildfly.channelplugin.ExternalProperty;
import org.wildfly.channelplugin.InjectRepositoriesMojo;
import org.wildfly.channelplugin.MojoConfigurator;
import org.wildfly.channelplugin.PropertyRef;
import org.wildfly.channelplugin.manipulation.PomManipulator;
import org.wildfly.channelplugin.utils.PMEUtils;
import org.wildfly.channelplugin.utils.VersionComparator;
import org.wildfly.channeltools.util.ConversionUtils;
import org.wildfly.channeltools.util.VersionUtils;

@org.apache.maven.plugins.annotations.Mojo(name="upgrade", requiresDirectInvocation=true)
public class UpgradeComponentsMojo
extends AbstractChannelMojo {
    private static final Comparator<String> VERSION_COMPARATOR = new VersionComparator();
    @Parameter(property="ignoreStreams")
    List<String> ignoreStreams;
    @Parameter(property="dontIgnoreStreams")
    List<String> dontIgnoreStreams;
    @Parameter(property="ignoreModules")
    List<String> ignoreModules;
    @Parameter(property="ignoreProperties")
    List<String> ignoreProperties;
    @Parameter(property="ignorePropertiesPrefixedWith")
    List<String> ignorePropertiesPrefixedWith;
    @Parameter(property="overrideProperties")
    List<String> overrideProperties;
    @Parameter(property="overrideDependencies")
    List<String> overrideDependencies;
    @Parameter(property="inlineUpgradedVersions", defaultValue="false")
    boolean inlineUpgradedVersions;
    @Parameter(property="injectTransitiveDependencies", defaultValue="true")
    boolean injectTransitiveDependencies;
    @Parameter(property="ignoreScopes", defaultValue="test")
    Set<String> ignoreScopes = new HashSet<String>();
    @Parameter(property="injectExternalProperties", defaultValue="true")
    boolean injectExternalProperties;
    @Parameter(property="injectRepositories", defaultValue="true")
    boolean injectRepositories;
    @Parameter(property="doNotDowngrade", defaultValue="false")
    boolean doNotDowngrade;
    @Inject
    DependencyGraphBuilder dependencyGraphBuilder;
    @Inject
    ManipulationSession manipulationSession;
    private final Set<ProjectRef> ignoredStreams = new HashSet<ProjectRef>();
    private final Set<ProjectRef> unignoredStreams = new HashSet<ProjectRef>();
    private Set<ProjectVersionRef> projectGavs;
    private final Map<ProjectRef, PomManipulator> manipulators = new HashMap<ProjectRef, PomManipulator>();
    private PomManipulator rootManipulator;
    private final Map<PropertyRef, String> lockedProperties = new HashMap<PropertyRef, String>();
    private final Set<ProjectRef> declaredDependencies = new HashSet<ProjectRef>();
    private final Set<String> overriddenProperties = new HashSet<String>();
    private final Set<Dependency> overriddenDependencies = new HashSet<Dependency>();
    private boolean allModulesProcessed = false;

    private void init() throws MojoExecutionException {
        MojoConfigurator.applyExternalConfiguration((Mojo)this, this.mavenSession);
        this.initChannelSession();
        this.ignoreStreams.forEach(ga -> this.ignoredStreams.add(SimpleProjectRef.parse((String)ga)));
        this.dontIgnoreStreams.forEach(ga -> this.unignoredStreams.add(SimpleProjectRef.parse((String)ga)));
    }

    public void execute() throws MojoExecutionException {
        if (!this.mavenSession.getCurrentProject().isExecutionRoot()) {
            return;
        }
        this.init();
        try {
            List<Project> pmeProjects = PMEUtils.parsePmeProjects(this.pomIO, this.mavenProject);
            this.projectGavs = pmeProjects.stream().map(p -> new SimpleProjectVersionRef(p.getGroupId(), p.getArtifactId(), p.getVersion())).collect(Collectors.toSet());
            for (Project project : pmeProjects) {
                if (this.isIgnoredModule(project.getGroupId(), project.getArtifactId())) {
                    this.getLog().info((CharSequence)String.format("Skipping module %s:%s", project.getGroupId(), project.getArtifactId()));
                    continue;
                }
                this.getLog().info((CharSequence)String.format("Processing module %s:%s", project.getGroupId(), project.getArtifactId()));
                PomManipulator manipulator = new PomManipulator(project);
                this.manipulators.put((ProjectRef)new SimpleProjectRef(project.getGroupId(), project.getArtifactId()), manipulator);
                this.processModule(project, manipulator);
            }
            this.allModulesProcessed = true;
            Project rootProject = PMEUtils.findRootProject(pmeProjects);
            this.rootManipulator = this.manipulators.get(new SimpleProjectRef(rootProject.getGroupId(), rootProject.getArtifactId()));
            if (this.injectTransitiveDependencies) {
                this.injectTransitiveDependencies();
            }
            if (this.injectRepositories) {
                Map<String, String> repositoriesToInject = this.channels.stream().flatMap(c -> c.getRepositories().stream()).distinct().collect(Collectors.toMap(Repository::getId, Repository::getUrl));
                InjectRepositoriesMojo.insertRepositories(rootProject, this.rootManipulator, repositoriesToInject);
            }
            for (PomManipulator manipulator : this.manipulators.values()) {
                manipulator.writePom();
            }
        }
        catch (XMLStreamException | ManipulationException e) {
            throw new MojoExecutionException("Project parsing failed", (Exception)e);
        }
    }

    private void processModule(Project pmeProject, PomManipulator manipulator) throws ManipulationException, XMLStreamException {
        Map<ArtifactRef, Dependency> resolvedProjectDependencies = this.collectResolvedProjectDependencies(pmeProject);
        resolvedProjectDependencies.keySet().forEach(a -> this.declaredDependencies.add(a.asProjectRef()));
        this.performHardPropertyOverrides(manipulator);
        this.performHardDependencyOverrides(resolvedProjectDependencies, manipulator);
        this.processDependencies(manipulator, pmeProject, resolvedProjectDependencies);
    }

    private void processDependencies(PomManipulator manipulator, Project pmeProject, Map<ArtifactRef, Dependency> resolvedProjectDependencies) throws XMLStreamException {
        for (Map.Entry<ArtifactRef, Dependency> entry : resolvedProjectDependencies.entrySet()) {
            Dependency dependency = entry.getValue();
            ArtifactRef originalArtifact = entry.getKey();
            String originalVersion = originalArtifact.getVersionString().trim();
            Optional<String> channelVersionOpt = this.resolveDependencyVersionFromChannel(originalArtifact);
            if (channelVersionOpt.isEmpty()) continue;
            String channelVersion = channelVersionOpt.get();
            Objects.requireNonNull(originalArtifact);
            Objects.requireNonNull(dependency);
            if (this.isIgnoredDependency(originalArtifact, dependency)) continue;
            if (VersionUtils.isProperty((String)dependency.getVersion()) && !this.inlineUpgradedVersions) {
                this.processDependencyWithVersionProperty(pmeProject, manipulator, dependency, originalVersion, channelVersion);
                continue;
            }
            if (!this.shouldUpgrade(originalVersion, channelVersion)) continue;
            manipulator.overrideDependencyVersionWithComment(originalArtifact, channelVersion);
        }
    }

    private void processDependencyWithVersionProperty(Project pmeProject, PomManipulator manipulator, Dependency dependency, String originalVersion, String newVersion) throws XMLStreamException {
        String originalVersionString = dependency.getVersion();
        String versionPropertyName = VersionUtils.extractPropertyName((String)originalVersionString);
        PropertyRef mavenPropertyRef = this.lookupMavenProperty(pmeProject, versionPropertyName);
        if (mavenPropertyRef == null) {
            ChannelPluginLogger.LOGGER.errorf("Unable to upgrade %s:%s:%s to '%s', can't locate property '%s' in the project", new Object[]{dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), newVersion, versionPropertyName});
            return;
        }
        String targetPropertyName = mavenPropertyRef.getPropertyName();
        if (this.isIgnoredProperty(targetPropertyName)) {
            this.getLog().info((CharSequence)String.format("Ignoring property '%s'", targetPropertyName));
            return;
        }
        if (!this.lockedProperties.containsKey(mavenPropertyRef)) {
            this.lockedProperties.put(mavenPropertyRef, newVersion);
            if (this.shouldUpgrade(originalVersion, newVersion)) {
                this.updateVersionProperty(pmeProject, dependency, mavenPropertyRef, newVersion);
            }
        } else if (!newVersion.equals(this.lockedProperties.get(mavenPropertyRef))) {
            manipulator.overrideDependencyVersion(dependency.getGroupId(), dependency.getArtifactId(), originalVersionString, newVersion);
        }
    }

    private void updateVersionProperty(Project pmeProject, Dependency dependency, PropertyRef mavenPropertyRef, String newVersion) throws XMLStreamException {
        Project targetProject = mavenPropertyRef.getModule();
        String targetPropertyName = mavenPropertyRef.getPropertyName();
        if (targetProject != null) {
            PomManipulator targetManipulator = this.manipulators.get(new SimpleProjectRef(targetProject.getGroupId(), targetProject.getArtifactId()));
            targetManipulator.overrideProperty(targetPropertyName, newVersion);
        } else if (this.injectExternalProperties) {
            PomManipulator targetManipulator = this.manipulators.get(new SimpleProjectRef(pmeProject.getGroupId(), pmeProject.getArtifactId()));
            targetManipulator.injectProperty(targetPropertyName, newVersion);
        } else {
            this.getLog().warn((CharSequence)String.format("Can't upgrade %s:%s:%s to %s, property %s is not defined in the scope of the project (consider enabling the injectExternalProperties parameter).", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), newVersion, targetPropertyName));
        }
    }

    private PropertyRef lookupMavenProperty(Project pmeProject, String propertyName) {
        ExternalProperty externalProperty;
        PropertyRef mavenPropertyRef = UpgradeComponentsMojo.followProperties(pmeProject, propertyName);
        if (mavenPropertyRef == null && (externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, propertyName)) != null) {
            mavenPropertyRef = new PropertyRef(null, externalProperty.getName());
        }
        return mavenPropertyRef;
    }

    private void performHardPropertyOverrides(PomManipulator manipulator) throws XMLStreamException {
        for (String nameValue : this.overrideProperties) {
            String[] split = nameValue.split("=");
            if (split.length != 2) {
                this.getLog().error((CharSequence)String.format("Can't interpret property to override settings: '%s'", nameValue));
                continue;
            }
            String propertyName = split[0];
            String propertyValue = split[1];
            if (!manipulator.overrideProperty(propertyName, propertyValue)) continue;
            this.getLog().info((CharSequence)String.format("Property '%s' overridden to '%s'", propertyName, propertyValue));
            this.overriddenProperties.add(propertyName);
        }
    }

    private void performHardDependencyOverrides(Map<ArtifactRef, Dependency> resolvedProjectDependencies, PomManipulator manipulator) throws XMLStreamException {
        for (Dependency dependency : resolvedProjectDependencies.values()) {
            Optional<String> overriddenVersion = this.findOverriddenVersion(dependency);
            if (!overriddenVersion.isPresent()) continue;
            manipulator.overrideDependencyVersion(ConversionUtils.toArtifactRef((Dependency)dependency), overriddenVersion.get());
            this.overriddenDependencies.add(dependency);
        }
    }

    private Optional<String> findOverriddenVersion(Dependency dependency) {
        for (String gav : this.overrideDependencies) {
            String[] split = gav.split(":");
            if (split.length != 3) continue;
            String g = split[0];
            String a = split[1];
            String v = split[2];
            if (!dependency.getGroupId().equals(g) || !dependency.getArtifactId().equals(a)) continue;
            return Optional.of(v);
        }
        return Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isIgnoredProperty(String propertyName) {
        if (this.ignoreProperties.contains(propertyName)) return true;
        if (this.ignorePropertiesPrefixedWith.stream().anyMatch(propertyName::startsWith)) return true;
        if (!this.overriddenProperties.contains(propertyName)) return false;
        return true;
    }

    private Map<ArtifactRef, Dependency> collectResolvedProjectDependencies(Project pmeProject) throws ManipulationException {
        HashMap<ArtifactRef, Dependency> projectDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.putAll(pmeProject.getResolvedManagedDependencies((MavenSessionHandler)this.manipulationSession));
        projectDependencies.putAll(pmeProject.getResolvedDependencies((MavenSessionHandler)this.manipulationSession));
        if (projectDependencies.isEmpty()) {
            this.getLog().debug((CharSequence)("No dependencies found in " + pmeProject.getArtifactId()));
        }
        HashMap<ArtifactRef, Dependency> correctedDependencies = new HashMap<ArtifactRef, Dependency>();
        projectDependencies.forEach((artifact, dependency) -> {
            if (VersionUtils.isProperty((String)artifact.getVersionString())) {
                ExternalProperty externalProperty = UpgradeComponentsMojo.resolveExternalProperty(this.mavenProject, VersionUtils.extractPropertyName((String)artifact.getVersionString()));
                if (externalProperty != null) {
                    SimpleArtifactRef newArtifact = new SimpleArtifactRef(artifact.getGroupId(), artifact.getArtifactId(), externalProperty.getValue(), artifact.getType(), artifact.getClassifier());
                    correctedDependencies.put((ArtifactRef)newArtifact, (Dependency)dependency);
                } else {
                    this.getLog().error((CharSequence)("Following dependency uses a version property that could not be resolved: " + dependency.toString()));
                }
            } else {
                correctedDependencies.put((ArtifactRef)artifact, (Dependency)dependency);
            }
        });
        return correctedDependencies;
    }

    private boolean isIgnoredDependency(ArtifactRef artifact, Dependency dependency) {
        if (this.projectGavs.contains(artifact.asProjectVersionRef())) {
            this.getLog().debug((CharSequence)("Ignoring in-project dependency: " + artifact.asProjectVersionRef().toString()));
            return true;
        }
        if (!this.unignoredStreams.contains(artifact.asProjectRef())) {
            if (this.ignoredStreams.contains(artifact.asProjectRef())) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifact.asProjectVersionRef().toString()));
                return true;
            }
            SimpleProjectRef wildCardIgnoredProjectRef = new SimpleProjectRef(artifact.getGroupId(), "*");
            if (this.ignoredStreams.contains(wildCardIgnoredProjectRef)) {
                this.getLog().info((CharSequence)("Skipping dependency (ignored stream): " + artifact.asProjectVersionRef().toString()));
                return true;
            }
        }
        if (this.ignoreScopes.contains(dependency.getScope())) {
            this.getLog().info((CharSequence)("Skipping dependency (ignored scope): " + artifact.asProjectVersionRef().toString()));
            return true;
        }
        if (this.overriddenDependencies.contains(dependency)) {
            return true;
        }
        if (artifact.getVersionString() == null) {
            this.getLog().error((CharSequence)("Resolved dependency has null version: " + artifact));
            return true;
        }
        return false;
    }

    private Optional<String> resolveDependencyVersionFromChannel(ArtifactRef artifactRef) {
        try {
            VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(artifactRef.getGroupId(), artifactRef.getArtifactId(), artifactRef.getType(), artifactRef.getClassifier(), artifactRef.getVersionString());
            return Optional.of(versionResult.getVersion());
        }
        catch (UnresolvedMavenArtifactException e) {
            this.getLog().debug((CharSequence)String.format("Artifact %s:%s is not resolvable by given channels.", artifactRef.getGroupId(), artifactRef.getArtifactId()));
            return Optional.empty();
        }
    }

    private void injectTransitiveDependencies() throws MojoExecutionException {
        if (!this.allModulesProcessed) {
            throw new IllegalStateException("The injectTransitiveDependencies() method has to be called after all project modules has been processed.");
        }
        Map<ArtifactRef, Collection<ProjectRef>> transitiveDependencies = this.findTransitiveDependencies();
        List orderedEntries = transitiveDependencies.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        for (Map.Entry entry : orderedEntries) {
            String newVersion;
            ArtifactRef artifact = (ArtifactRef)entry.getKey();
            Collection exclusions = (Collection)entry.getValue();
            try {
                VersionResult versionResult = this.channelSession.findLatestMavenArtifactVersion(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersionString());
                newVersion = versionResult.getVersion();
            }
            catch (NoStreamFoundException e) {
                continue;
            }
            if (!this.shouldUpgrade(artifact.getVersionString(), newVersion)) continue;
            SimpleArtifactRef newDependency = new SimpleArtifactRef(artifact.getGroupId(), artifact.getArtifactId(), newVersion, artifact.getType(), artifact.getClassifier());
            this.getLog().info((CharSequence)String.format("Injecting undeclared dependency: %s (original version was %s)", newDependency, artifact.getVersionString()));
            try {
                this.rootManipulator.injectManagedDependency((ArtifactRef)newDependency, exclusions, artifact.getVersionString());
            }
            catch (XMLStreamException e) {
                throw new MojoExecutionException("Failed to inject a managed dependency", (Exception)e);
            }
        }
    }

    private Map<ArtifactRef, Collection<ProjectRef>> findTransitiveDependencies() throws MojoExecutionException {
        List projectGAs = this.projectGavs.stream().map(ProjectRef::asProjectRef).collect(Collectors.toList());
        HashMap<ArtifactRef, Collection<ProjectRef>> transitiveDependencies = new HashMap<ArtifactRef, Collection<ProjectRef>>();
        HashMap uniqueGaMap = new HashMap();
        ArrayList<Object> projects = new ArrayList<Object>();
        projects.add(this.mavenProject);
        List collectedProjects = this.mavenProject.getCollectedProjects().stream().filter(p -> !this.isIgnoredModule(p.getGroupId(), p.getArtifactId())).collect(Collectors.toList());
        projects.addAll(collectedProjects);
        for (MavenProject mavenProject : projects) {
            DependencyNode rootNode;
            Map<ArtifactRef, List<ProjectRef>> artifactExclusions = UpgradeComponentsMojo.getDependencyExclusions(mavenProject);
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
            buildingRequest.setProject(mavenProject);
            try {
                rootNode = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildingRequest, null);
            }
            catch (DependencyGraphBuilderException e) {
                throw new MojoExecutionException("Failed to compose dependency graph.");
            }
            CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
            rootNode.accept((DependencyNodeVisitor)visitor);
            visitor.getNodes().forEach(node -> {
                ArtifactRef artifact = ConversionUtils.toArtifactRef((Artifact)node.getArtifact());
                if (projectGAs.contains(artifact.asProjectRef())) {
                    return;
                }
                if (this.declaredDependencies.contains(artifact.asProjectRef())) {
                    return;
                }
                if (this.ignoreScopes.contains(node.getArtifact().getScope())) {
                    return;
                }
                boolean isIgnored = this.ignoredStreams.contains(artifact.asProjectRef()) || this.ignoredStreams.contains(new SimpleProjectRef(artifact.getGroupId(), "*"));
                boolean isUnignored = this.unignoredStreams.contains(artifact.asProjectRef());
                if (isIgnored && !isUnignored) {
                    return;
                }
                List exclusions = artifactExclusions.getOrDefault(artifact, Collections.emptyList());
                HashSet exclusionsSet = new HashSet(exclusions);
                ArtifactRef existingArtifact = (ArtifactRef)uniqueGaMap.get(artifact.asProjectRef());
                if (existingArtifact == null || VERSION_COMPARATOR.compare(artifact.getVersionString(), existingArtifact.getVersionString()) > 0) {
                    uniqueGaMap.put(artifact.asProjectRef(), artifact);
                    transitiveDependencies.put(artifact, exclusionsSet);
                }
            });
        }
        return transitiveDependencies;
    }

    private static Map<ArtifactRef, List<ProjectRef>> getDependencyExclusions(MavenProject module) {
        HashMap<ArtifactRef, List<ProjectRef>> artifactExclusions = new HashMap<ArtifactRef, List<ProjectRef>>();
        List managedDependencies = Collections.emptyList();
        if (module.getModel().getDependencyManagement() != null) {
            managedDependencies = module.getModel().getDependencyManagement().getDependencies();
        }
        managedDependencies.forEach(dep -> artifactExclusions.put(ConversionUtils.toArtifactRef((Dependency)dep), ConversionUtils.toProjectRefs((List)dep.getExclusions())));
        return artifactExclusions;
    }

    private boolean isIgnoredModule(String groupId, String artifactId) {
        return this.ignoreModules.contains(groupId + ":" + artifactId) || groupId.equals(this.mavenProject.getGroupId()) && this.ignoreModules.contains(":" + artifactId);
    }

    static PropertyRef followProperties(Project pmeProject, String propertyName) {
        String newPropertyName;
        PropertyRef targetProperty;
        Properties properties = pmeProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            Project parentProject = pmeProject.getProjectParent();
            if (parentProject == null) {
                return null;
            }
            return UpgradeComponentsMojo.followProperties(parentProject, propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.followProperties(pmeProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return new PropertyRef(pmeProject, propertyName);
    }

    static ExternalProperty resolveExternalProperty(MavenProject mavenProject, String propertyName) {
        String newPropertyName;
        ExternalProperty targetProperty;
        if (mavenProject == null) {
            return null;
        }
        Properties properties = mavenProject.getModel().getProperties();
        if (!properties.containsKey(propertyName)) {
            return UpgradeComponentsMojo.resolveExternalProperty(mavenProject.getParent(), propertyName);
        }
        String propertyValue = (String)properties.get(propertyName);
        if (VersionUtils.isProperty((String)propertyValue) && (targetProperty = UpgradeComponentsMojo.resolveExternalProperty(mavenProject, newPropertyName = VersionUtils.extractPropertyName((String)propertyValue))) != null) {
            return targetProperty;
        }
        return new ExternalProperty(propertyName, propertyValue);
    }

    private boolean shouldUpgrade(String originalVersion, String newVersion) {
        int compare = VERSION_COMPARATOR.compare(newVersion.trim(), originalVersion.trim());
        return compare > 0 || !this.doNotDowngrade && compare < 0;
    }
}

