/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import org.hornetq.api.core.Pair;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.TopologyMember;
import org.hornetq.spi.core.protocol.RemotingConnection;

public final class TopologyMemberImpl
implements TopologyMember {
    private static final long serialVersionUID = 1123652191795626133L;
    private final Pair<TransportConfiguration, TransportConfiguration> connector;
    private final String nodeName;
    private transient long uniqueEventID = System.currentTimeMillis();
    private final String nodeId;

    public TopologyMemberImpl(String nodeId, String nodeName, TransportConfiguration a, TransportConfiguration b) {
        this.nodeId = nodeId;
        this.nodeName = nodeName;
        this.connector = new Pair<TransportConfiguration, TransportConfiguration>(a, b);
        this.uniqueEventID = System.currentTimeMillis();
    }

    @Override
    public TransportConfiguration getLive() {
        return this.connector.getA();
    }

    @Override
    public TransportConfiguration getBackup() {
        return this.connector.getB();
    }

    public void setBackup(TransportConfiguration param) {
        this.connector.setB(param);
    }

    public void setLive(TransportConfiguration param) {
        this.connector.setA(param);
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public long getUniqueEventID() {
        return this.uniqueEventID;
    }

    @Override
    public String getBackupGroupName() {
        return this.nodeName;
    }

    public void setUniqueEventID(long uniqueEventID) {
        this.uniqueEventID = uniqueEventID;
    }

    public Pair<TransportConfiguration, TransportConfiguration> getConnector() {
        return this.connector;
    }

    @Override
    public boolean isMember(RemotingConnection connection) {
        TransportConfiguration connectorConfig = connection.getTransportConnection() != null ? connection.getTransportConnection().getConnectorConfig() : null;
        return this.isMember(connectorConfig);
    }

    @Override
    public boolean isMember(TransportConfiguration configuration) {
        return this.getConnector().getA() != null && this.getConnector().getA().equals(configuration) || this.getConnector().getB() != null && this.getConnector().getB().equals(configuration);
    }

    public String toString() {
        return "TopologyMember[name = " + this.nodeName + ", connector=" + this.connector + "]";
    }
}

