/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    public ObjectInputStreamWithClassLoader(InputStream in) throws IOException {
        super(in);
    }

    protected Class resolveClass(final ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return this.resolveClass0(desc);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return ObjectInputStreamWithClassLoader.this.resolveClass0(desc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    protected Class resolveProxyClass(final String[] interfaces) throws IOException, ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return this.resolveProxyClass0(interfaces);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                @Override
                public Class run() throws Exception {
                    return ObjectInputStreamWithClassLoader.this.resolveProxyClass0(interfaces);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw this.unwrapException(e);
        }
    }

    private Class resolveClass0(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(name, false, loader);
            if (clazz == null) {
                return super.resolveClass(desc);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }

    private Class resolveProxyClass0(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private RuntimeException unwrapException(PrivilegedActionException e) throws IOException, ClassNotFoundException {
        Throwable c = e.getCause();
        if (c instanceof IOException) {
            throw (IOException)c;
        }
        if (c instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)c;
        }
        if (c instanceof RuntimeException) {
            throw (RuntimeException)c;
        }
        if (c instanceof Error) {
            throw (Error)c;
        }
        throw new RuntimeException(c);
    }
}

