/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.security;

import java.io.Serializable;

public class Role
implements Serializable {
    private static final long serialVersionUID = 3560097227776448872L;
    private final String name;
    private final boolean send;
    private final boolean consume;
    private final boolean createDurableQueue;
    private final boolean deleteDurableQueue;
    private final boolean createNonDurableQueue;
    private final boolean deleteNonDurableQueue;
    private final boolean manage;

    public Role(String name, boolean send, boolean consume, boolean createDurableQueue, boolean deleteDurableQueue, boolean createNonDurableQueue, boolean deleteNonDurableQueue, boolean manage) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        this.name = name;
        this.send = send;
        this.consume = consume;
        this.createDurableQueue = createDurableQueue;
        this.deleteDurableQueue = deleteDurableQueue;
        this.createNonDurableQueue = createNonDurableQueue;
        this.deleteNonDurableQueue = deleteNonDurableQueue;
        this.manage = manage;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSend() {
        return this.send;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public boolean isCreateDurableQueue() {
        return this.createDurableQueue;
    }

    public boolean isDeleteDurableQueue() {
        return this.deleteDurableQueue;
    }

    public boolean isCreateNonDurableQueue() {
        return this.createNonDurableQueue;
    }

    public boolean isDeleteNonDurableQueue() {
        return this.deleteNonDurableQueue;
    }

    public String toString() {
        StringBuffer stringReturn = new StringBuffer("Role {name=" + this.name + "; allows=[");
        if (this.send) {
            stringReturn.append(" send ");
        }
        if (this.consume) {
            stringReturn.append(" consume ");
        }
        if (this.createDurableQueue) {
            stringReturn.append(" createDurableQueue ");
        }
        if (this.deleteDurableQueue) {
            stringReturn.append(" deleteDurableQueue ");
        }
        if (this.createNonDurableQueue) {
            stringReturn.append(" createNonDurableQueue ");
        }
        if (this.deleteNonDurableQueue) {
            stringReturn.append(" deleteNonDurableQueue ");
        }
        stringReturn.append("]}");
        return stringReturn.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        if (this.consume != role.consume) {
            return false;
        }
        if (this.createDurableQueue != role.createDurableQueue) {
            return false;
        }
        if (this.createNonDurableQueue != role.createNonDurableQueue) {
            return false;
        }
        if (this.deleteDurableQueue != role.deleteDurableQueue) {
            return false;
        }
        if (this.deleteNonDurableQueue != role.deleteNonDurableQueue) {
            return false;
        }
        if (this.send != role.send) {
            return false;
        }
        return this.name.equals(role.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.send ? 1 : 0);
        result = 31 * result + (this.consume ? 1 : 0);
        result = 31 * result + (this.createDurableQueue ? 1 : 0);
        result = 31 * result + (this.deleteDurableQueue ? 1 : 0);
        result = 31 * result + (this.createNonDurableQueue ? 1 : 0);
        result = 31 * result + (this.deleteNonDurableQueue ? 1 : 0);
        return result;
    }

    public boolean isManage() {
        return this.manage;
    }
}

