/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.List;
import java.util.Map;
import org.jgroups.conf.PlainConfigurator;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

public class ConfiguratorFactory {
    public static final String JAXP_MISSING_ERROR_MSG = "the required XML parsing classes are not available; make sure that JAXP compatible libraries are in the classpath.";

    protected ConfiguratorFactory() {
    }

    public static ProtocolStackConfigurator getStackConfigurator(File file) throws Exception {
        ConfiguratorFactory.checkJAXPAvailability();
        InputStream input = ConfiguratorFactory.getConfigStream(file);
        return XmlConfigurator.getInstance(input);
    }

    public static ProtocolStackConfigurator getStackConfigurator(InputStream input) throws Exception {
        return XmlConfigurator.getInstance(input);
    }

    public static ProtocolStackConfigurator getStackConfigurator(URL url) throws Exception {
        ConfiguratorFactory.checkForNullConfiguration(url);
        ConfiguratorFactory.checkJAXPAvailability();
        return XmlConfigurator.getInstance(url);
    }

    public static ProtocolStackConfigurator getStackConfigurator(Element element) throws Exception {
        ConfiguratorFactory.checkForNullConfiguration(element);
        return XmlConfigurator.getInstance(element);
    }

    public static ProtocolStackConfigurator getStackConfigurator(String properties) throws Exception {
        if (properties == null) {
            properties = "udp.xml";
        }
        XmlConfigurator configurator = null;
        ConfiguratorFactory.checkForNullConfiguration(properties);
        configurator = ConfiguratorFactory.getXmlConfigurator(properties);
        if (configurator != null) {
            return configurator;
        }
        return new PlainConfigurator(properties);
    }

    public static InputStream getConfigStream(File file) throws Exception {
        ConfiguratorFactory.checkForNullConfiguration(file);
        return new FileInputStream(file);
    }

    public static InputStream getConfigStream(URL url) throws Exception {
        ConfiguratorFactory.checkJAXPAvailability();
        return url.openStream();
    }

    public static InputStream getConfigStream(String properties) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new FileInputStream(properties);
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (AccessControlException access_ex) {
            // empty catch block
        }
        if (configStream == null) {
            try {
                configStream = new URL(properties).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (configStream == null && properties.endsWith("xml")) {
            configStream = Util.getResourceAsStream(properties, ConfiguratorFactory.class);
        }
        return configStream;
    }

    public static InputStream getConfigStream(Object properties) throws IOException {
        InputStream input = null;
        if (properties == null) {
            properties = "udp.xml";
        }
        if (properties instanceof URL) {
            try {
                input = ((URL)properties).openStream();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (input == null && properties instanceof String) {
            input = ConfiguratorFactory.getConfigStream((String)properties);
        }
        if (input == null && properties instanceof File) {
            try {
                input = new FileInputStream((File)properties);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (input != null) {
            return input;
        }
        if (properties instanceof Element) {
            return ConfiguratorFactory.getConfigStream(properties);
        }
        return new ByteArrayInputStream(((String)properties).getBytes());
    }

    static XmlConfigurator getXmlConfigurator(String properties) throws IOException {
        XmlConfigurator returnValue = null;
        InputStream configStream = ConfiguratorFactory.getConfigStream(properties);
        if (configStream == null && properties.endsWith("xml")) {
            throw new FileNotFoundException(String.format(Util.getMessage("FileNotFound"), properties));
        }
        if (configStream != null) {
            ConfiguratorFactory.checkJAXPAvailability();
            returnValue = XmlConfigurator.getInstance(configStream);
        }
        return returnValue;
    }

    static void checkForNullConfiguration(Object properties) {
        if (properties == null) {
            throw new NullPointerException("the specifed protocol stack configuration was null");
        }
    }

    static void checkJAXPAvailability() {
        try {
            XmlConfigurator.class.getName();
        }
        catch (NoClassDefFoundError error) {
            NoClassDefFoundError tmp = new NoClassDefFoundError(JAXP_MISSING_ERROR_MSG);
            tmp.initCause(error);
            throw tmp;
        }
    }

    public static void substituteVariables(ProtocolStackConfigurator configurator) {
        List<ProtocolConfiguration> protocols = configurator.getProtocolStack();
        for (ProtocolConfiguration data : protocols) {
            if (data == null) continue;
            Map<String, String> parms = data.getProperties();
            for (Map.Entry<String, String> entry : parms.entrySet()) {
                String val = entry.getValue();
                String replacement = Util.substituteVariable(val);
                if (replacement.equals(val)) continue;
                entry.setValue(replacement);
            }
        }
    }
}

