package org.jgroups.tests;

import org.jgroups.TimeoutException;
import org.jgroups.util.Util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla4 {

    public static void main(String[] args) {
        final boolean[] hasResult = {false};
        long timeout = 1000;
        final Lock lock = new ReentrantLock();
        final java.util.concurrent.locks.Condition cond = lock.newCondition();

        Thread signaller=new Thread() {
            public void run() {
                Util.sleep(3000);
                lock.lock();
                try {
                    hasResult[0]=true;
                    cond.signalAll();
                }
                finally {
                    lock.unlock();
                }
            }
        };
        signaller.setDaemon(true);
        signaller.start();

        long wait_time= TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        final long target_time= adjustedNanoTime() + wait_time;
        while(wait_time > 0 && !hasResult[0]) { /* Wait for responses: */
        // while(adjustedNanoTime() < target_time && !hasResult[0]) { /* Wait for responses: */
            long nanos=adjustedNanoTime();
            wait_time=target_time - nanos;
            System.out.println("wait_time = " + wait_time);
            if(wait_time > 0) {
                try {
                    cond.await(wait_time, TimeUnit.NANOSECONDS);}
                catch(Exception e) {}
            }
        }
        if(!hasResult[0] && wait_time <= 0)
            throw new TimeoutException();
    }



    protected static long adjustedNanoTime() {
        return System.nanoTime() + Long.MIN_VALUE;
    }


}


