/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class CreateQueueMessage
extends PacketImpl {
    private SimpleString address;
    private SimpleString queueName;
    private SimpleString filterString;
    private boolean durable;
    private boolean temporary;
    private boolean requiresResponse;

    public CreateQueueMessage(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean temporary, boolean requiresResponse) {
        this();
        this.address = address;
        this.queueName = queueName;
        this.filterString = filterString;
        this.durable = durable;
        this.temporary = temporary;
        this.requiresResponse = requiresResponse;
    }

    public CreateQueueMessage() {
        super((byte)34);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", address=" + this.address);
        buff.append(", queueName=" + this.queueName);
        buff.append(", filterString=" + this.filterString);
        buff.append(", durable=" + this.durable);
        buff.append(", temporary=" + this.temporary);
        buff.append("]");
        return buff.toString();
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    public SimpleString getFilterString() {
        return this.filterString;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public void setAddress(SimpleString address) {
        this.address = address;
    }

    public void setQueueName(SimpleString queueName) {
        this.queueName = queueName;
    }

    public void setFilterString(SimpleString filterString) {
        this.filterString = filterString;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeSimpleString(this.address);
        buffer.writeSimpleString(this.queueName);
        buffer.writeNullableSimpleString(this.filterString);
        buffer.writeBoolean(this.durable);
        buffer.writeBoolean(this.temporary);
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.address = buffer.readSimpleString();
        this.queueName = buffer.readSimpleString();
        this.filterString = buffer.readNullableSimpleString();
        this.durable = buffer.readBoolean();
        this.temporary = buffer.readBoolean();
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.durable ? 1231 : 1237);
        result = 31 * result + (this.filterString == null ? 0 : this.filterString.hashCode());
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        result = 31 * result + (this.temporary ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CreateQueueMessage)) {
            return false;
        }
        CreateQueueMessage other = (CreateQueueMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.durable != other.durable) {
            return false;
        }
        if (this.filterString == null ? other.filterString != null : !this.filterString.equals(other.filterString)) {
            return false;
        }
        if (this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName)) {
            return false;
        }
        if (this.requiresResponse != other.requiresResponse) {
            return false;
        }
        return this.temporary == other.temporary;
    }
}

