/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.utils.HornetQThreadFactory;

public class SharedNioEventLoopGroup
extends NioEventLoopGroup {
    private static SharedNioEventLoopGroup instance;
    private final AtomicReference<ScheduledFuture<?>> shutdown = new AtomicReference();
    private final AtomicLong nioChannelFactoryCount = new AtomicLong();
    private final Promise<?> terminationPromise = ImmediateEventExecutor.INSTANCE.newPromise();

    private SharedNioEventLoopGroup(int numThreads, ThreadFactory factory) {
        super(numThreads, factory);
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }

    public static synchronized void forceShutdown() {
        if (instance != null) {
            instance.shutdown();
            SharedNioEventLoopGroup.instance.nioChannelFactoryCount.set(0L);
            instance = null;
        }
    }

    public static synchronized SharedNioEventLoopGroup getInstance(int numThreads) {
        if (instance != null) {
            ScheduledFuture f = SharedNioEventLoopGroup.instance.shutdown.getAndSet(null);
            if (f != null) {
                f.cancel(false);
            }
        } else {
            instance = new SharedNioEventLoopGroup(numThreads, new HornetQThreadFactory("HornetQ-client-netty-threads", true, SharedNioEventLoopGroup.getThisClassLoader()));
        }
        SharedNioEventLoopGroup.instance.nioChannelFactoryCount.incrementAndGet();
        return instance;
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationPromise;
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.shutdownGracefully(100L, 3000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> shutdownGracefully(final long l, final long l2, final TimeUnit timeUnit) {
        if (this.nioChannelFactoryCount.decrementAndGet() == 0L) {
            this.shutdown.compareAndSet(null, this.next().scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<SharedNioEventLoopGroup> clazz = SharedNioEventLoopGroup.class;
                    synchronized (SharedNioEventLoopGroup.class) {
                        if (SharedNioEventLoopGroup.this.shutdown.get() != null) {
                            Future future = SharedNioEventLoopGroup.super.shutdownGracefully(l, l2, timeUnit);
                            future.addListener(new FutureListener<Object>(){

                                @Override
                                public void operationComplete(Future future) throws Exception {
                                    if (future.isSuccess()) {
                                        SharedNioEventLoopGroup.this.terminationPromise.setSuccess(null);
                                    } else {
                                        SharedNioEventLoopGroup.this.terminationPromise.setFailure(future.cause());
                                    }
                                }
                            });
                            instance = null;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            }, 10L, 10L, TimeUnit.SECONDS));
        }
        return this.terminationPromise;
    }
}

