/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.handler.ssl.SslHandler;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.PartialPooledByteBufAllocator;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ConcurrentHashSet;
import org.apache.activemq.artemis.utils.IPV6Util;

public class NettyConnection
implements Connection {
    private static final int BATCHING_BUFFER_SIZE = 8192;
    protected final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;
    private final boolean batchingEnabled;
    private final boolean directDeliver;
    private volatile ActiveMQBuffer batchBuffer;
    private final Map<String, Object> configuration;
    private final Semaphore writeLock = new Semaphore(1);
    private final Set<ReadyListener> readyListeners = new ConcurrentHashSet<ReadyListener>();
    private RemotingConnection protocolConnection;

    public NettyConnection(Map<String, Object> configuration, Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver) {
        this.configuration = configuration;
        this.channel = channel;
        this.listener = listener;
        this.batchingEnabled = batchingEnabled;
        this.directDeliver = directDeliver;
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    @Override
    public void forceClose() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Throwable e) {
                ActiveMQClientLogger.LOGGER.warn(e.getMessage(), e);
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public RemotingConnection getProtocolConnection() {
        return this.protocolConnection;
    }

    @Override
    public void setProtocolConnection(RemotingConnection protocolConnection) {
        this.protocolConnection = protocolConnection;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        final SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
        EventLoop eventLoop = this.channel.eventLoop();
        boolean inEventLoop = eventLoop.inEventLoop();
        if (!inEventLoop) {
            this.closeSSLAndChannel(sslHandler, this.channel);
        } else {
            eventLoop.execute(new Runnable(){

                @Override
                public void run() {
                    NettyConnection.this.closeSSLAndChannel(sslHandler, NettyConnection.this.channel);
                }
            });
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    @Override
    public ActiveMQBuffer createTransportBuffer(int size) {
        return new ChannelBufferWrapper(PartialPooledByteBufAllocator.INSTANCE.directBuffer(size), true);
    }

    @Override
    public Object getID() {
        return this.channel.hashCode();
    }

    @Override
    public void checkFlushBatchBuffer() {
        if (!this.batchingEnabled) {
            return;
        }
        if (this.writeLock.tryAcquire()) {
            try {
                if (this.batchBuffer != null && this.batchBuffer.readable()) {
                    this.channel.writeAndFlush(this.batchBuffer.byteBuf());
                    this.batchBuffer = this.createTransportBuffer(8192);
                }
            }
            finally {
                this.writeLock.release();
            }
        }
    }

    @Override
    public void write(ActiveMQBuffer buffer) {
        this.write(buffer, false, false);
    }

    @Override
    public void write(ActiveMQBuffer buffer, boolean flush, boolean batched) {
        this.write(buffer, flush, batched, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ActiveMQBuffer buffer, boolean flush, boolean batched, final ChannelFutureListener futureListener) {
        block16: {
            try {
                this.writeLock.acquire();
                try {
                    if (this.batchBuffer == null && this.batchingEnabled && batched && !flush) {
                        this.batchBuffer = ActiveMQBuffers.dynamicBuffer(8192);
                    }
                    if (this.batchBuffer != null) {
                        this.batchBuffer.writeBytes(buffer, 0, buffer.writerIndex());
                        if (this.batchBuffer.writerIndex() < 8192 && batched && !flush) {
                            return;
                        }
                        buffer = this.batchBuffer;
                        this.batchBuffer = !batched || flush ? null : ActiveMQBuffers.dynamicBuffer(8192);
                    }
                    final ByteBuf buf = buffer.byteBuf();
                    final ChannelPromise promise = flush || futureListener != null ? this.channel.newPromise() : this.channel.voidPromise();
                    EventLoop eventLoop = this.channel.eventLoop();
                    boolean inEventLoop = eventLoop.inEventLoop();
                    if (!inEventLoop) {
                        if (futureListener != null) {
                            this.channel.writeAndFlush(buf, promise).addListener(futureListener);
                        } else {
                            this.channel.writeAndFlush(buf, promise);
                        }
                    } else {
                        Runnable task = new Runnable(){

                            @Override
                            public void run() {
                                if (futureListener != null) {
                                    NettyConnection.this.channel.writeAndFlush(buf, promise).addListener(futureListener);
                                } else {
                                    NettyConnection.this.channel.writeAndFlush(buf, promise);
                                }
                            }
                        };
                        eventLoop.execute(task);
                    }
                    if (!flush || inEventLoop) break block16;
                    try {
                        boolean ok = promise.await(10000L);
                        if (!ok) {
                            ActiveMQClientLogger.LOGGER.timeoutFlushingPacket();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new ActiveMQInterruptedException(e);
                    }
                }
                finally {
                    this.writeLock.release();
                }
            }
            catch (InterruptedException e) {
                throw new ActiveMQInterruptedException(e);
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        SocketAddress address = this.channel.remoteAddress();
        if (address == null) {
            return null;
        }
        return address.toString();
    }

    @Override
    public String getLocalAddress() {
        SocketAddress address = this.channel.localAddress();
        if (address == null) {
            return null;
        }
        return "tcp://" + IPV6Util.encloseHost(address.toString());
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.readyListeners.add(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.readyListeners.remove(listener);
    }

    @Override
    public ActiveMQPrincipal getDefaultActiveMQPrincipal() {
        return null;
    }

    void fireReady(boolean ready) {
        for (ReadyListener listener : this.readyListeners) {
            listener.readyForWriting(ready);
        }
    }

    @Override
    public TransportConfiguration getConnectorConfig() {
        if (this.configuration != null) {
            return new TransportConfiguration(NettyConnectorFactory.class.getName(), this.configuration);
        }
        return null;
    }

    @Override
    public boolean isUsingProtocolHandling() {
        return true;
    }

    public String toString() {
        return super.toString() + "[local= " + this.channel.localAddress() + ", remote=" + this.channel.remoteAddress() + "]";
    }

    private void closeSSLAndChannel(SslHandler sslHandler, Channel channel) {
        ChannelFuture closeFuture;
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close();
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    ActiveMQClientLogger.LOGGER.timeoutClosingSSL();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = channel.close()).awaitUninterruptibly(10000L)) {
            ActiveMQClientLogger.LOGGER.timeoutClosingNettyChannel();
        }
    }
}

