/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ScaleDownAnnounceMessage
extends PacketImpl {
    private SimpleString targetNodeId;
    private SimpleString scaledDownNodeId;

    public ScaleDownAnnounceMessage() {
        super((byte)-6);
    }

    public ScaleDownAnnounceMessage(SimpleString targetNodeId, SimpleString scaledDownNodeId) {
        super((byte)-6);
        this.targetNodeId = targetNodeId;
        this.scaledDownNodeId = scaledDownNodeId;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.targetNodeId);
        buffer.writeSimpleString(this.scaledDownNodeId);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.targetNodeId = buffer.readSimpleString();
        this.scaledDownNodeId = buffer.readSimpleString();
    }

    public SimpleString getTargetNodeId() {
        return this.targetNodeId;
    }

    public SimpleString getScaledDownNodeId() {
        return this.scaledDownNodeId;
    }
}

