/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.config;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;

public class PersistedAddressSetting
implements EncodingSupport {
    private long storeId;
    private SimpleString addressMatch;
    private AddressSettings setting;

    public PersistedAddressSetting() {
    }

    public String toString() {
        return "PersistedAddressSetting [storeId=" + this.storeId + ", addressMatch=" + this.addressMatch + ", setting=" + this.setting + "]";
    }

    public PersistedAddressSetting(SimpleString addressMatch, AddressSettings setting) {
        this.addressMatch = addressMatch;
        this.setting = setting;
    }

    public void setStoreId(long id) {
        this.storeId = id;
    }

    public long getStoreId() {
        return this.storeId;
    }

    public SimpleString getAddressMatch() {
        return this.addressMatch;
    }

    public AddressSettings getSetting() {
        return this.setting;
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.addressMatch = buffer.readSimpleString();
        this.setting = new AddressSettings();
        this.setting.decode(buffer);
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.addressMatch);
        this.setting.encode(buffer);
    }

    @Override
    public int getEncodeSize() {
        return this.addressMatch.sizeof() + this.setting.getEncodeSize();
    }
}

