/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.SessionContinuationMessage;

public class SessionSendContinuationMessage
extends SessionContinuationMessage {
    private boolean requiresResponse;
    private MessageInternal message;
    private final transient SendAcknowledgementHandler handler;
    private long messageBodySize = -1L;

    public SessionSendContinuationMessage() {
        super((byte)73);
        this.handler = null;
    }

    public SessionSendContinuationMessage(MessageInternal message, byte[] body, boolean continues, boolean requiresResponse, long messageBodySize, SendAcknowledgementHandler handler) {
        super((byte)73, body, continues);
        this.requiresResponse = requiresResponse;
        this.message = message;
        this.handler = handler;
        this.messageBodySize = messageBodySize;
    }

    public boolean isRequiresResponse() {
        return this.requiresResponse;
    }

    public long getMessageBodySize() {
        return this.messageBodySize;
    }

    public MessageInternal getMessage() {
        return this.message;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        super.encodeRest(buffer);
        if (!this.continues) {
            buffer.writeLong(this.messageBodySize);
        }
        buffer.writeBoolean(this.requiresResponse);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        super.decodeRest(buffer);
        if (!this.continues) {
            this.messageBodySize = buffer.readLong();
        }
        this.requiresResponse = buffer.readBoolean();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (int)(this.messageBodySize ^ this.messageBodySize >>> 32);
        result = 31 * result + (this.requiresResponse ? 1231 : 1237);
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", continues=" + this.continues);
        buff.append(", message=" + this.message);
        buff.append(", messageBodySize=" + this.messageBodySize);
        buff.append(", requiresResponse=" + this.requiresResponse);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionSendContinuationMessage)) {
            return false;
        }
        SessionSendContinuationMessage other = (SessionSendContinuationMessage)obj;
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageBodySize != other.messageBodySize) {
            return false;
        }
        return this.requiresResponse == other.requiresResponse;
    }

    public SendAcknowledgementHandler getHandler() {
        return this.handler;
    }
}

