/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.jms.client.ActiveMQBytesMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnection;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSClientBundle;
import org.apache.activemq.artemis.jms.client.ActiveMQMapMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQObjectMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQStreamMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQTextMessage;
import org.apache.activemq.artemis.jms.client.ConnectionFactoryOptions;
import org.apache.activemq.artemis.jms.client.JMSExceptionHelper;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class ActiveMQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private final ConnectionFactoryOptions options;
    private final ActiveMQConnection connection;
    private final SimpleString connID;
    private final ClientProducer clientProducer;
    private final ClientSession clientSession;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int defaultPriority = 4;
    private long defaultTimeToLive = 0L;
    private int defaultDeliveryMode = 2;
    private long defaultDeliveryDelay = 0L;
    private final ActiveMQDestination defaultDestination;

    protected ActiveMQMessageProducer(ActiveMQConnection connection, ClientProducer producer, ActiveMQDestination defaultDestination, ClientSession clientSession, ConnectionFactoryOptions options) throws JMSException {
        this.options = options;
        this.connection = connection;
        this.connID = connection.getClientID() != null ? new SimpleString(connection.getClientID()) : connection.getUID();
        this.clientProducer = producer;
        this.defaultDestination = defaultDestination;
        this.clientSession = clientSession;
    }

    @Override
    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    @Override
    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    @Override
    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageTimestamp = value;
    }

    @Override
    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableMessageTimestamp;
    }

    @Override
    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.checkClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            throw ActiveMQJMSClientBundle.BUNDLE.illegalDeliveryMode(deliveryMode);
        }
        this.defaultDeliveryMode = deliveryMode;
    }

    @Override
    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    @Override
    public void setPriority(int defaultPriority) throws JMSException {
        this.checkClosed();
        if (defaultPriority < 0 || defaultPriority > 9) {
            throw new JMSException("Illegal priority value: " + defaultPriority);
        }
        this.defaultPriority = defaultPriority;
    }

    @Override
    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    @Override
    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        this.defaultTimeToLive = timeToLive;
    }

    @Override
    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTimeToLive;
    }

    @Override
    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.defaultDestination;
    }

    @Override
    public void close() throws JMSException {
        this.connection.getThreadAwareContext().assertNotCompletionListenerThread();
        try {
            this.clientProducer.close();
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
    }

    @Override
    public void send(javax.jms.Message message) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, null);
    }

    @Override
    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void send(Destination destination, javax.jms.Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive);
    }

    @Override
    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkClosed();
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        this.defaultDeliveryDelay = deliveryDelay;
    }

    @Override
    public long getDeliveryDelay() throws JMSException {
        return this.defaultDeliveryDelay;
    }

    @Override
    public void send(javax.jms.Message message, CompletionListener completionListener) throws JMSException {
        this.send(message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    @Override
    public void send(javax.jms.Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkCompletionListener(completionListener);
        this.checkDefaultDestination();
        this.doSendx(this.defaultDestination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, javax.jms.Message message, CompletionListener completionListener) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTimeToLive, completionListener);
    }

    @Override
    public void send(Destination destination, javax.jms.Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkClosed();
        this.checkCompletionListener(completionListener);
        this.checkDestination(destination);
        this.doSendx((ActiveMQDestination)destination, message, deliveryMode, priority, timeToLive, completionListener);
    }

    @Override
    public Topic getTopic() throws JMSException {
        return (Topic)this.getDestination();
    }

    @Override
    public void publish(javax.jms.Message message) throws JMSException {
        this.send(message);
    }

    @Override
    public void publish(Topic topic, javax.jms.Message message) throws JMSException {
        this.send(topic, message);
    }

    @Override
    public void publish(javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(message, deliveryMode, priority, timeToLive);
    }

    @Override
    public void publish(Topic topic, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(topic);
        this.doSendx((ActiveMQDestination)((Object)topic), message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public void send(Queue queue, javax.jms.Message message) throws JMSException {
        this.send((Destination)queue, message);
    }

    @Override
    public void send(Queue queue, javax.jms.Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkDestination(queue);
        this.doSendx((ActiveMQDestination)((Object)queue), message, deliveryMode, priority, timeToLive, null);
    }

    @Override
    public Queue getQueue() throws JMSException {
        return (Queue)this.getDestination();
    }

    public String toString() {
        return "ActiveMQMessageProducer->" + this.clientProducer;
    }

    private void checkDefaultDestination() {
        if (this.defaultDestination == null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
    }

    private void checkDestination(Destination destination) throws InvalidDestinationException {
        if (destination != null && !(destination instanceof ActiveMQDestination)) {
            throw new InvalidDestinationException("Foreign destination:" + destination);
        }
        if (destination != null && this.defaultDestination != null) {
            throw new UnsupportedOperationException("Cannot specify destination if producer has a default destination");
        }
        if (destination == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullTopic();
        }
    }

    private void checkCompletionListener(CompletionListener completionListener) {
        if (completionListener == null) {
            throw ActiveMQJMSClientBundle.BUNDLE.nullArgumentNotAllowed("CompletionListener");
        }
    }

    private void doSendx(ActiveMQDestination destination, javax.jms.Message jmsMessage, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        ActiveMQMessage activeMQJmsMessage;
        jmsMessage.setJMSDeliveryMode(deliveryMode);
        jmsMessage.setJMSPriority(priority);
        if (timeToLive == 0L) {
            jmsMessage.setJMSExpiration(0L);
        } else {
            jmsMessage.setJMSExpiration(System.currentTimeMillis() + timeToLive);
        }
        if (!this.disableMessageTimestamp) {
            jmsMessage.setJMSTimestamp(System.currentTimeMillis());
        } else {
            jmsMessage.setJMSTimestamp(0L);
        }
        SimpleString address = null;
        if (destination == null) {
            if (this.defaultDestination == null) {
                throw new UnsupportedOperationException("Destination must be specified on send with an anonymous producer");
            }
            destination = this.defaultDestination;
        } else {
            if (this.defaultDestination != null && !destination.equals(this.defaultDestination)) {
                throw new UnsupportedOperationException("Where a default destination is specified for the sender and a destination is specified in the arguments to the send, these destinations must be equal");
            }
            address = destination.getSimpleAddress();
            if (!this.connection.containsKnownDestination(address)) {
                try {
                    ClientSession.AddressQuery query = this.clientSession.addressQuery(address);
                    if (!query.isExists() && (address.toString().startsWith("jms.queue.") && !query.isAutoCreateJmsQueues() || address.toString().startsWith("jms.topic.") && !query.isAutoCreateJmsTopics())) {
                        throw new InvalidDestinationException("Destination " + address + " does not exist");
                    }
                    this.connection.addKnownDestination(address);
                }
                catch (ActiveMQException e) {
                    throw JMSExceptionHelper.convertFromActiveMQException(e);
                }
            }
        }
        boolean foreign = false;
        if (!(jmsMessage instanceof ActiveMQMessage)) {
            activeMQJmsMessage = jmsMessage instanceof BytesMessage ? new ActiveMQBytesMessage((BytesMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof MapMessage ? new ActiveMQMapMessage((MapMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof ObjectMessage ? new ActiveMQObjectMessage((ObjectMessage)jmsMessage, this.clientSession, this.options) : (jmsMessage instanceof StreamMessage ? new ActiveMQStreamMessage((StreamMessage)jmsMessage, this.clientSession) : (jmsMessage instanceof TextMessage ? new ActiveMQTextMessage((TextMessage)jmsMessage, this.clientSession) : new ActiveMQMessage(jmsMessage, this.clientSession)))));
            jmsMessage.setJMSDestination(destination);
            foreign = true;
        } else {
            activeMQJmsMessage = (ActiveMQMessage)jmsMessage;
        }
        if (!this.disableMessageID) {
            UUID uid = UUIDGenerator.getInstance().generateUUID();
            activeMQJmsMessage.getCoreMessage().setUserID(uid);
            activeMQJmsMessage.resetMessageID(null);
        }
        if (foreign) {
            jmsMessage.setJMSMessageID(activeMQJmsMessage.getJMSMessageID());
        }
        activeMQJmsMessage.setJMSDestination(destination);
        try {
            activeMQJmsMessage.doBeforeSend();
        }
        catch (Exception e) {
            JMSException je = new JMSException(e.getMessage());
            je.initCause(e);
            throw je;
        }
        if (this.defaultDeliveryDelay > 0L) {
            activeMQJmsMessage.setJMSDeliveryTime(System.currentTimeMillis() + this.defaultDeliveryDelay);
        }
        ClientMessage coreMessage = activeMQJmsMessage.getCoreMessage();
        coreMessage.putStringProperty(ActiveMQConnection.CONNECTION_ID_PROPERTY_NAME, this.connID);
        try {
            if (completionListener != null) {
                this.clientProducer.send(address, coreMessage, new CompletionListenerWrapper(completionListener, jmsMessage, this));
            } else {
                this.clientProducer.send(address, (Message)coreMessage);
            }
        }
        catch (ActiveMQInterruptedException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.initCause(e);
            throw jmsException;
        }
        catch (ActiveMQException e) {
            throw JMSExceptionHelper.convertFromActiveMQException(e);
        }
        catch (java.lang.IllegalStateException e) {
            IllegalStateException je = new IllegalStateException(e.getMessage());
            je.setStackTrace(e.getStackTrace());
            je.initCause(e);
            throw je;
        }
    }

    private void checkClosed() throws JMSException {
        if (this.clientProducer.isClosed() || this.clientSession.isClosed()) {
            throw new IllegalStateException("Producer is closed");
        }
    }

    private static final class CompletionListenerWrapper
    implements SendAcknowledgementHandler {
        private final CompletionListener completionListener;
        private final javax.jms.Message jmsMessage;
        private final ActiveMQMessageProducer producer;

        private CompletionListenerWrapper(CompletionListener listener, javax.jms.Message jmsMessage, ActiveMQMessageProducer producer) {
            this.completionListener = listener;
            this.jmsMessage = jmsMessage;
            this.producer = producer;
        }

        @Override
        public void sendAcknowledged(Message clientMessage) {
            if (this.jmsMessage instanceof StreamMessage) {
                try {
                    ((StreamMessage)this.jmsMessage).reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            if (this.jmsMessage instanceof BytesMessage) {
                try {
                    ((BytesMessage)this.jmsMessage).reset();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            try {
                this.producer.connection.getThreadAwareContext().setCurrentThread(true);
                this.completionListener.onCompletion(this.jmsMessage);
            }
            finally {
                this.producer.connection.getThreadAwareContext().clearCurrentThread(true);
            }
        }

        public String toString() {
            return CompletionListenerWrapper.class.getSimpleName() + "( completionListener=" + this.completionListener + ")";
        }
    }
}

