/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.remoting3.ConnectionProviderFactoryBuilder;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.EndpointImpl;
import org.jboss.remoting3.security.RemotingPermission;
import org.xnio.OptionMap;
import org.xnio.XnioWorker;

public final class EndpointBuilder {
    private String endpointName;
    private XnioWorker xnioWorker;
    private OptionMap xnioWorkerOptions;
    private List<ConnectionProviderFactoryBuilder> connectionProviderFactoryBuilders;
    private SocketAddress defaultBindAddress;

    EndpointBuilder() {
    }

    public EndpointBuilder setEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public EndpointBuilder setXnioWorker(XnioWorker xnioWorker) {
        this.xnioWorker = xnioWorker;
        return this;
    }

    public EndpointBuilder setXnioWorkerOptions(OptionMap xnioWorkerOptions) {
        this.xnioWorkerOptions = xnioWorkerOptions;
        return this;
    }

    public ConnectionProviderFactoryBuilder addProvider(String scheme) {
        ConnectionProviderFactoryBuilder builder = new ConnectionProviderFactoryBuilder(scheme);
        if (this.connectionProviderFactoryBuilders == null) {
            this.connectionProviderFactoryBuilders = new ArrayList<ConnectionProviderFactoryBuilder>();
            this.connectionProviderFactoryBuilders.add(builder);
        }
        return builder;
    }

    public void setDefaultBindAddress(SocketAddress defaultBindAddress) {
        this.defaultBindAddress = defaultBindAddress;
    }

    String getEndpointName() {
        return this.endpointName;
    }

    XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    OptionMap getXnioWorkerOptions() {
        return this.xnioWorkerOptions;
    }

    List<ConnectionProviderFactoryBuilder> getConnectionProviderFactoryBuilders() {
        return this.connectionProviderFactoryBuilders;
    }

    SocketAddress getDefaultBindAddress() {
        return this.defaultBindAddress;
    }

    public Endpoint build() throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RemotingPermission.CREATE_ENDPOINT);
        }
        try {
            return AccessController.doPrivileged(() -> EndpointImpl.construct(this));
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }
}

