/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.regex.Pattern;

public final class HostName {
    private static final String hostName;
    private static final String qualifiedHostName;

    static InetAddress getLocalHost() throws UnknownHostException {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            addr = InetAddress.getByName(null);
        }
        return addr;
    }

    public static String getHostName() {
        return hostName;
    }

    public static String getQualifiedHostName() {
        return qualifiedHostName;
    }

    static {
        String[] names = AccessController.doPrivileged(() -> {
            String qualifiedHostName = System.getProperty("jboss.qualified.host.name");
            String providedHostName = System.getProperty("jboss.host.name");
            if (qualifiedHostName == null) {
                qualifiedHostName = providedHostName;
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("HOSTNAME");
                }
                if (qualifiedHostName == null) {
                    qualifiedHostName = System.getenv("COMPUTERNAME");
                }
                if (qualifiedHostName == null) {
                    try {
                        qualifiedHostName = HostName.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException e) {
                        qualifiedHostName = null;
                    }
                }
                if (qualifiedHostName != null && Pattern.compile("^\\d+\\.\\d+\\.\\d+\\.\\d+$|:").matcher(qualifiedHostName).find()) {
                    qualifiedHostName = null;
                }
                qualifiedHostName = qualifiedHostName == null ? "unknown-host.unknown-domain" : qualifiedHostName.trim().toLowerCase();
            }
            if (providedHostName == null) {
                int idx = qualifiedHostName.indexOf(46);
                providedHostName = idx == -1 ? qualifiedHostName : qualifiedHostName.substring(0, idx);
            }
            return new String[]{providedHostName, qualifiedHostName};
        });
        hostName = names[0];
        qualifiedHostName = names[1];
    }
}

